package com.mediamain.android.nativead.jsbridgeimpl.handler;


import org.json.JSONException;
import org.json.JSONObject;

import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.nativead.jsbridge.CallBackFunction;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.jsbridgeimpl.interfaces.H5CallBack;


/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019/3/9-10:50
 * 描    述：提供给前端调用的本地方法
 * 修订历史：
 * ================================================
 */
public abstract class BaseJsBridgeHandler {

    public String TAG;
    protected BaseJsBridgeWebView mWebView;
    protected H5CallBack mJsBridgeCallBack;

    public BaseJsBridgeHandler(BaseJsBridgeWebView webView, H5CallBack jsBridgeCallBack) {
        this.mWebView = webView;
        this.mJsBridgeCallBack = jsBridgeCallBack;
        TAG = this.getClass().getSimpleName();
    }


    /**
     * 注册本地方方法的名字
     *
     * @return
     */
    public abstract String getName();

    /**
     * h5调用本地方法的回调
     *
     * @param data             h5的传参
     * @param callBackFunction 回调给h5前端
     */
    public abstract void callBack(JSONObject data, CallBackFunction callBackFunction);

    /**
     * @param methodName 方法名称
     * @param data       符合json格式的前端数据
     */
    public void callH5Msg(String methodName, String data) {
        try {
            new JSONObject(data);
            //检查返回给前端的数据是否符合json格式
            if (mWebView != null) {
                mWebView.callHandler(methodName, data, new CallBackFunction() {
                    @Override
                    public void onCallBack(String data) {

                    }
                });
            }
        } catch (JSONException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }
}
