package com.mediamain.android.nativead.jsbridgeimpl.handler;

import android.util.Log;

import com.mediamain.android.base.util.FoxBaseEncodeUtils;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseGsonUtil;
import com.mediamain.android.nativead.bean.AdResponseBean;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.jsbridgeimpl.bean.JsBridgeHandlerName;
import com.mediamain.android.nativead.jsbridgeimpl.interfaces.H5CallBack;
import com.mediamain.android.nativead.Ad;
import com.mediamain.android.nativead.jsbridge.CallBackFunction;
import org.json.JSONObject;


/**
 * ================================================
 * 作    者：lzy
 * 版    本：1.0
 * 创建日期：2019/12/16
 * 描    述：提供token的本地方法
 * 修订历史：
 * ================================================
 */
public class GetActInfoJsBridgeHandler extends BaseJsBridgeHandler {

    private Ad mAd;

    public GetActInfoJsBridgeHandler(Ad ad, BaseJsBridgeWebView webView, H5CallBack jsBridgeCallBack) {
        super(webView, jsBridgeCallBack);
        this.mAd = ad;
    }

    /**
     * 注册本地方方法的名字
     *
     * @return
     */
    @Override
    public String getName() {
        return JsBridgeHandlerName.GET_ACT_INFO;
    }

    /**
     * h5调用本地方法的回调
     *
     * @param data             h5的传参
     * @param callBackFunction 回调给h5前端
     */
    @Override
    public void callBack(JSONObject data, CallBackFunction callBackFunction) {
        Log.v(TAG, "====callBack======="+callBackFunction);
        if (callBackFunction!= null) {
            if (mAd!=null && mAd.getData()!=null){
                AdResponseBean.DataBean dataBean =new AdResponseBean.DataBean();
                if (!FoxBaseCommonUtils.isEmpty(mAd.getData().getActivityUrl())){
                    dataBean.setActivityUrl(FoxBaseEncodeUtils.urlEncode(mAd.getData().getActivityUrl()));
                }
                if (!FoxBaseCommonUtils.isEmpty(mAd.getData().getReportClickUrl())) {
                    dataBean.setReportClickUrl(FoxBaseEncodeUtils.urlEncode(mAd.getData().getReportClickUrl()));
                }
                if (!FoxBaseCommonUtils.isEmpty(mAd.getData().getReportExposureUrl())) {
                    dataBean.setReportExposureUrl(FoxBaseEncodeUtils.urlEncode(mAd.getData().getReportExposureUrl()));
                }
                if (!FoxBaseCommonUtils.isEmpty(mAd.getData().getImageUrl())) {
                    dataBean.setImageUrl(FoxBaseEncodeUtils.urlEncode(mAd.getData().getImageUrl()));
                }
                callBackFunction.onCallBack(FoxBaseGsonUtil.GsonString(dataBean));
            }else {
                callBackFunction.onCallBack("");
            }
        }
    }
}
