package com.mediamain.android.nativead.jsbridgeimpl.handler;


import java.util.ArrayList;
import java.util.List;

import com.mediamain.android.nativead.jsbridgeimpl.interfaces.H5CallBack;
import com.mediamain.android.nativead.Ad;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;

/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019/3/9-11:07
 * 描    述：jsbridge 列表
 * 修订历史：
 * ================================================
 */
public class JsBridgeList {

    private BaseJsBridgeWebView mWebView;
    private H5CallBack mJsBridgeCallBack;

    public JsBridgeList(BaseJsBridgeWebView webView, H5CallBack jsBridgeCallBack) {
        this.mWebView = webView;
        this.mJsBridgeCallBack = jsBridgeCallBack;
    }

    /**
     * 通用WebView的本地方法列表
     */
    public List<BaseJsBridgeHandler> getCommHandlers(Ad ad) {
        List<BaseJsBridgeHandler> commHandlers = new ArrayList<>();
        commHandlers.add(new GetActInfoJsBridgeHandler(ad,mWebView, mJsBridgeCallBack));
        commHandlers.add(new MoadlCloseJsBridgeHandler(mWebView, mJsBridgeCallBack));
        commHandlers.add(new MoadlShowJsBridgeHandler(mWebView, mJsBridgeCallBack));
        commHandlers.add(new Jump2LandJsBridgeHandler(mWebView, mJsBridgeCallBack));
        commHandlers.add(new GetInfoJsBridgeHandler(mWebView, mJsBridgeCallBack));
        commHandlers.add(new MyPrizeJsBridgeHandler(mWebView, mJsBridgeCallBack));
        commHandlers.add(new ChangeActivityJsBridgeHandler(mWebView, mJsBridgeCallBack));
        commHandlers.add(new InitRewardWebViewJsBridgeHandler(mWebView, mJsBridgeCallBack));
        commHandlers.add(new RewardDialogBridgeHandler(mWebView, mJsBridgeCallBack));
        return commHandlers;
    }


}
