package com.mediamain.android.nativead.jsbridgeimpl.handler;

import org.json.JSONObject;

import com.mediamain.android.nativead.jsbridgeimpl.interfaces.H5CallBack;
import com.mediamain.android.nativead.jsbridge.CallBackFunction;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.jsbridgeimpl.bean.JsBridgeHandlerName;

import android.util.Log;


/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019/3/9-10:50
 * 描    述：提供token的本地方法
 * 修订历史：
 * ================================================
 */
public class MyPrizeJsBridgeHandler extends BaseJsBridgeHandler {
    public MyPrizeJsBridgeHandler(BaseJsBridgeWebView webView, H5CallBack jsBridgeCallBack) {
        super(webView, jsBridgeCallBack);
    }

    /**
     * 注册本地方方法的名字
     *
     * @return
     */
    @Override
    public String getName() {
        return JsBridgeHandlerName.MY_PRIZE;
    }

    /**
     * h5调用本地方法的回调
     *
     * @param data             h5的传参
     * @param callBackFunction 回调给h5前端
     */
    @Override
    public void callBack(JSONObject data, CallBackFunction callBackFunction) {
        Log.v(TAG, "====callBack=======");
        if (mJsBridgeCallBack != null) {
            mJsBridgeCallBack.myPrize(mWebView.getWebViewType(), data);
        }
    }
}
