package com.mediamain.android.nativead.jsbridgeimpl.handler;

import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.nativead.jsbridgeimpl.interfaces.H5CallBack;
import com.mediamain.android.nativead.jsbridge.CallBackFunction;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.jsbridgeimpl.bean.JsBridgeHandlerName;

import org.json.JSONException;
import org.json.JSONObject;


public class RewardDialogBridgeHandler extends BaseJsBridgeHandler {

    public RewardDialogBridgeHandler(BaseJsBridgeWebView webView, H5CallBack jsBridgeCallBack) {
        super(webView, jsBridgeCallBack);
    }

    @Override
    public String getName() {
        return JsBridgeHandlerName.REWARD_DIALOGSHOW;
    }

    @Override
    public void callBack(JSONObject data, CallBackFunction callBackFunction) {
        if (mJsBridgeCallBack != null) {
            try {
                String type = data.getString("type");
                if (type.equals("modal")) {
                    mJsBridgeCallBack.setRewardShow(true);
                    mJsBridgeCallBack.setLandPageShow(false);
                } else if (type.equals("landpage")) {
                    mJsBridgeCallBack.setLandPageShow(true);
                    mJsBridgeCallBack.setRewardShow(false);
                }
            } catch (JSONException e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }
    }
}
