package com.mediamain.android.nativead.listener;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.core.cause.EndCause;

public interface TmDownloadListener {

    /**
     * 下载行为开始
     * @param downloadUrl
     */
    void taskInit(String downloadUrl);


    void taskStart(@NonNull DownloadTask task);

    void fetchProgress(@NonNull DownloadTask task,
                       long currentOffset, long totalLength);


    void taskEnd(@NonNull DownloadTask task, @NonNull EndCause cause,
                 @Nullable Exception realCause);
}
