package com.mediamain.android.nativead.util;

import android.content.Context;
import android.os.Environment;

import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import static android.os.Environment.MEDIA_MOUNTED;

public class FileUtil {
    private static final String TAG = "FileUtil";


    public static String getDownLoadPath(Context context, String dir) {
        String directoryPath = "";
        if (MEDIA_MOUNTED.equals(Environment.getExternalStorageState())) {// 判断外部存储是否可用
            directoryPath = context.getExternalFilesDir(dir).getAbsolutePath();
        } else {// 没外部存储就使用内部存储
            directoryPath = context.getFilesDir() + File.separator + dir;
        }
        File file = new File(directoryPath);
        if (!file.exists()) {// 判断文件目录是否存在
            file.mkdirs();
        }
        return directoryPath;
    }



    public static String encryptMD5ToString(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("String to encript cannot be null or zero length");
        }
        StringBuffer hexString = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] hash = md.digest();
            for (int i = 0; i < hash.length; i++) {
                if ((0xff & hash[i]) < 0x10) {
                    hexString.append("0" + Integer.toHexString((0xFF & hash[i])));
                } else {
                    hexString.append(Integer.toHexString(0xFF & hash[i]));
                }
            }
        } catch (NoSuchAlgorithmException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            FoxBaseLogUtils.eTag(TAG, "encryptMD5ToString error : " + e.getMessage());
        }
        return hexString.toString();
    }
}
