package com.mediamain.android.nativead.util;

import android.text.TextUtils;
import android.util.Base64;

import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.util.zip.GZIPOutputStream;

public class GzipUtils {
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";

    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";
    /**
     * Gzip 压缩数据
     *
     * @param unGzipStr
     * @return
     */
    public static String compressForGzip(String unGzipStr) {

        if (TextUtils.isEmpty(unGzipStr)) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            gzip.write(unGzipStr.getBytes(GZIP_ENCODE_UTF_8));
            gzip.close();
            byte[] encode = baos.toByteArray();
            baos.flush();
            baos.close();
            String s = URLEncoder.encode(Base64.encodeToString(encode,Base64.NO_WRAP),"UTF-8");
            String result =  URLEncoder.encode(s,"UTF-8");
            FoxBaseLogUtils.dTag(null,"s  is  "+s,"  result is  "+ result);
            return result;
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
            FoxBaseLogUtils.eTag("gzip", "gzip error : " + e.getMessage());
        }
        return null;
    }

}
