package com.mediamain.android.nativead.util;

import android.text.TextUtils;
import java.util.Set;
import okhttp3.HttpUrl;

/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019/3/16-15:38
 * 描    述：
 * 修订历史：
 * ================================================
 */
public class HttpUrlUtil {
    /**
     * 判断URL是否存在参数
     *
     * @param url
     * @return boolean
     */
    public static boolean urlHasNoQueryParams(String url) {
        if (url.contains("/#/")) {
            ///#/会导致url解析有问题
            url = url.replaceAll("/#", "");
        }
        HttpUrl httpUrl = HttpUrl.parse(url);
        if (httpUrl == null) {
            return true;
        }
        Set<String> querys = httpUrl.queryParameterNames();
        if (querys.size() == 0) {
            return true;
        }
        return false;
    }


    /**
     * 对老的链接拼接公共参数
     *
     * @param url
     * @return newUrl
     */
    public static String jointCommParams4Url(String url) {
        String newUrl = url;
        if (urlHasNoQueryParams(url)) {
            newUrl += "?";
            if (!newUrl.contains("clientType")) {
                newUrl += "clientType=android&fromAndroid=true";
            }
        } else {
            if (!newUrl.contains("clientType")) {
                newUrl += "&clientType=android&fromAndroid=true";
            }
        }
        return newUrl;
    }

    /**
     * 检查是否是下载链接地址
     *
     * @param url
     * @return
     */
    public static boolean checkURLIsDownload(String url) {
        HttpUrl httpUrl = HttpUrl.parse(url);
        if (httpUrl == null) {
            return false;
        }
        String jumpUrl = httpUrl.queryParameter("url");
        if (TextUtils.isEmpty(jumpUrl)) {
            return false;
        }
        if (jumpUrl.endsWith(".apk")) {
            return true;
        }

        return false;
    }

    /**
     * 检查是否是下载链接地址
     *
     * @param url
     * @return
     */
    public static String getApkUrl(String url) {
        HttpUrl httpUrl = HttpUrl.parse(url);
        if (httpUrl == null) {
            return "";
        }
        String downloadUrl = httpUrl.queryParameter("url");

        return downloadUrl;
    }


}
