package com.mediamain.android.nativead.util;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.util.FoxBaseAppUtil;
import com.mediamain.android.base.util.FoxBaseClickUtils;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseConvertUtils;
import com.mediamain.android.base.util.FoxBaseDownloadDialog;
import com.mediamain.android.base.util.FoxBaseEncryptUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.FoxBaseScreenUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.nativead.AdConstants;
import com.mediamain.android.base.data.FoxBaseNewDownloadBean;
import com.mediamain.android.base.util.xpopup.XPopup;
import com.mediamain.android.base.util.xpopup.core.BasePopupView;
import com.mediamain.android.BuildConfig;

import org.json.JSONObject;

import java.io.File;
import java.util.UUID;

import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_APK_DOWN_SCENES_4;

public class TuiaUtil {

    /**
     * 获取屏幕短边的长度
     *
     * @return
     */
    public static int getScreenShortSide() {
        int screenWidth = FoxBaseScreenUtils.getScreenWidth();
        int screenHeight = FoxBaseScreenUtils.getScreenHeight();
        if (screenWidth > screenHeight) {
            return screenHeight;
        } else {
            return screenWidth;
        }
    }


    /**
     * 获取屏幕长边的长度
     *
     * @return
     */
    public static int getScreenLongSide() {
        int screenWidth = FoxBaseScreenUtils.getScreenWidth();
        int screenHeight = FoxBaseScreenUtils.getScreenHeight();
        if (screenWidth > screenHeight) {
            return screenWidth;
        } else {
            return screenHeight;
        }
    }

    // 获取手机的唯一标识
    public static String getPhoneSign(Context context) {
        StringBuilder deviceId = new StringBuilder();
        // 渠道标志
        deviceId.append("a");
        try {
            // IMEI（imei）
            TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            @SuppressLint("MissingPermission")
            String imei = tm.getDeviceId();
            if (!TextUtils.isEmpty(imei)) {
                deviceId.append("imei");
                deviceId.append(imei);
                return deviceId.toString();
            }
            // 序列号（sn）
            @SuppressLint("MissingPermission")
            String sn = tm.getSimSerialNumber();
            if (!TextUtils.isEmpty(sn)) {
                deviceId.append("sn");
                deviceId.append(sn);
                return deviceId.toString();
            }
            // 如果上面都没有， 则生成一个id：随机码
            String uuid = getUUID();
            if (!TextUtils.isEmpty(uuid)) {
                deviceId.append("id");
                deviceId.append(uuid);
                return deviceId.toString();
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
            deviceId.append("id").append(getUUID());
        }
        return deviceId.toString();
    }

    /**
     * 得到全局唯一UUID
     */
    public static String uuid;

    public static String getUUID() {
        uuid = FoxBaseSPUtils.getInstance().getString("uuid", "");

        if (TextUtils.isEmpty(uuid)) {
            uuid = UUID.randomUUID().toString();
            FoxBaseSPUtils.getInstance().setString("uuid", uuid);
        }
        return uuid;
    }

    private static final String TAG = "TuiaUtil";

    /**
     * 替换原有的html
     *
     * @param strHtml
     * @param jsonObject
     * @return
     */
    public static String replaceRewardHtml(String strHtml, JSONObject jsonObject) throws Exception {
        strHtml = strHtml.replace("$jsPath", jsonObject.getString("jsUrl")).replace("$screenWidth", "" + FoxBaseConvertUtils.px2dp(getScreenShortSide()))
                .replace("$screenHeight", "" + FoxBaseConvertUtils.px2dp(getScreenLongSide())).replace("$tuiaModalData", jsonObject.toString());

        return strHtml;
    }

    /**
     * 处理app安装
     *
     * @param url
     */
    private static boolean toInstallApp(Context mContext, String url) {
        if (mContext != null && !FoxBaseCommonUtils.isEmpty(url)) {
            final File file2 = FoxBaseCommonUtils.checkFileExit(AdConstants.CACHE_NAME
                    , FoxBaseEncryptUtils.encryptMD5ToString(url) + "tm.apk");
            if (file2 != null && file2.exists()) {
                FoxBaseAppUtil.openFile(mContext, file2);
                return true;
            }
        }
        return false;
    }

    /**
     * 下载和安装
     *
     * @param url
     */
    public static void downloadAndInstall(final Activity activity,String slotId, final String url) {
        if (activity == null || FoxBaseCommonUtils.isEmpty(url)){
            return;
        }
        if (toInstallApp(activity,url)){
            return;
        }else {
            dealNewDowdload(activity,slotId, url);
        }
    }

    /**
     * 原生插屏处理新下载器样式
     * @param activity
     * @param url
     */
    public static void dealNewDowdload(Activity activity,String slotId, String url) {
        try {
            if (activity == null || activity.isFinishing() || FoxBaseClickUtils.isFastClick()){
                return;
            }
            final FoxBaseDownloadDialog adDownloadDialog = new FoxBaseDownloadDialog(activity, url,
                    ANDROID_APK_EVENT_APK_DOWN_SCENES_4,new FoxBaseNewDownloadBean(url, slotId, "", null,null));
            BasePopupView basePopupView = new XPopup.Builder(activity)
                    .dismissOnBackPressed(false)
                    .dismissOnTouchOutside(false)
                    .autoDismiss(false)
                    .enableDrag(false)
                    .hasShadowBg(true)
                    .asCustom(adDownloadDialog);
            if (!adDownloadDialog.isShow()) {
                basePopupView.show();
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    /**
     * 新版接口中的MD参数
     *
     * @return
     */
    @SuppressLint("MissingPermission")
    public static String getMD(Context mContext) {
        try {
            JSONObject jsonObject = new JSONObject();
            String imei = "";
            if (ActivityCompat.checkSelfPermission(mContext, Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
                imei = FoxBaseCommonUtils.getIMEI();
            }
            if (!BuildConfig.Release) {
                imei = "tuia" + UUID.randomUUID().toString();
            }
            jsonObject.put("imei", imei);
            jsonObject.put("idfa", "");
            jsonObject.put("device_id", getPhoneSign(FoxBaseSDK.getContext()));
            jsonObject.put("api_version", "1.0.0");
            FoxBaseLogUtils.dTag(null, "jsonObject  is  " + jsonObject.toString());
            return GzipUtils.compressForGzip(jsonObject.toString());
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
            FoxBaseLogUtils.eTag(TAG, "get MD error : " + e.getMessage());
        }
        return null;
    }

    public static String getSHA(String appSecret, String md, int nonce, long timeStamp) {
        String input = String.format("appSecret=%s&md=%s&nonce=%d&timestamp=%d", appSecret, md, nonce, timeStamp);
//        return new String(Hex.encodeHex(DigestUtils.sha(input)));
        return SHAUtil.sha1(input);
    }
}
