package com.mediamain.android.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.mediamain.android.view.interfaces.FloatOnEventListener;
import com.mediamain.android.view.webview.FoxBaseSdkWebView;

/**
 * Description: 悬浮升级
 * Date:2020/7/21 17:45
 *
 * @author swilliam
 */

public class FloatWebView extends FoxBaseSdkWebView {

    /**
     * 点击事件是否需要被当前页面消费
     */
    private boolean consume = false;
    private FloatOnEventListener onEventListener;

    public FloatWebView(Context context) {
        super(context);
        initWebView();
    }

    public FloatWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initWebView();
    }

    public FloatWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initWebView();
    }

    @SuppressLint("AddJavascriptInterface")
    private void initWebView() {
        this.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
        this.addJavascriptInterface(new TAHandler(), "TAHandler");
        this.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
        this.setWebViewClient(new WebViewClient() {


            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return super.shouldOverrideUrlLoading(view, url);
            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return super.shouldOverrideUrlLoading(view, request);
            }

        });
        this.setWebChromeClient(new WebChromeClient() {

        });
        this.setBackgroundColor(0);

    }

    public void setOnEventListener(FloatOnEventListener onEventListener) {
        this.onEventListener = onEventListener;
    }

    /**
     * 返回按钮监听
     */
    public void backClick() {
        this.loadUrl("javascript:backClick()");
    }

    /**
     * 通知区域已经点击
     * type 1.浮窗点击通知 2.关闭按钮点击通知
     */
    public void tagOnClick(int type) {
        if (type == 1) {
            this.loadUrl("javascript:floatViewClick()");
            consume = true;
        } else if (type == 2) {
            this.loadUrl("javascript:closeViewClick()");
        }
    }


    public void setConsume(boolean state) {
        consume = state;
    }


    /**
     * js交互类
     */
    public class TAHandler {
        /**
         * 入口素材渲染完成
         */
        @JavascriptInterface
        public void reportEntranceData(String clickInfo) {
            if (onEventListener != null) {
                onEventListener.reportEntranceData(clickInfo);
            }
        }

        /**
         * 关闭当前活动
         */
        @JavascriptInterface
        public void close() {
            if (onEventListener != null) {
                onEventListener.close();
            }
        }

        /**
         * 显示可以点击区域
         */
        @JavascriptInterface
        public void reportEntrancePosition(String entranceAreaInfo) {
            consume = false;
            if (onEventListener != null) {
                onEventListener.reportEntrancePosition(entranceAreaInfo);
            }
        }

        /**
         * 活动可以点击
         */
        @JavascriptInterface
        public void webViewClickable() {
            consume = true;
        }

        /**
         * 点击关闭区域
         */
        @JavascriptInterface
        public void reportClosePosition(String closeAreaInfo) {
            if (onEventListener != null) {
                onEventListener.reportClosePosition(closeAreaInfo);
            }
        }

        /**
         * 隐藏关闭按钮
         */
        @JavascriptInterface
        public void closeViewHide() {
            if (onEventListener != null) {
                onEventListener.closeViewHide();
            }
        }
    }

    @SuppressLint("ClickableViewAccessibility")
    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (consume) {
            return super.onTouchEvent(event);
        }
        return false;
    }
}
