package com.mediamain.android.view;

import android.app.Activity;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.mediamain.android.R;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.data.FoxFloatWebActivityBean;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.FoxBaseScreenUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.base.util.xpopup.XPopup;
import com.mediamain.android.base.util.xpopup.core.BasePopupView;
import com.mediamain.android.base.util.xpopup.interfaces.XPopupCallback;
import com.mediamain.android.nativead.AdWebView;
import com.mediamain.android.nativead.util.TuiaUtil;
import com.mediamain.android.view.bean.FloatWebBean;
import com.mediamain.android.view.holder.FoxFloatingWebHolder;
import com.mediamain.android.view.holder.FoxFloatingWebHolderImpl;
import com.mediamain.android.view.interfaces.FloatOnEventListener;
import com.mediamain.android.view.util.FoxGsonUtil;
import com.mediamain.android.view.util.FoxViewCommonUtils;

import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_ACTIVITY;


/**
 * author: likaixuan
 * date: 2020/9/15
 * desc: 悬浮升级广告
 */
public class FloatingWebAd {

    private static String mAdslotId;
    public static String mGetActivityUrl;
    private static String mActivityUrl = null;
    private static int mActivityMark = -1;

    private Activity mActivity;
    private ViewGroup rootView;
    private FloatWebView floatWebView;
    // 点击区域
    private View touchView;
    // 关闭点击区域
    private ImageView closeTouchView;

    /**
     * 原生插屏活动弹窗
     */
    private BasePopupView mActivityDialog;
    private AdWebView mWebView;

    private String mUrl;

    private String mKey;

//    private FoxFloatWebActivityBean.DataBean data;
    private String mReportUrl;

    private FoxFloatingWebHolder.FloatingWebAdLoadListener mListener;

    public FloatingWebAd(String key) {
        mKey = key;
    }

    public void init(Activity activity, int slotId, String url, FoxFloatingWebHolder.FloatingWebAdLoadListener listener) {
        mActivity = activity;
        mAdslotId = String.valueOf(slotId);
        mUrl = url;
        rootView = mActivity.getWindow().getDecorView().findViewById(android.R.id.content);
        floatWebView = new FloatWebView(activity);
        floatWebView.setOnEventListener(eventListener);

        mListener = listener;
    }

    private FloatOnEventListener eventListener = new FloatOnEventListener() {
        @Override
        public void reportEntrancePosition(String entranceAreaInfo) {
            FoxBaseLogUtils.v("entrance area info=" + entranceAreaInfo);
            try {
                final FloatWebBean.AreaInfo areaInfo = FoxGsonUtil.GsonToBean(entranceAreaInfo, FloatWebBean.AreaInfo.class);
                if (areaInfo == null) {
                    return;
                }
                // 可以绘制点击区域了
                mActivity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        initAndDrawTouchView(areaInfo.getLeft(), areaInfo.getTop(), areaInfo.getWidth(), areaInfo.getHeight());
                        if (mListener != null) {
                            mListener.onLoadSuccess();
                        }
                    }
                });
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @Override
        public void reportClosePosition(String closeAreaInfo) {
            FoxBaseLogUtils.v("close area info=" + closeAreaInfo);
            try {
                final FloatWebBean.AreaInfo areaInfo = FoxGsonUtil.GsonToBean(closeAreaInfo, FloatWebBean.AreaInfo.class);
                if (areaInfo == null) {
                    return;
                }
                // 可以绘制点击区域了
                mActivity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        initAndDrawCloseTouchView(areaInfo.getLeft(), areaInfo.getTop(), areaInfo.getWidth(), areaInfo.getHeight());
                    }
                });
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        /**
         * 入口素材曝光完成
         * @param clickInfo
         */
        @Override
        public void reportEntranceData(String clickInfo) {
            FoxBaseLogUtils.v("click data info=" + clickInfo);
            try {
                final FloatWebBean.ClickInfo info = FoxGsonUtil.GsonToBean(clickInfo, FloatWebBean.ClickInfo.class);
                if (info == null) {
                    return;
                }
                mActivity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        mReportUrl = info.getReportClickUrl();
                        mGetActivityUrl = info.getGetActivityUrl();
//                        getActualActivityUrl(info.getGetActivityUrl());
                        //预加载
                        startPreLoading(mGetActivityUrl);
                    }
                });
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @Override
        public void close() {
            mActivity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    hide();
                    floatWebView = null;
                    touchView = null;
                    closeTouchView = null;
                }
            });
        }

        @Override
        public void closeViewHide() {
            mActivity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (closeTouchView != null) {
                        rootView.removeView(closeTouchView);
                        closeTouchView = null;
                    }
                }
            });
        }
    };

    /**
     * 预加载
     *
     * @param getActivityUrl
     */
    public static void startPreLoading(String getActivityUrl) {
        try {

            if (FoxBaseCommonUtils.isEmpty(getActivityUrl)) {
                return;
            }
            OkGo.<String>get(getActivityUrl)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(Response<String> response) {
                            if (response == null || response.body() == null) {
                                FoxBaseLogUtils.e("getActivityUrl return error!");
                                return;
                            }
                            try {
                                final FoxFloatWebActivityBean bean = FoxGsonUtil.GsonToBean(response.body(), FoxFloatWebActivityBean.class);

                                if (bean == null || bean.getData() == null || TextUtils.isEmpty(bean.getData().getActivityUrl())) {
                                    return;
                                }
                                mActivityUrl = bean.getData().getActivityUrl();
                                mActivityMark = bean.getData().getActivityMark();
                                if (mActivityMark == 1) {
                                    FoxViewCommonUtils.startPreLoad(String.valueOf(mAdslotId), mActivityUrl, FoxSDKType.FLOATING_WEB_AD.getCode());
                                }
                            } catch (Exception e) {
                                FoxBaseLogUtils.e("parse FoxFloatWebActivityBean error!");
                            }
                        }

                        @Override
                        public void onError(Response<String> response) {
                            super.onError(response);
                            FoxBaseLogUtils.e("getActivityUrl request error:" + response.message());
                        }
                    });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
        }
    }

    /**
     * 绘制点击区域,单位像素
     *
     * @param x      点击区域距离坐标原点x轴位置
     * @param y      点击区域距离坐标原点y轴位置
     * @param width  点击区域宽度
     * @param height 点击区域高度
     */
    private void initAndDrawTouchView(float x, float y, float width, float height) {
        if (touchView != null) {
            rootView.removeView(touchView);
        }
        int leftMargin = (int) (rootView.getWidth() * x * 0.01);
        int topMargin = (int) (rootView.getHeight() * y * 0.01);
        int ww = (int) (rootView.getWidth() * width * 0.01);
        int hh = (int) (rootView.getHeight() * height * 0.01);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(ww, hh);
        params.setMargins(leftMargin, topMargin, 0, 0);
        touchView = new View(mActivity);
        touchView.setBackgroundColor(Color.TRANSPARENT);
        touchView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    jumpToActivity();
                }
                return true;
            }
        });
        rootView.addView(touchView, params);
    }

    /**
     * 绘制点击区域,单位像素
     *
     * @param x      点击区域距离坐标原点x轴位置
     * @param y      点击区域距离坐标原点y轴位置
     * @param width  点击区域宽度
     * @param height 点击区域高度
     */
    private void initAndDrawCloseTouchView(float x, float y, float width, float height) {
        if (closeTouchView != null) {
            rootView.removeView(closeTouchView);
        }
        int leftMargin = (int) (rootView.getWidth() * x * 0.01);
        int topMargin = (int) (rootView.getHeight() * y * 0.01);
        int ww = (int) (rootView.getWidth() * width * 0.01);
        int hh = (int) (rootView.getHeight() * height * 0.01);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(ww, hh);
        params.setMargins(leftMargin, topMargin, 0, 0);
        closeTouchView = new ImageView(mActivity);
        closeTouchView.setImageResource(R.drawable.icon_close);
//        closeTouchView.setOnTouchListener(new View.OnTouchListener() {
//            @Override
//            public boolean onTouch(View v, MotionEvent event) {
//                if (event.getAction() == MotionEvent.ACTION_UP) {
//                    hide();
//                    floatWebView.setConsume(true);
//                    setSystemUIVisible(true);
//                }
//                return true;
//            }
//        });
        closeTouchView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                floatWebView.setConsume(true);
                if (mListener != null) {
                    mListener.onCloseClick();
                }
                destroy();
//                setSystemUIVisible(true);
            }
        });
        rootView.addView(closeTouchView, params);
    }

//    private void setSystemUIVisible(boolean show) {
//        if (mActivity == null)
//            return;
//        if (mActivity instanceof AppCompatActivity) {
//            try {
//                if (((AppCompatActivity) mActivity).getSupportActionBar() == null)
//                    return;
//                if (show) {
//                    ((AppCompatActivity) mActivity).getSupportActionBar().show();
//                } else {
//                    ((AppCompatActivity) mActivity).getSupportActionBar().hide();
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        }
//    }

    /**
     * 跳转到活动页
     */
    private void jumpToActivity() {
        if (TextUtils.isEmpty(mGetActivityUrl) || TextUtils.isEmpty(mReportUrl)) {
            FoxBaseLogUtils.e("getActivityUrl is empty");
            return;
        }
        if (mListener != null) {
            mListener.onAdClick();
        }
        // 点击事件收集
        if(!FoxFloatingWebHolderImpl.is_clicked) {
            OkGo.<String>post(mReportUrl).execute(new StringCallback() {
                @Override
                public void onSuccess(Response<String> response) {
                }

                @Override
                public void onError(Response<String> response) {
                    super.onError(response);
                }
            });
            FoxFloatingWebHolderImpl.is_clicked = true;
        }

        if (FoxBaseCommonUtils.isEmpty(mActivityUrl) || mActivityMark == -1) {

            OkGo.<String>get(mGetActivityUrl)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(Response<String> response) {
                            if (response == null || response.body() == null) {
                                FoxBaseLogUtils.e("getActivityUrl return error!");
                                return;
                            }
                            try {
                                final FoxFloatWebActivityBean bean = FoxGsonUtil.GsonToBean(response.body(), FoxFloatWebActivityBean.class);

                                if (bean == null || bean.getData() == null || TextUtils.isEmpty(bean.getData().getActivityUrl())) {
                                    return;
                                }
                                String actualUrl = bean.getData().getActivityUrl();
                                FoxBaseLogUtils.v("悬浮升级真实活动页：" + actualUrl);

                                openActivity(actualUrl, bean.getData().getActivityMark());
                            } catch (Exception e) {
                                FoxBaseCrashUtils.reportErrorData(e);
                                FoxBaseLogUtils.e("parse FoxFloatWebActivityBean error!");
                            }
                        }

                        @Override
                        public void onError(Response<String> response) {
                            super.onError(response);
                            FoxBaseLogUtils.e("getActivityUrl request error:" + response.message());
                        }
                    });
        } else {
            openActivity(mActivityUrl, mActivityMark);
        }
    }

    /**
     * 打开活动
     *
     * @param url
     * @param mark
     */
    private void openActivity(String url, int mark) {
        if (mark == 2) {
            // 跳转到原生活动
            openNativeActivity(url);
        } else {
            // 跳转到普通活动
            openFoxActivity(url);
        }
        FoxViewCommonUtils.uploadScmLog(url, mGetActivityUrl);
    }

    private void openFoxActivity(String url) {
        FoxBaseLogUtils.d("——>openFoxActivity:url->" + url);
        if (!TextUtils.isEmpty(mKey)) {
            FoxBaseSPUtils.getInstance().setString(mKey, mAdslotId);
        }
        FoxActivity.starActivity(mActivity, mKey, url, FoxSDKType.FLOATING_WEB_AD.getCode());
    }

    private void openNativeActivity(String url) {
        if (mActivityDialog == null) {
//            initActivityDialog();
            mActivityDialog = new XPopup.Builder(mActivity)
                    .dismissOnBackPressed(false)
                    .dismissOnTouchOutside(false)
                    .autoDismiss(false)
                    .enableDrag(false)
                    .hasShadowBg(true)
                    .setPopupCallback(new XPopupCallback() {
                        @Override
                        public void onShow() {
                            FoxBaseCommonUtils.postDataCheck(KEY_CHECK_ACTIVITY,mAdslotId,null);
                            //解决横竖屏切换时 dialog不能铺满屏幕的问题
                            try {
                                FrameLayout.LayoutParams dialogParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
                                if (null != mActivityDialog) {
                                    mActivityDialog.setLayoutParams(dialogParams);
                                }
                            } catch (Exception ignored) {
                                FoxBaseCrashUtils.reportErrorData(ignored);
                            }
                        }

                        @Override
                        public void onDismiss() {
                            if (floatWebView != null) {
                                floatWebView.setConsume(false);
                            }
                            destroyActivityWeb();
                            mActivityDialog = null;
                            //获取新活动
                            startPreLoading(mGetActivityUrl);
                            if (mListener != null) {
                                // 原生插屏活动关闭，回调，参数为空字符串
                                mListener.onAdActivityClose("");
                            }
                        }
                    })
                    .asCustom(new PopupActivityDialog(mActivity, mAdslotId, mKey, url));
            ((PopupActivityDialog) mActivityDialog).setBackVisibility(false);
            ((PopupActivityDialog) mActivityDialog).setProgressBarVisibility(false);
            resetDialogSize();
            ;

            mWebView = ((PopupActivityDialog) mActivityDialog).getWebView();
        }
        mActivityDialog.show();
    }

    private void resetDialogSize() {
        try {
            // dialog 的大小
            FrameLayout.LayoutParams dialogParams =
                    new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
            mActivityDialog.setLayoutParams(dialogParams);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) mActivityDialog.getPopupContentView().getLayoutParams();
            // 是否是竖屏
            if (FoxBaseScreenUtils.isPortrait()) {
                layoutParams.width = TuiaUtil.getScreenShortSide();
                layoutParams.height = TuiaUtil.getScreenLongSide();
            } else {
                layoutParams.width = TuiaUtil.getScreenLongSide();
                layoutParams.height = TuiaUtil.getScreenShortSide();
            }
            mActivityDialog.getPopupContentView().setLayoutParams(layoutParams);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 标记，avoid "Application attempted to call on a destroyed WebView" exception
     */
    private boolean isDestroyed = false;

    private void destroyActivityWeb() {
        if (mWebView != null) {
            mWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            mWebView.clearHistory();
            if (mWebView.getParent() != null) {
                ((ViewGroup) mWebView.getParent()).removeAllViews();
            }
            mWebView.destroy();
            isDestroyed = true;
        }
    }

    public boolean goBack() {
        // 原生活动的dialog dismiss
        if (mActivityDialog != null && mActivityDialog.isShow()) {
            if (mWebView != null && mWebView.canGoBack()) {
                mWebView.goBack();
                return true;
            }
            if (!isDestroyed) {
                destroyActivityWeb();
            }
            mActivityDialog.dismiss();
            return true;
        }
        return false;
    }

    public void show() {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
        rootView.addView(floatWebView, params);
        floatWebView.loadUrl(mUrl);
    }

    public void hide() {
        if (touchView != null) {
            touchView.setVisibility(View.GONE);
        }
        if (closeTouchView != null) {
            closeTouchView.setVisibility(View.GONE);
        }
        if (floatWebView != null) {
            floatWebView.setVisibility(View.GONE);
        }
    }

    /**
     * 隐藏之后再次显示
     */
    public void reShow() {
        if (touchView != null) {
            touchView.setVisibility(View.VISIBLE);
        }
        if (closeTouchView != null) {
            closeTouchView.setVisibility(View.VISIBLE);
        }
        if (floatWebView != null) {
            floatWebView.setVisibility(View.VISIBLE);
        }
    }

    public void destroy() {
        if (mActivityDialog != null && mActivityDialog.isShow()) {
            if (!isDestroyed) {
                destroyActivityWeb();
            }
            mActivityDialog.dismiss();
        }
        if (touchView != null) {
            touchView.setVisibility(View.GONE);
            touchView = null;
        }
        if (closeTouchView != null) {
            closeTouchView.setVisibility(View.GONE);
            closeTouchView = null;
        }
        if (floatWebView != null) {
            floatWebView.loadUrl("about:blank");
            floatWebView.setVisibility(View.GONE);
            floatWebView = null;
        }
    }
}
