package com.mediamain.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.RelativeLayout;

import com.liulishuo.okdownload.OkDownload;
import com.mediamain.android.R;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.data.FoxBaseNewDownloadBean;
import com.mediamain.android.base.download.IntegrateH5DownloadManager;
import com.mediamain.android.base.util.FoxBaseClickUtils;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.download.FoxDownloadDialog;
import com.mediamain.android.view.util.FoxListenerManager;

import java.lang.ref.WeakReference;

import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_ACTIVITY;

/**
 * @Author: Zhougaofeng
 * Email: 365315018@qq.com
 * Time: 2016/10/24
 * Description:
 * edit： lzy
 * Time:2019/08/28
 */
public class FoxActivity extends AppCompatActivity {

    /**
     * 活动访问链接常量
     */
    public static final String BUNDLE_KEY_URL = "BUNDLE_KEY_URL";
    public static final String BUNDLE_KEY_AD_ID = "BUNDLE_KEY_AD_ID";
    /**
     * 导航栏控制常量
     */
    public static final String BUNDLE_KEY_SHOW_TOP_BAR = "BUNDLE_KEY_SHOW_TOP_BAR";
    /**
     * 页面访问GG来源
     */
    public static final String BUNDLE_KEY_FROM = "BUNDLE_KEY_FROM";
    /**
     * 页面访问随机值用于发奖
     */
    public static final String BUNDLE_KEY_FROM_AD = "BUNDLE_KEY_FROM_AD";
    /**
     * 活动访问链接
     */
    private String mWebUrl = null;
    /**
     *
     */
    private boolean isShowBottomBar = true;
    /**
     * 页面访问GG来源
     */
    private int mFrom = -1;
    /**
     * 随机值处理发奖
     */
    private String mkey;
    private static Intent mIntent;
    /**
     * GG id
     */
    private String mSlotId = "";

    private FoxBrowserLayout mCommonWebBrowserLayout;

    private Activity mActivity;

    private RelativeLayout rl_fox;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mActivity = this;
        setContentView(R.layout.fox_activity_in_sdk);
        try {
            if (getIntent() != null) {
                mWebUrl = getIntent().getStringExtra(BUNDLE_KEY_URL);
                isShowBottomBar = getIntent().getBooleanExtra(BUNDLE_KEY_SHOW_TOP_BAR, true);
                mFrom = getIntent().getIntExtra(BUNDLE_KEY_FROM, -1);
                mkey = getIntent().getStringExtra(BUNDLE_KEY_FROM_AD);
                mSlotId = getIntent().getStringExtra(BUNDLE_KEY_AD_ID);
            }
            rl_fox = findViewById(R.id.rl_fox);
            if(null == mCommonWebBrowserLayout) {
                mCommonWebBrowserLayout = new FoxBrowserLayout(this);
            }
            rl_fox.addView(mCommonWebBrowserLayout);
//            mCommonWebBrowserLayout = findViewById(R.id.tm_common_web_browser_layout);
            // fixed v3.0.2.5:intent 中没有传slotId，从sp中取, 适配原生插屏
            if (FoxBaseCommonUtils.isEmpty(mSlotId)) {
                if (!FoxBaseCommonUtils.isEmpty(mkey)) {
                    mSlotId = FoxBaseSPUtils.getInstance().getString(mkey, "");
                }
            }
            if (!FoxBaseCommonUtils.isEmpty(mSlotId) && mCommonWebBrowserLayout != null) {
                mCommonWebBrowserLayout.setSlotId(mSlotId);
                FoxBaseCommonUtils.postDataCheck(KEY_CHECK_ACTIVITY, mSlotId,null);
            }

            if (!TextUtils.isEmpty(mWebUrl)) {
                mCommonWebBrowserLayout.loadUrl(mWebUrl, mSlotId, mFrom);
            }

            if (!isShowBottomBar) {
                mCommonWebBrowserLayout.hideBrowserController();
            } else {
                mCommonWebBrowserLayout.showBrowserController();
            }

            BackListener backListener = new BackListener(this);
            DownloadListener downloadListener = new DownloadListener(this);
            mCommonWebBrowserLayout.setOnBackClickListener(backListener);
            mCommonWebBrowserLayout.setWebDownloadListener(downloadListener);
            FoxListenerManager.getInstance().sendMsg(Constants.KEY_ACTIVITY_EXAMPLE, this, mkey);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public static void startActivity(Context context, String key, String slotId, String webUrl, int from) {
        try {
            if (context != null && !TextUtils.isEmpty(webUrl)) {
                Intent intent = new Intent(context, FoxActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.putExtra(BUNDLE_KEY_URL, webUrl);
                intent.putExtra(BUNDLE_KEY_SHOW_TOP_BAR, true);
                intent.putExtra(BUNDLE_KEY_FROM, from);
                intent.putExtra(BUNDLE_KEY_FROM_AD, key);
                intent.putExtra(BUNDLE_KEY_AD_ID, slotId);
                context.startActivity(intent);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 接收媒体回调信息
     */
    public void sendMessage(int type, String message) {
        if (mCommonWebBrowserLayout != null) {
            mCommonWebBrowserLayout.sendMessage(type, message);
        }
    }

    public static void starActivity(Context context, String key, String webUrl, int from) {
        try {
            if (context != null && !TextUtils.isEmpty(webUrl)) {
                Intent intent = new Intent(context, FoxActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.putExtra(BUNDLE_KEY_URL, webUrl);
                intent.putExtra(BUNDLE_KEY_SHOW_TOP_BAR, true);
                intent.putExtra(BUNDLE_KEY_FROM, from);
                intent.putExtra(BUNDLE_KEY_FROM_AD, key);
                context.startActivity(intent);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public static void starActivity(Context context, String webUrl, int from) {
        try {
            if (context != null && !TextUtils.isEmpty(webUrl)) {
                Intent intent = new Intent(context, FoxActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.putExtra(BUNDLE_KEY_URL, webUrl);
                intent.putExtra(BUNDLE_KEY_SHOW_TOP_BAR, true);
                intent.putExtra(BUNDLE_KEY_FROM, from);
                intent.putExtra(BUNDLE_KEY_FROM_AD, 0);
                context.startActivity(intent);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    //Vedio
    public static void starActivity(Context context, String key, String webUrl, int from, boolean isShowTopBar) {
        try {
            if (context != null && !TextUtils.isEmpty(webUrl)) {
                Intent intent = new Intent(context, FoxActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.putExtra(BUNDLE_KEY_URL, webUrl);
                intent.putExtra(BUNDLE_KEY_SHOW_TOP_BAR, isShowTopBar);
                intent.putExtra(BUNDLE_KEY_FROM, from);
                intent.putExtra(BUNDLE_KEY_FROM_AD, key);
                context.startActivity(intent);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public static void starActivity(Context context, String key, String webUrl, Intent userIntent, int from) {
        try {
            if (context != null && !TextUtils.isEmpty(webUrl)) {
                mIntent = userIntent;
                Intent intent = new Intent(context, FoxActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.putExtra(BUNDLE_KEY_URL, webUrl);
                intent.putExtra(BUNDLE_KEY_SHOW_TOP_BAR, true);
                intent.putExtra(BUNDLE_KEY_FROM, from);
                intent.putExtra(BUNDLE_KEY_FROM_AD, key);
                context.startActivity(intent);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 处理页面回退
     */
    public void back() {
        resertData();
        if (mCommonWebBrowserLayout != null) {
            if (mCommonWebBrowserLayout.canGoBack()) {
                mCommonWebBrowserLayout.goBack();
            } else {
//                mCommonWebBrowserLayout.loadUrl("about:blank");
                finishPage();
            }
        } else {
//            goToMain();
            finish();
        }
    }

    /**
     * 回传通知媒体信息
     */
    public void showMediaAdVideo(MessageData type) {
        //设置出媒体对接的广告吧
        FoxListenerManager.getInstance().sendMsg(Constants.KEY_AD_MESSAGE, type, mkey);
    }

    /**
     * 关闭活动页
     * 发放奖励
     */
    public void finishPage() {
        try {
            if (mCommonWebBrowserLayout != null) {
                mCommonWebBrowserLayout.finishPage();
                String data = mCommonWebBrowserLayout.getData();
                FoxListenerManager.getInstance().sendMsg(Constants.KEY_AD_CLOSE, FoxBaseCommonUtils.isEmpty(data) ? "" : data, mkey);
            }

            finish();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (event.getKeyCode()) {
            case KeyEvent.KEYCODE_BACK:
                back();
                return true;
            default:
                break;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onDestroy() {
        try {
            IntegrateH5DownloadManager.getInstance().webviewDestroy();
            if (mCommonWebBrowserLayout.specialTask != null) {
                mCommonWebBrowserLayout.specialTask.cancel();
            }
            if (mCommonWebBrowserLayout.commonTask != null) {
                mCommonWebBrowserLayout.commonTask.cancel();
            }
            if (mCommonWebBrowserLayout != null) {
                mCommonWebBrowserLayout.destroy();
            }
            if(null != rl_fox){
                rl_fox.removeAllViews();
            }
            OkDownload.with().downloadDispatcher().cancelAll();
            FoxBaseCommonUtils.cancelNotify(FoxActivity.this, "1");
            System.gc();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
        }
        super.onDestroy();
    }

//-------------------------------------------------Private--------------------------------------------------------------

    private static class BackListener implements View.OnClickListener{

        WeakReference<FoxActivity> weakReference;

        public BackListener(FoxActivity activity){
            weakReference = new WeakReference<>(activity);
        }

        public void back(){
            try {
                weakReference.get().resertData();
                if (weakReference.get().mCommonWebBrowserLayout != null) {
                    if (weakReference.get().mCommonWebBrowserLayout.canGoBack()) {
                        weakReference.get().mCommonWebBrowserLayout.goBack();
                    } else {
//                mCommonWebBrowserLayout.loadUrl("about:blank");
                        weakReference.get().finishPage();
                    }
                } else {
                    weakReference.get().finish();
                }
            }catch (Exception ignored){}
        }

        @Override
        public void onClick(View v) {
            back();
        }
    }

    private static class DownloadListener implements FoxBrowserLayout.WebDownloadListener{

        WeakReference<FoxActivity> weakReference;

        public DownloadListener(FoxActivity activity){
            weakReference = new WeakReference<>(activity);
        }

        @Override
        public void download(String url) {
            try {
                weakReference.get().dealWebDowanload(url);
            } catch (Exception ignored) {
            }
        }
    }

    /**
     * 处理下载
     *
     * @param url
     */
    private void dealWebDowanload(String url) {
        try {
            if (mActivity == null || mActivity.isFinishing() || FoxBaseClickUtils.isFastClick()) {
                return;
            }
            final FoxBaseNewDownloadBean newDownloadBean = new FoxBaseNewDownloadBean();
            newDownloadBean.setUrl(url);
            if (mCommonWebBrowserLayout != null && mCommonWebBrowserLayout.getPackageBaen() != null) {
                newDownloadBean.setPackageName(mCommonWebBrowserLayout.getPackageBaen().getPackageName());
                newDownloadBean.setApplicationName(mCommonWebBrowserLayout.getPackageBaen().getApplicationName());
                newDownloadBean.setAppIconUri(mCommonWebBrowserLayout.getPackageBaen().getAppIconUri());
                newDownloadBean.setTuiaId(mCommonWebBrowserLayout.getTuiaId());
                newDownloadBean.setStyleControl(mCommonWebBrowserLayout.getPackageBaen().getStyleControl());
                newDownloadBean.setSlotId(mSlotId);
                newDownloadBean.setTitle(mCommonWebBrowserLayout.getPackageBaen().getTitle());
                newDownloadBean.setDesc(mCommonWebBrowserLayout.getPackageBaen().getDesc());
            } else {
                newDownloadBean.setPackageName("");
                newDownloadBean.setApplicationName("");
                newDownloadBean.setAppIconUri("");
                newDownloadBean.setTuiaId("");
                newDownloadBean.setTitle("");
                newDownloadBean.setDesc("");
                newDownloadBean.setStyleControl(1);
                newDownloadBean.setSlotId(mSlotId);
            }
            Bundle bundle = new Bundle();
            bundle.putSerializable(FoxDownloadDialog.KEY_DATA, newDownloadBean);
            final FoxDownloadDialog downloadDialog = FoxDownloadDialog.newInstance(bundle);
            String tag = FoxDownloadDialog.class.getSimpleName();
            downloadDialog.showAllowingStateLoss(this.getSupportFragmentManager(), tag);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 重置数据状态
     */
    private void resertData() {
        if (mCommonWebBrowserLayout != null) {
            mCommonWebBrowserLayout.setShowDownloadBar(true);
            mCommonWebBrowserLayout.setPackageBaen(null);
            mCommonWebBrowserLayout.setDownloadUrl(null);
        }
    }
}
