package com.mediamain.android.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.liulishuo.okdownload.DownloadTask;
import com.mediamain.android.BuildConfig;
import com.mediamain.android.R;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.config.FoxBaseUrl;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.data.FoxBaseSDKConfigBean;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseGsonUtil;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.base.FoxSDK;
import com.mediamain.android.view.bean.FoxPackageBaen;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.download.PopLayerDownloadManage;
import com.mediamain.android.view.util.FoxGsonUtil;
import com.mediamain.android.view.util.FoxViewCommonUtils;
import com.mediamain.android.view.util.FoxViewMaidianUtils;
import com.mediamain.android.view.video.FoxVideoDialog;
import com.mediamain.android.view.video.OnDialogMessage;
import com.mediamain.android.view.webview.FoxBaseSdkWebView;
import com.mediamain.android.view.webview.callback.FoxWebViewClientAndChromeClient;
import com.mediamain.android.view.webview.helper.WebViewHelper;
import com.mediamain.android.view.webview.jsbridge.DownloadJsBridgeHandler;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import static com.mediamain.android.view.FoxActivity.BUNDLE_KEY_URL;

/**
 * @author: Tau.Chen
 * Email:   1076559197@qq.com | tauchen1990@gmail.com
 * Date:    2015/3/31.
 * Description: 活动展示View（标准广告类型）
 */
public class FoxBrowserLayout extends RelativeLayout {

    public static final int TYPE = 157;
    public static int mAdType = -1; //广告类型

    private static String mActivityUrl;
    private Context mContext = null;
    private FoxBaseSdkWebView mWebView;
    private TextView mTextView = null;
    private View mBrowserControllerView;
    private ImageButton mGoBackBtn = null;
    private ImageButton mCloseBtn = null;
    private int mBarHeight = 5;
    private ProgressBar mProgressBar = null;
    private OnClickListener mClickListener;
    //活动链接（仅存活动链接）
    private String mWebActivityUrl;
    //下载链接
    private String mDownloadUrl;
    private String mLoadUrl;

    private String mPrintLogUrl;
    //普通下载任务
    public DownloadTask commonTask;
    // 特殊下载任务
    public DownloadTask specialTask;
    //推啊ID
    public String mTuiaId;
    //奖励信息
    private String mData;
    //包名信息
    private FoxPackageBaen mFoxPackageBaen = new FoxPackageBaen();
    //是否展示下载栏
    private boolean isShowDownloadBar = true;
    //GG id
    private String mSlotId;
    //预加载是否完成
    private static boolean isPreLoaded = false;
    private static boolean isPrintLog = false;

    private TAHandler taHandler = null;

    private static String mPreSlotId = "";
    private WebDownloadListener downloadListener;

    public String getLoadUrl() {
        return mLoadUrl;
    }

    public String getSlotId() {
        return mSlotId;
    }

    public void setSlotId(String mSlotId) {
        this.mSlotId = mSlotId;
    }

    public String getData() {
        return mData;
    }

    public String getTuiaId() {
        return mTuiaId;
    }

    public void setmTuiaId(String mTuiaId) {
        this.mTuiaId = mTuiaId;
    }

    public FoxPackageBaen getPackageBaen() {
        return mFoxPackageBaen;
    }

    public void setPackageBaen(FoxPackageBaen mFoxPackageBaen) {
        this.mFoxPackageBaen = mFoxPackageBaen;
    }

    public boolean isShowDownloadBar() {
        return isShowDownloadBar;
    }

    public void setShowDownloadBar(boolean showDownloadBar) {
        isShowDownloadBar = showDownloadBar;
    }

    public String getDownloadUrl() {
        return mDownloadUrl;
    }

    public void setDownloadUrl(String mDownloadUrl) {
        this.mDownloadUrl = mDownloadUrl;
    }

    /**
     * Instantiates a new Browser layout.
     *
     * @param context the context
     */
    public FoxBrowserLayout(Context context) {
        super(context);
        init(context);
    }

    /**
     * Instantiates a new Browser layout.
     *
     * @param context the context
     * @param attrs   the attrs
     */
    public FoxBrowserLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public FoxBrowserLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    public void setOnBackClickListener(OnClickListener listener) {

        mClickListener = listener;
    }

    public void sendMessage(int type, String message) {
        if (mWebView != null) {
            String data = "javascript:sdkPlayVideoCallBack(" + type + "," + JSONObject.quote(message) + ")";
            mWebView.loadUrl(data);
        }
    }

    public static long lastTime = 0l;

    public static void preLoadUrl(String url, String slotId, int adType) {
        mAdType = adType;
        if (System.currentTimeMillis() - lastTime < 3000) {
            return;
        }
        lastTime = System.currentTimeMillis();
        mPreSlotId = slotId;
        initPreWebView();
        if (null == FoxSDK.mPreweb || FoxBaseCommonUtils.isEmpty(url)) {
            isPreLoaded = false;
            return;
        }
        FoxSDK.mPreweb.loadUrl(url);
    }

    /**
     * Load url.
     *
     * @param url the url
     */
    @SuppressLint("WrongConstant")
    public void loadUrl(String url, String slotId, int adType) {
        try {
            mAdType = adType;
            mSlotId = slotId;
            mActivityUrl = url;
            //AB分流
            if (!FoxBaseCommonUtils.isEmpty(url) && FoxViewCommonUtils.isPreLoadUrl(url) && slotId.equals(mPreSlotId)) {

                String preUrl = FoxSDK.mPreweb.getUrl();
                if (!FoxBaseCommonUtils.isEmpty(preUrl)) {
                    mWebView.loadUrl(preUrl.replace("preloading=1",""));
                } else {
                    mWebView.loadUrl(url.replace("preloading=1",""));
                }
                isPreLoaded = false;
                FoxSDK.mPreweb.setVisibility(GONE);
                mWebView.setVisibility(VISIBLE);
            } else {
                if (adType == FoxSDKType.NATIVE_AD.getCode()) {
                    dealPackageName(url);
                }
                mWebView.loadUrl(url.replace("preloading=1",""));
                FoxSDK.mPreweb.setVisibility(GONE);
                mWebView.setVisibility(VISIBLE);

            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }

    /**
     * Can go back boolean.
     *
     * @return the boolean
     */
    public boolean canGoBack() {
        boolean isCanGoBack = false;
        try {
            isCanGoBack = preWebViewIsVisibility() ? FoxSDK.mPreweb.canGoBack() : mWebView.canGoBack();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return isCanGoBack;
    }

    public void finishPage() {
        upActivityLog(null != mWebView ? mWebView.getUrl() : "", 43);
    }

    /**
     * Can go forward boolean.
     *
     * @return the boolean
     */
    public boolean canGoForward() {
        boolean isCanGoForward = false;
        try {
            isCanGoForward = preWebViewIsVisibility() ? FoxSDK.mPreweb.canGoForward() : mWebView.canGoForward();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return isCanGoForward;
    }

    /**
     * Go back.
     */
    public void goBack() {
        try {
//            mDownloadBar.setVisibility(GONE);
            upActivityLog(mWebActivityUrl, 43);
            mWebActivityUrl = "";
            //正常返回
            if (preWebViewIsVisibility()) {
                FoxSDK.mPreweb.goBack();
            } else {
                mWebView.goBack();
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * Gets web view.
     *
     * @return the web view
     */
    public WebView getWebView() {
        return preWebViewIsVisibility() ? FoxSDK.mPreweb : mWebView;
    }

    /**
     * Hide browser controller.
     */
    public void hideBrowserController() {
        if (mBrowserControllerView != null) {
            mBrowserControllerView.setVisibility(View.GONE);
        }
    }

    /**
     * Show browser controller.
     */
    public void showBrowserController() {
        if (mBrowserControllerView != null) {
            mBrowserControllerView.setVisibility(View.VISIBLE);
        }
    }

    public interface WebDownloadListener {
        void download(String url);
    }

    public void setWebDownloadListener(WebDownloadListener listener) {
        this.downloadListener = listener;
    }

    public void destroy() {
        if (taHandler != null){
            taHandler.unregisterBroadcast();
        }
        if (mWebView != null) {
            mWebView.onDestroy();
            mWebView = null;
            PopLayerDownloadManage.destroy();
        }
        if (FoxSDK.mPreweb != null) {
            FoxSDK.mPreweb.onDestroy();
            FoxSDK.mPreweb = null;
        }
        //预加载
        if (mAdType == FoxSDKType.FLOATING_WEB_AD.getCode()) {
            FloatingWebAd.startPreLoading(FloatingWebAd.mGetActivityUrl);
            return;
        }
        if (!FoxBaseCommonUtils.isEmpty(mActivityUrl) && FoxViewCommonUtils.isPreLoadUrl(mActivityUrl)) {
            FoxViewCommonUtils.startPreLoad(mSlotId, mActivityUrl, mAdType);
        }

    }

//------------------------------------------------------Private---------------------------------------------------------------------------

    private void init(Context context) {
        mContext = context;
        initControlBar(context);
    }

    private void initControlBar(Context context) {
        try {
            mBrowserControllerView = View.inflate(context, R.layout.fox_browser_controller, null);
            mGoBackBtn = mBrowserControllerView.findViewById(R.id.browser_controller_back);
            mCloseBtn = mBrowserControllerView.findViewById(R.id.browser_controller_close);
            mTextView = mBrowserControllerView.findViewById(R.id.browser_controller_title);
            mGoBackBtn.setOnClickListener(new OnClickListener() {

                @Override
                public void onClick(View v) {
                    if (canGoBack()) {
                        goBack();
                    } else {
                        if (mClickListener != null) {
                            mClickListener.onClick(v);
                        }
                    }
                }
            });
            if (mCloseBtn != null) {
                final String configData = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_CONFIG, "");
                FoxBaseSDKConfigBean.DataBean sdkConfigBean = FoxBaseGsonUtil.GsonToBean(configData, FoxBaseSDKConfigBean.DataBean.class);
                if (sdkConfigBean != null && sdkConfigBean.isSupportClose()) {
                    mCloseBtn.setVisibility(VISIBLE);
                } else {
                    mCloseBtn.setVisibility(GONE);
                }
                mCloseBtn.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mContext != null && mContext instanceof FoxActivity) {
                            upActivityLog(null != mWebView ? mWebView.getUrl() : "", 43);
                            ((FoxActivity) mContext).finishPage();
                        }
                    }
                });
            }
            //添加活动TitleBar
            addView(mBrowserControllerView, LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
            //进度条
            mProgressBar = (ProgressBar) View.inflate(context, R.layout.fox_progress_horizontal, null);
            mProgressBar.setMax(100);
            mProgressBar.setProgress(0);
            addView(mProgressBar, LayoutParams.MATCH_PARENT,
                    (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_PX, mBarHeight,
                            getResources().getDisplayMetrics()));

            initRealWebView(context, 1);
            initPreWebView();

            //WebView
            LayoutParams lps = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
            addView(mWebView, lps);
//            ViewGroup viewGroup = ((ViewGroup) mPreweb.getParent());
//            if(null != viewGroup) {
//                viewGroup.removeView(mPreweb);
//            }
//            addView(mPreweb, lps);
            try {
                ((LayoutParams) mWebView.getLayoutParams()).addRule(RelativeLayout.BELOW, R.id.ll_browser_controller);
//                ((LayoutParams)mPreweb.getLayoutParams()).addRule(RelativeLayout.BELOW,R.id.ll_browser_controller);
            } catch (Exception ignored) {
                FoxBaseCrashUtils.reportErrorData(ignored);
            }
            mWebView.setVisibility(GONE);

        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    private static void initPreWebView() {
        if (null == FoxSDK.mPreweb) {
            FoxBaseUtils.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    FoxSDK.mPreweb = new FoxBaseSdkWebView(FoxBaseSDK.getContext());
                }
            });
        }
        initPreWebListener();
    }

    private static void initPreWebListener() {
        if (FoxSDK.mPreweb == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT && !BuildConfig.Release) {
            WebView.setWebContentsDebuggingEnabled(true);
        }
        try {
            FoxSDK.mPreweb.setFoxWebViewClientAndChromeClient(new FoxWebViewClientAndChromeClient() {
                @Override
                public void onPageStarted(WebView webView, String url) {
//                    isPreLoaded = false;
//                    isPrintLog = true;
                }

                @Override
                public void onPageFinished(WebView webView, String url) {
//                    isPreLoaded = false;
//                    //补打日志
//                    if (FoxViewCommonUtils.isActivityUrl(url) && FoxViewCommonUtils.isPreLoadUrl(url) && isPrintLog) {
//                        isPrintLog = false;
//                        if (mAdType != FoxSDKType.FLOATING_WEB_AD.getCode()) {
//                            FoxViewCommonUtils.uploadScmLog(url, mActivityUrl);
//                        }
//                    }
                }

                @Override
                public boolean shouldOverrideUrlLoading(WebView webView, String url) {
                    return WebViewHelper.shouldOverrideUrlLoading(url, webView, false);
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }

    /**
     * 初始化WebView
     *
     * @param context
     * @param isPreLoad 0：正常加载   1：预加载
     */
    private void initRealWebView(Context context, int isPreLoad) {
        LayoutParams lps = new LayoutParams(LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        if (null == mWebView) {
            mWebView = new FoxBaseSdkWebView(context);
            mWebView.setLayoutParams(lps);
            mWebView.setTag(isPreLoad);
        }
        initRealWeb(context, isPreLoad);
        initRealWebListener();
    }

    private void initRealWeb(Context context, int isPreLoad) {
        if (null == mWebView) {
            LayoutParams lps = new LayoutParams(LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            mWebView = new FoxBaseSdkWebView(context);
            mWebView.setLayoutParams(lps);
            mWebView.setTag(isPreLoad);
        }
    }

    @SuppressLint("AddJavascriptInterface")
    private void initRealWebListener() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT && !BuildConfig.Release) {
            WebView.setWebContentsDebuggingEnabled(true);
        }

        taHandler = new TAHandler(mContext, mWebView);
        mWebView.addJavascriptInterface(taHandler, "TAHandler");
        String ua = mWebView.getSettings().getUserAgentString();
        mWebView.getSettings().setUserAgentString(ua + "duiba881");
        mWebView.setDownloadListener(new DownloadListener() {
            @Override
            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                dealNewDownload(url);
            }
        });
        try {
            mWebView.setFoxWebViewClientAndChromeClient(new FoxWebViewClientAndChromeClient() {

                @Override
                public void onProgressChanged(WebView webView, int newProgress) {
                    super.onProgressChanged(webView, newProgress);
                    try {
                        if (mProgressBar != null) {
                            if (newProgress >= 100) {
                                mProgressBar.setVisibility(View.GONE);
                            } else {
                                mProgressBar.setVisibility(View.VISIBLE);
                                mProgressBar.setProgress(newProgress);
                            }
                        }
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        e.printStackTrace();
                    }
                }

                @Override
                public void onPageStarted(WebView webView, String url) {
                    super.onPageStarted(webView, url);
                    upActivityLog(url, 42);
                    mLoadUrl = url;
                    isPreLoaded = false;
                    isPrintLog = true;
                }

                @Override
                public void onPageFinished(WebView webView, String url) {
                    super.onPageFinished(webView, url);
                    if (webView.getProgress() == 100) {
                        //活动生命周期日志
                        upActivityLog(mPrintLogUrl, 44);
                    }
                    isPreLoaded = false;
                    if (preWebViewIsVisibility()) {
                        dealUi(url, FoxSDK.mPreweb);
                    } else {
                        dealUi(url, mWebView);
                    }
                    if (null != mProgressBar) {
                        mProgressBar.setVisibility(GONE);
                    }
                    //补打日志
                    if (FoxViewCommonUtils.isActivityUrl(url) && FoxViewCommonUtils.isPreLoadUrl(mActivityUrl) && isPrintLog) {
                        isPrintLog = false;
                        if (mAdType != FoxSDKType.FLOATING_WEB_AD.getCode()) {
                            FoxViewCommonUtils.uploadScmLog(url, mActivityUrl);
                            return;
                        }
                    }
                    try {
                        if (!TextUtils.isEmpty(mLoadUrl) && mLoadUrl.contains(Constants.KEY_MAGICVIDEOSDK)) {
                            hideBrowserController();
                        } else {
                            showBrowserController();
                        }
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        e.printStackTrace();
                    }
                }

                @Override
                public void shouldOverrideUrlLoadingInit(WebView webView, String url) {
                    upActivityLog(mWebActivityUrl, 43);
                    mWebActivityUrl = "";
                    dealPackageName(url);
                }

                @Override
                public boolean shouldOverrideUrlLoading(WebView webView, String url) {
                    try {
                        //处理普通请求
                        if (url.startsWith(Constants.KEY_URL_HTTP) || url.startsWith(Constants.KEY_URL_HTTPS)) {
                            //如果是8.0以上的,则不调用loadUrl,并返回false
                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                return false;
                            }
                            if (mWebView != null) {
                                mWebView.loadUrl(url);
                            }
                            return true;
                        }
                        //防止  找不到网页net:err_unknown_url_scheme,支持scheme协议
                        boolean result = FoxBaseCommonUtils.startActivity(FoxBaseUtils.getApp(), Uri.parse(url));
                        FoxBaseMaidianUtil.build(45)
                                .set("start_result", result ? "1" : "2")
                                .set("land_page_url", url)
                                .set("slot_id", mSlotId)
                                .postDeepLinkStartLog();
                        String resultFunction = result ? "arouseAppSuccess()" : "arouseAppFail()";
                        webView.loadUrl("JavaScript:" + resultFunction);
                        return true;
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        //防止crash (如果手机上没有安装处理某个scheme开头的url的APP, 会导致crash)
                        e.printStackTrace();
                        //返回true 代表让webView自己执行
                        return true;
                    }
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    private long logPrintTime43 = 0;
    private String actUrl43 = "";

    /**
     * 活动日志
     *
     * @param url
     * @param type
     */
    private void upActivityLog(String url, int type) {
        if (FoxBaseCommonUtils.isEmpty(url)) {
            return;
        }
        if (System.currentTimeMillis() - logPrintTime43 < 1000 && 43 == type && actUrl43.equals(url)) {
            return;
        }
        if (FoxViewCommonUtils.isActivityUrl(url)) {
            if (42 == type) {
                mPrintLogUrl = url;
                mWebActivityUrl = url;
            } else if (43 == type) {
                actUrl43 = url;
                mPrintLogUrl = "";
                logPrintTime43 = System.currentTimeMillis();
            } else if (44 == type && url.equals(mPrintLogUrl)) {
                mPrintLogUrl = "";
            }
            String trackId = FoxBaseCommonUtils.getValueByName(url, "trackId");
            Map<String, String> param = new HashMap<>();
            param.put("operateType", "102");
            param.put("track_id", trackId);
            param.put("act_url", url);
            param.put("operate_time", String.valueOf(System.currentTimeMillis()));
            FoxViewMaidianUtils.activityLogUpload(type, param);
        }
    }

    //设置UI
    private void dealUi(String url, FoxBaseSdkWebView webView) {
        try {
            mLoadUrl = url;
            if (webView != null) {
                setTitle(webView.getTitle());
            }
            if (!TextUtils.isEmpty(mLoadUrl) && mLoadUrl.contains(Constants.KEY_MAGICVIDEOSDK)) {
                hideBrowserController();
            } else {
                showBrowserController();
            }

            if (null != mProgressBar) {
                if (isPreLoaded) {
                    mProgressBar.setVisibility(GONE);
                } else {
                    mProgressBar.setVisibility(VISIBLE);
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    private void setTitle(String title) {
        if (!TextUtils.isEmpty(title)) {
            if (title.length() >= 9) {
                if (mTextView != null) {
                    mTextView.setText(title.substring(0, 7) + "...");
                }
            } else {
                if (mTextView != null) {
                    mTextView.setText(title);
                }
            }
        }
    }

    /**
     * 获取下载类应用包名
     *
     * @param url
     */
    private void dealPackageName(final String url) {
        if (!FoxBaseCommonUtils.isEmpty(url)) {
            if (url.contains("https://jimu.tuia.cn/render?id=NjExMA")) {
                mFoxPackageBaen.setApplicationName("test.apk");
                mFoxPackageBaen.setPackageName(FoxBaseConstants.KEY_CHECK_PACKAGE_NEME);
                mFoxPackageBaen.setStyleControl(1);
            } else if (url.contains(Constants.H5_DOWNLOAD)) {
                mTuiaId = FoxBaseCommonUtils.getValueByName(url, "orderId");
                OkGo.<String>get(FoxBaseUrl.BASE_SDK_URL_GG_INFO + mTuiaId)
                        .execute(new StringCallback() {
                            @Override
                            public void onSuccess(Response<String> response) {
                                try {
                                    if (response != null && !FoxBaseCommonUtils.isEmpty(response.body())) {
                                        FoxPackageBaen foxPackageBaen = FoxGsonUtil.GsonToBean(response.body(), FoxPackageBaen.class);
                                        if (foxPackageBaen != null) {
                                            mFoxPackageBaen = foxPackageBaen;
                                        } else {
                                            mFoxPackageBaen = null;
                                        }
                                    } else {
                                        mFoxPackageBaen = null;
                                    }
                                } catch (Exception e) {
                                    FoxBaseCrashUtils.reportErrorData(e);
                                    mFoxPackageBaen = null;
                                }
                            }

                            @Override
                            public void onError(Response<String> response) {
                                super.onError(response);
                                mFoxPackageBaen = null;
                            }
                        });
            }
        }
    }

    /**
     * 新下载样式
     *
     * @param url
     */
    private void dealNewDownload(String url) {
        if (downloadListener != null) {
            downloadListener.download(url);
        }
    }

    private boolean preWebViewIsVisibility() {
        boolean isVisibility = false;
        try {
            isVisibility = (VISIBLE == FoxSDK.mPreweb.getVisibility());
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return isVisibility;
    }

    /**
     * js交互类
     */
    public class TAHandler extends DownloadJsBridgeHandler {


        public TAHandler(Context context, WebView webView) {
            super(context, webView);
        }

        /**
         * 发奖
         *
         * @param data
         */
        @JavascriptInterface
        public void reward(String data) {
            mData = data;
        }

        /**
         * 关闭事件监听
         */
        @JavascriptInterface
        public void close() {
            if (mContext == null) {
                return;
            }
            ((Activity) mContext).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (mContext instanceof FoxActivity && !((FoxActivity) mContext).isFinishing()) {
                        ((FoxActivity) mContext).finishPage();
                    } else {
                        ((Activity) mContext).finish();
                    }
                }
            });
        }

        @JavascriptInterface
        public void getAppInfo(String orderId) {
            try {
                if (preWebViewIsVisibility()) {
                    PopLayerDownloadManage.getInstance(mContext, FoxSDK.mPreweb, mSlotId).getAppInfo(orderId);
                } else {
                    PopLayerDownloadManage.getInstance(mContext, mWebView, mSlotId).getAppInfo(orderId);
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @JavascriptInterface
        public void dealH5Download(String url) {
            try {
                if (preWebViewIsVisibility()) {
                    PopLayerDownloadManage.getInstance(mContext, FoxSDK.mPreweb, mSlotId).dealCommonDownload(url);
                } else {
                    PopLayerDownloadManage.getInstance(mContext, mWebView, mSlotId).dealCommonDownload(url);
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @JavascriptInterface
        public void toOpenApp() {
            try {
                if (preWebViewIsVisibility()) {
                    PopLayerDownloadManage.getInstance(mContext, FoxSDK.mPreweb, mSlotId).dealCommonDownload(PopLayerDownloadManage.getDownloadUrl());
                } else {
                    PopLayerDownloadManage.getInstance(mContext, mWebView, mSlotId).dealCommonDownload(PopLayerDownloadManage.getDownloadUrl());
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @JavascriptInterface
        public void toInstallApp() {
            try {
                if (preWebViewIsVisibility()) {
                    PopLayerDownloadManage.getInstance(mContext, FoxSDK.mPreweb, mSlotId).dealCommonDownload(PopLayerDownloadManage.getDownloadUrl());
                } else {
                    PopLayerDownloadManage.getInstance(mContext, mWebView, mSlotId).dealCommonDownload(PopLayerDownloadManage.getDownloadUrl());
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @JavascriptInterface
        public void toNewWebView(final String tagUrl, final int type, final String extParam) {
            ((Activity) mContext).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (type == 0) {
                        //播放我们自己的视频
                        try {
                            Bundle bundle = new Bundle();
                            bundle.putString(BUNDLE_KEY_URL, tagUrl);
                            FoxVideoDialog dialog = FoxVideoDialog.newInstance(bundle);
                            String tag = FoxVideoDialog.class.getSimpleName();
                            dialog.setOnMessageListener(new OnDialogMessage() {
                                @Override
                                public void closeMessage(String type, String msg) {
                                    //关闭信息回传
                                    if (mWebView == null || TextUtils.isEmpty(type)) {
                                        return;
                                    }
                                    if (Constants.KEY_VIDEO_DIALOG_CALLBACK_MESSAGE_ONE.equals(type)) {
                                        mWebView.loadUrl("javascript:receiveMsgFromWebview2(" + msg + ")");
                                        return;
                                    }
                                    if (Constants.KEY_VIDEO_DIALOG_CALLBACK_MESSAGE_TWO.equals(type)) {
                                        mWebView.loadUrl("javascript:webviewCloseByH5(" + msg + ")");
                                        return;
                                    }
                                }
                            });
                            if (mContext instanceof FragmentActivity) {
                                dialog.showAllowingStateLoss(((FragmentActivity) mContext).getSupportFragmentManager(), tag);
                            }
                        } catch (Exception ignored) {
                            FoxBaseCrashUtils.reportErrorData(ignored);
                        }
                        return;
                    }
                    if (mContext != null && mContext instanceof FoxActivity) {
                        int slotId = 0;
                        try {
                            String appSlotIdString = (String) new JSONObject(extParam).get("slotid");
                            if (!TextUtils.isEmpty(appSlotIdString) && TextUtils.isDigitsOnly(appSlotIdString)) {
                                slotId = Integer.parseInt(appSlotIdString);
                            }
                        } catch (Exception e) {
                            FoxBaseCrashUtils.reportErrorData(e);
                            e.printStackTrace();
                        }
                        MessageData messageData = new MessageData();
                        messageData.setCode(type);
                        messageData.setSlotId(slotId);
                        ((FoxActivity) mContext).showMediaAdVideo(messageData);
                    }
                }
            });
        }
    }

}