package com.mediamain.android.view;

import android.content.Context;
import android.support.v4.util.ArrayMap;

import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.base.FoxView;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.interfaces.FoxNsTmListener;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.util.FoxGsonUtil;
import com.mediamain.android.view.util.FoxListenerManager;
import com.mediamain.android.view.util.FoxListenerObserver;
import com.mediamain.android.view.util.FoxViewCommonUtils;
import com.mediamain.android.view.util.FoxViewMaidianUtils;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * Author: Zhougaofeng
 * Email: 365315018@qq.com
 * Time: 2016/11/12
 * Description: 自定义
 */
public class FoxCustomerTm implements FoxListenerObserver {

    private static final String TAG = "FoxCustomerTm";

    private Context mContext;
    private FoxNsTmListener mAdListener;
    private boolean is_clicked = false;
    private boolean is_exposure = false;
    private FoxResponseBean.DataBean mData;
    private String mAppKey;
    private String mAppSecret;
    private int mAdslotId;
    private String mUserId;
    private String mkey;
    private int mUserImageUrl = 1;
    private WeakReference<FoxActivity> activityWeakReference;


    public FoxCustomerTm(Context context) {
        mContext = context;
        mkey = UUID.randomUUID().toString();
        FoxListenerManager.getInstance().registrationObserver(mkey, this);
    }

    /**
     * 信息回传
     */
    public void sendMessage(int type, String data) {
        try {
            if (activityWeakReference != null) {
                ((FoxActivity) (activityWeakReference.get())).sendMessage(type, data);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 设置GG回调
     *
     * @param adListener
     */
    public void setAdListener(FoxNsTmListener adListener) {
        mAdListener = adListener;
    }

    public void loadAd(int adslot_id) {
        mAdslotId = adslot_id;
        mUserId = "";
        loadAdRequest(adslot_id, mUserId);
    }

    public void loadAd(int adslot_id, String userId) {
        mAdslotId = adslot_id;
        mUserId = userId;
        loadAdRequest(adslot_id, mUserId);
    }

    public void loadAd(int adslot_id, String userId, int useImageUrl) {
        mAdslotId = adslot_id;
        mUserId = userId;
        mUserImageUrl = useImageUrl;
        loadAdRequest(adslot_id, mUserId);
    }

    /**
     * 手动调用配置
     *
     * @param appKey
     * @param appSecret
     */
    public void setConfigInfo(String appKey, String appSecret) {
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
    }

    /**
     * 活动加载
     */
    public void openFoxActivity(String url) {
        if (!FoxBaseCommonUtils.isEmpty(url)) {
            FoxBaseLogUtils.d(TAG + "——>openFoxActivity:url->" + url);
            if (!FoxBaseCommonUtils.isEmpty(mkey)) {
                FoxBaseSPUtils.getInstance().setString(mkey, mAdslotId + "");
            }
            FoxActivity.starActivity(mContext, mkey, url, FoxSDKType.FOX_CUSTOMER_TM.getCode());
        }
    }

    /**
     * GG曝光上报
     */
    public void adExposed() {
        if (mData != null && !is_exposure) {
            doResponse(0);
            is_exposure = true;
        }
    }

    /**
     * GG点击上报
     */
    public void adClicked() {
        if (mData != null && !is_clicked) {
            doResponse(1);
            is_clicked = true;
        }
    }

    @Override
    public void update(String event, Object msg) {
        try {
            if (!FoxBaseCommonUtils.isEmpty(event)) {
                if (event.contains(Constants.KEY_AD_CLOSE)) {
                    if (mAdListener != null && msg instanceof String) {
                        mAdListener.onAdActivityClose((String) msg);
                    }
                    return;
                }
                if (event.contains(Constants.KEY_AD_MESSAGE)) {
                    if (mAdListener != null && msg instanceof MessageData) {
                        mAdListener.onAdMessage((MessageData) msg);
                    }
                    return;
                }
                if (event.contains(Constants.KEY_ACTIVITY_EXAMPLE)) {
                    activityWeakReference = new WeakReference<>((FoxActivity) msg);
                    return;
                }

            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 销毁view
     * 注销key
     */
    public void destroy() {
        try {
            FoxBaseLogUtils.d(TAG + "——>destroy:");
            FoxListenerManager.getInstance().unregistrationObserver(mkey, this);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

//-------------------------------------------------Private--------------------------------------------------------------

    /**
     * 请求GG
     *
     * @param adslot_id
     * @param userId
     */
    private void loadAdRequest(final int adslot_id, String userId) {

        try {
            FoxBaseLogUtils.d(TAG + "——>loadAdRequest->start");

            Map<String, String> params = new HashMap<>();
            params.put("slotAccessType", "1");
            params.put("slotSceneType", Integer.toString(FoxSDKType.FOX_CUSTOMER_TM.getCode())); //自定义接入类型
            params.put("isimageUrl", Integer.toString(mUserImageUrl));

            if (FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                mAppKey = FoxBaseCommonUtils.getAppKey();
                mAppSecret = FoxBaseCommonUtils.getAppSecret();
            }

            if (adslot_id == 0 || FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                if (mAdListener != null) {
                    mAdListener.onFailedToReceiveAd(FoxSDKError.INVALID_PARAM.getCode(), FoxSDKError.INVALID_PARAM.getMessage());
                }
                return;
            }

            FoxView.build().loadAdRequest(adslot_id, userId, false, mAppKey, mAppSecret, params, null, new ServingCallback() {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    servingSuccessResponse(data);
                }

                @Override
                public void onServingDataError(int code, String message) {
                    if (mAdListener != null) {
                        mAdListener.onFailedToReceiveAd(code, message);
                    }
                }
            });

        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            if (mAdListener != null) {
                mAdListener.onFailedToReceiveAd(FoxSDKError.UNKNOWN.getCode(), FoxSDKError.UNKNOWN.getMessage());
            }
        }
    }

    /**
     * Serving请求成功
     *
     * @param data
     */
    private void servingSuccessResponse(FoxResponseBean.DataBean data) {
        mData = data;
        if (!FoxBaseCommonUtils.isEmpty(mUserId)) {
            if (data.getActivityUrl().contains("?")) {
                mData.setActivityUrl(data.getActivityUrl() + "&userId=" + mUserId);
            } else {
                mData.setActivityUrl(data.getActivityUrl() + "?userId=" + mUserId);
            }
            //预加载
            FoxViewCommonUtils.startPreLoad(String.valueOf(mAdslotId), mData.getActivityUrl(), FoxSDKType.FOX_CUSTOMER_TM.getCode());
        }
        is_exposure = false;
        is_clicked = false;
        mAdListener.onReceiveAd(FoxGsonUtil.GsonString(mData));

    }

    /**
     * 上报接口
     *
     * @param logType 0 曝光
     *                1 点击
     */
    private void doResponse(int logType) {
        ArrayMap<String, String> params = new ArrayMap<>();
        params.put("slotAccessType", "1");
        FoxViewMaidianUtils.doResponse(mAdslotId, logType, mData, params);

    }

}
