package com.mediamain.android.view;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.mediamain.android.R;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.base.AdBase;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.holder.FoxInfoAd;
import com.mediamain.android.view.imageloader.FoxImageView;
import com.mediamain.android.view.interfaces.FoxImageLoaderCalback;
import com.mediamain.android.view.interfaces.FoxListener;
import com.mediamain.android.view.util.FoxCommonUtils;
import com.mediamain.android.view.util.FoxListenerManager;
import com.mediamain.android.view.util.FoxListenerObserver;
import com.mediamain.android.view.util.FoxStringUtil;
import com.mediamain.android.view.util.FoxViewMaidianUtils;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.UUID;

import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_APK_DOWN_SCENES_1;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INFO_STREAM_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INFO_STREAM_EXPOSED;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_EXPOSED;

/**
 * Description: 第一版信息流（仅支持：大图，左文右图样式）
 *
 */
public class FoxInfoStreamView extends AdBase implements View.OnClickListener, FoxListenerObserver, FoxInfoAd {

    private static final String TAG = "FoxInfoStreamView";

    private RelativeLayout mReRight;
    private TextView mTvRightTitle;
    private FoxImageView mImageViewRight;

    private LinearLayout mLinBootom;
    private TextView mTvBootomTitle;
    private FoxImageView mImageViewBottom;

    private ImageView mAdClose;
    private ImageView mAdIcon;

    private boolean is_clicked = false;
    private Context mContext;
    private int mAdslotId;
    private FoxResponseBean.DataBean mData;
    private String mkey;
    private WeakReference<FoxActivity> activityWeakReference;

    /**
     * 信息回传
     */
    public void sendMessage(int type, String data) {
        try {
            if (activityWeakReference != null) {
                ((FoxActivity) (activityWeakReference.get())).sendMessage(type, data);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    public void setIs_clicked(boolean is_clicked) {
        this.is_clicked = is_clicked;
    }

    public FoxInfoStreamView(Context context) {
        super(context);
        mContext = context;
        initView(mContext);
    }

    public FoxInfoStreamView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FoxInfoStreamView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        initView(context);
    }

    private void initView(Context context) {
        mkey = UUID.randomUUID().toString();
        FoxListenerManager.getInstance().registrationObserver(mkey, this);
        final View view = View.inflate(context, R.layout.fox_info_stream_container, FoxInfoStreamView.this);
        mReRight = findViewById(R.id.reRight);
        mTvRightTitle = findViewById(R.id.tvRightTitle);
        mImageViewRight = findViewById(R.id.iv_imageview_right);
        mLinBootom = findViewById(R.id.linBootom);
        mTvBootomTitle = findViewById(R.id.tvBootomTitle);

        mImageViewBottom = findViewById(R.id.iv_imageview_bottom);
        mAdClose = findViewById(R.id.adClose);
        mAdIcon = findViewById(R.id.adIcon);
        view.setOnClickListener(this);
        setVisibility(View.GONE);
    }

    public void setSlotId(int slotId){
        mAdslotId = slotId;
    }

    public void setData(FoxResponseBean.DataBean data) {
        if (data != null) {
            this.mData = data;
            is_clicked = false;
        }
    }

    /**
     * 处理UI
     *
     * @param data
     */
    public void dealViewUI(FoxResponseBean.DataBean data) {
        try {
            if (data == null) {
                return;
            }
            switch (data.getSpecType()) {
                case 1:
                    //右图模式
                    doResponse(0);
                    if (mReRight != null) {
                        mReRight.setVisibility(VISIBLE);
                    }
                    if (mLinBootom != null) {
                        mLinBootom.setVisibility(GONE);
                    }
                    setVisibility(VISIBLE);
                    if (mTvRightTitle != null) {
                        if (!FoxBaseCommonUtils.isEmpty(data.getExtTitle())) {
                            mTvRightTitle.setText(data.getExtTitle());
                        }
                    }
                    if (data.getImageUrlList() != null && data.getImageUrlList().size() != 0 && mImageViewRight != null) {
                        mImageViewRight.setVisibility(VISIBLE);
                        mImageViewRight.setBackgroundDrawable(null);
                        mImageViewRight.setImageUrl(FoxStringUtil.appandUrl(data.getImageUrlList().get(0)), R.drawable.default_image_background);
                        mImageViewRight.setLoadCallback(new FoxImageLoaderCalback() {
                            @Override
                            public void finish() {
                                if (mFoxListener != null) {
                                    mFoxListener.onAdExposure();
                                }
                            }

                            @Override
                            public void failed() {
                                if (mFoxListener != null) {
                                    mFoxListener.onLoadFailed();
                                }
                            }
                        });
                    }
                    break;
                case 2:
                    //大图模式
                    doResponse(0);
                    if (mReRight != null) {
                        mReRight.setVisibility(GONE);
                    }
                    if (mLinBootom != null) {
                        mLinBootom.setVisibility(VISIBLE);
                    }
                    setVisibility(VISIBLE);
                    if (mTvBootomTitle != null) {
                        if (!FoxBaseCommonUtils.isEmpty(data.getExtTitle())) {
                            mTvBootomTitle.setVisibility(VISIBLE);
                            mTvBootomTitle.setText(data.getExtTitle());
                        } else {
                            mTvBootomTitle.setVisibility(GONE);
                        }
                    }
                    if (data.getImageUrlList() != null && data.getImageUrlList().size() != 0 && mImageViewBottom != null) {
                        mImageViewBottom.setVisibility(VISIBLE);
                        mImageViewBottom.setBackgroundDrawable(null);
                        mImageViewBottom.setImageUrl(FoxStringUtil.appandUrl(data.getImageUrlList().get(0)), R.drawable.default_image_background);
                        mImageViewBottom.setLoadCallback(new FoxImageLoaderCalback() {
                            @Override
                            public void finish() {
                                if (mFoxListener != null) {
                                    mFoxListener.onAdExposure();
                                }
                            }

                            @Override
                            public void failed() {
                                if (mFoxListener != null) {
                                    mFoxListener.onLoadFailed();
                                }
                            }
                        });
                    }
                    break;
                default:
                    setVisibility(GONE);
                    break;
            }
            if (mAdClose != null) {
                if (data != null && data.isVisibleOfCloseButton()) {
                    mAdClose.setVisibility(View.VISIBLE);
                } else {
                    mAdClose.setVisibility(View.GONE);
                }
            }

            if (mAdIcon != null) {
                if (data != null && data.isVisibleOfIcon()) {
                    mAdIcon.setVisibility(View.VISIBLE);
                } else {
                    mAdIcon.setVisibility(View.GONE);
                }
            }
            mAdClose.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    setVisibility(GONE);
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }


    public void destroy() {
        try {
            FoxBaseLogUtils.d(TAG + "——>destroy");
            FoxListenerManager.getInstance().unregistrationObserver(mkey, this);
            if (mImageViewRight != null) {
                mImageViewRight.stopCurrentFuture(true);
                mImageViewRight = null;
            }
            if (mImageViewBottom != null) {
                mImageViewBottom.stopCurrentFuture(true);
                mImageViewBottom = null;
            }
            removeAllViews();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void setAdListener(FoxListener foxListener) {
        mFoxListener = foxListener;
    }

    @Override
    public void onClick(View v) {
        try {
            if (mData != null && getVisibility() == View.VISIBLE) {
                if (mFoxListener != null) {
                    mFoxListener.onAdClick();
                }
                if (!FoxBaseCommonUtils.isEmpty(mkey)) {
                    FoxBaseSPUtils.getInstance().setString(mkey, mAdslotId + "");
                }
                FoxBaseLogUtils.d(TAG + "——>onAdClick" + mData.getActivityUrl());
                if (!FoxBaseCommonUtils.isEmpty(mData.getActivityUrl())) {
                    if (mData.getDownloadAd() && mContext instanceof Activity && !((Activity) mContext).isFinishing()) {
                        if (mData.getActivityUrl().contains(".apk")) {
                            FoxCommonUtils.dealCommonDowdload((Activity) mContext, mData.getActivityUrl(), ANDROID_APK_EVENT_APK_DOWN_SCENES_1, "", mData);
                        } else {
                            FoxActivity.starActivity(getContext(), mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), FoxSDKType.FOX_TEMPLET_INFO_FEED.getCode());
                        }
                    } else {
                        FoxActivity.starActivity(getContext(), mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()),FoxSDKType.FOX_TEMPLET_INFO_FEED.getCode());
                    }
                }
                if (!is_clicked) {
                    doResponse(1);
                    is_clicked = true;
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public static final int TYPE = 157;

    @Override
    public void update(String event, Object msg) {
        try {
            if (!FoxBaseCommonUtils.isEmpty(event)) {
                if (event.contains(Constants.KEY_AD_CLOSE)) {
                    if (mFoxListener != null && msg instanceof String) {
                        mFoxListener.onAdActivityClose((String) msg);
                    }
                    return;
                }
                if (event.contains(Constants.KEY_AD_MESSAGE)) {
                    if (mFoxListener != null && msg instanceof MessageData) {
                        mFoxListener.onAdMessage((MessageData) msg);
                    }
                    return;
                }
                if (event.contains(Constants.KEY_ACTIVITY_EXAMPLE)) {
                    activityWeakReference = new WeakReference<>((FoxActivity) msg);
                    return;
                }

            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @NonNull
    @Override
    public View getView() {
        return this;
    }

//-------------------------------------------------Private--------------------------------------------------------------

    /**
     * 上报接口
     *
     * @param logType 0 曝光
     *                1 点击
     */
    private void doResponse(int logType) {
        ArrayMap<String,String> params = new ArrayMap<>();
        params.put("slotAccessType","0");
        FoxViewMaidianUtils.doResponse(mAdslotId,logType,mData,params);

        if (logType == 0) {
            postDownload(ANDROID_APK_EVENT_INFO_STREAM_EXPOSED, OPERATETYPE_EXPOSED);
        } else if (logType == 1) {
            postDownload(ANDROID_APK_EVENT_INFO_STREAM_CLICK, OPERATETYPE_CLICK);
        }
    }

    /**
     * 增加下载类行为埋点
     * @param dpm
     */
    private void postDownload(String dpm,int operateType) {
        if (mData == null
                || !mData.getDownloadAd()
                || !mData.getActivityUrl().endsWith(".apk")) {
            return;
        }
        HashMap<String,String> hashMap = new HashMap<>();
        hashMap.put("dpm", dpm);
        hashMap.put("apk_down_scenes", String.valueOf(ANDROID_APK_EVENT_APK_DOWN_SCENES_1));
        hashMap.put("promote_url", mData.getActivityUrl()); //兼容老数据
        hashMap.put("operateType", String.valueOf(operateType));

        FoxViewMaidianUtils.logUpload(TYPE,hashMap,mData.getSdkDsmLogRsp());
    }
}
