package com.mediamain.android.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.mediamain.android.R;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.holder.FoxSplashAd;
import com.mediamain.android.view.imageloader.FoxImageView;
import com.mediamain.android.view.interfaces.FoxBaseAdListener;
import com.mediamain.android.view.interfaces.FoxImageLoaderCalback;
import com.mediamain.android.view.util.FoxListenerManager;
import com.mediamain.android.view.util.FoxListenerObserver;
import com.mediamain.android.view.util.FoxStringUtil;
import com.mediamain.android.view.util.FoxViewMaidianUtils;

import java.lang.ref.WeakReference;
import java.util.UUID;

/**
 * Description: 开屏(重构 模板渲染)
 */
public class FoxNewShView extends RelativeLayout implements FoxListenerObserver, FoxSplashAd, View.OnClickListener {

    private static final String TAG = "FoxNewShView";
    private static int COUNT_TIME = 5;

    private Handler timerHandler = null;
    private Runnable timerRunnable = null;
    private FoxImageView mImage;
    private TextView mTimeView;
    private ImageView mAdView;
    private Intent mIntent;
    private FoxBaseAdListener mAdListener;
    private Context mContext;
    private WeakReference<FoxActivity> activityWeakReference;
    /**
     * 是否点击
     */
    private boolean is_clicked = false;
    private FoxResponseBean mTmResponse;
    private FoxResponseBean.DataBean mData;
    //GGid
    private int mAdslotId;
    private String mkey;

    public FoxNewShView(Context context) {
        super(context);
        mContext = context;
        initView(context);
    }

    public FoxNewShView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FoxNewShView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FoxShView);
        initView(context);
    }

    public void setAdListener(FoxBaseAdListener adListener) {
        mAdListener = adListener;
    }

    public void setData(FoxResponseBean data) {
        if (data != null) {
            this.mTmResponse = data;
            if (data.getData() != null) {
                this.mData = data.getData();
                is_clicked = false;
            }
        }
    }

    public void setData(FoxResponseBean.DataBean data) {
        if (data != null) {
            this.mData = data;
            is_clicked = false;
        }
    }

    /**
     * 信息回传
     */
    public void sendMessage(int type, String data) {
        try {
            if (activityWeakReference != null) {
                ((FoxActivity) (activityWeakReference.get())).sendMessage(type, data);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 设置跳过时间
     *
     * @param time s
     */
    @Override
    public void setCountTtime(int time) {
        if (time > 0) {
            COUNT_TIME = time;
            mTimeView.setText(COUNT_TIME + " 跳过");
        }
    }

    /**
     * 设置广告位Id
     *
     * @param slotId
     */
    public void setSlotId(int slotId) {
        this.mAdslotId = slotId;
    }

    /**
     * 设置ImageView控件视图
     *
     * @param imageUrl
     */
    public void setImageUrl(String imageUrl) {
        if (mImage != null) {
            mImage.setVisibility(View.VISIBLE);
            mImage.setImageUrl(imageUrl, R.drawable.default_image_background);
        }
    }

    private Bitmap customBitmap;

    public void setImageSrc(Bitmap bitmap) {
        customBitmap = bitmap;
        if (mImage != null) {
            mImage.setVisibility(VISIBLE);
            mImage.setImageSrc(bitmap);
        }
    }

    public void setTimeViewIsDisplay(boolean isDisplay) {
        if (mTimeView != null) {
            mTimeView.setVisibility(isDisplay ? View.VISIBLE : View.GONE);
        }
    }

    public void setAdViewIsDisplay(boolean isDisplay) {
        if (mAdView != null) {
            mAdView.setVisibility(isDisplay ? View.VISIBLE : View.GONE);
        }
    }

    public void destroy() {
        try {
            FoxBaseLogUtils.d(TAG + "——>destroy");
            FoxListenerManager.getInstance().unregistrationObserver(mkey, this);
            if (mImage != null) {
                mImage.stopCurrentFuture(true);
                mImage = null;
            }
            if (timerHandler != null && timerRunnable != null) {
                timerHandler.removeCallbacks(timerRunnable);
                timerHandler.removeCallbacksAndMessages(null);
            }
            timerHandler = null;
            timerRunnable = null;
            mAdListener = null;
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void update(String event, Object msg) {
        try {
            if (!FoxBaseCommonUtils.isEmpty(event)) {
                if (event.contains(Constants.KEY_AD_CLOSE)) {
                    if (mAdListener != null && msg instanceof String) {
                        mAdListener.onAdActivityClose((String) msg);
                    }
                    return;
                }
                if (event.contains(Constants.KEY_AD_MESSAGE)) {
                    if (mAdListener != null && msg instanceof MessageData) {
                        mAdListener.onAdMessage((MessageData) msg);
                    }
                    return;
                }
                if (event.contains(Constants.KEY_ACTIVITY_EXAMPLE)) {
                    activityWeakReference = new WeakReference<>((FoxActivity) msg);
                    return;
                }

            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @NonNull
    @Override
    public View getView() {
        return this;
    }

    @Override
    public void setScaleType(ImageView.ScaleType type) {
        if (mImage != null) {
            mImage.setScaleType(type);
        }
    }

    /**
     * 素材点击处理
     *
     * @param v
     */
    @Override
    public void onClick(View v) {
        try {
            if (getVisibility() == View.VISIBLE) {
                if (timerHandler != null && timerRunnable != null) {
                    timerHandler.removeCallbacks(timerRunnable);
                    timerHandler.removeCallbacksAndMessages(null);
                }
                if (mAdListener != null) {
                    mAdListener.onAdClick();
                }
                if (mData != null) {
                    if (!FoxBaseCommonUtils.isEmpty(mkey)) {
                        FoxBaseSPUtils.getInstance().setString(mkey, mAdslotId + "");
                    }
                    FoxBaseLogUtils.d(TAG + "——>onAdClick" + mData.getActivityUrl());
                    if (mIntent == null) {
                        FoxActivity.starActivity(mContext, mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), FoxSDKType.FOX_NATIVE_SPLASH.getCode());
                    } else {
                        FoxActivity.starActivity(mContext, mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), mIntent, FoxSDKType.FOX_NATIVE_SPLASH.getCode());
                    }
                }
                if (!is_clicked) {
                    doResponse(1);
                    is_clicked = true;
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

//-------------------------------------------------Private--------------------------------------------------------------

    @SuppressLint("WrongViewCast")
    private void initView(final Context context) {
        mkey = UUID.randomUUID().toString();
        FoxListenerManager.getInstance().registrationObserver(mkey, this);
        View.inflate(context, R.layout.fox_splash_container, FoxNewShView.this);
        mImage = findViewById(R.id.iv_image);
        mTimeView = (TextView) findViewById(R.id.time_button);
        mAdView = (ImageView) findViewById(R.id.ad_icon);
        mTimeView.setText(COUNT_TIME + " 跳过");
        //点击跳过按钮
        mTimeView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mAdListener != null) {
                    mAdListener.onCloseClick();
                    FoxBaseLogUtils.d(TAG + "——>onCloseClick");
                }
            }
        });
        mImage.setOnClickListener(this);

        mImage.setLoadCallback(new FoxImageLoaderCalback() {
            @Override
            public void finish() {
                try {
                    final int[] countDown = {COUNT_TIME};
                    if (timerHandler == null) {
                        timerHandler = new Handler();
                    }
                    if (timerRunnable == null) {
                        timerRunnable = new Runnable() {
                            @Override
                            public void run() {
                                countDown[0]--;
                                if (mTimeView != null) {
                                    mTimeView.setText(countDown[0] + " 跳过");
                                }
                                if (countDown[0] > 0 && timerHandler != null) {
                                    timerHandler.postDelayed(this, 1000);
                                } else {
                                    //倒计时结束
                                    if (mAdListener != null) {
                                        mAdListener.onTimeOut();
                                        FoxBaseLogUtils.d(TAG + "——>onTimeOut");
                                    }
                                }
                            }
                        };
                    }
                    timerHandler.postDelayed(timerRunnable, 1000);
                    setVisibility(View.VISIBLE);
                    doResponse(0);
                    if (mAdListener != null) {
                        mAdListener.onReceiveAd();
                        mAdListener.onAdExposure();
                        FoxBaseLogUtils.d(TAG + "——>onReceiveAd");
                        FoxBaseLogUtils.d(TAG + "——>onAdExposure");
                    }
                } catch (Exception e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }
            }

            @Override
            public void failed() {
                if (mAdListener != null) {
                    mAdListener.onLoadFailed();
                    FoxBaseLogUtils.d(TAG + "——>onLoadFailed");
                }
            }
        });
        setVisibility(INVISIBLE);
    }

    /**
     * 上报接口
     *
     * @param logType 0 曝光
     *                1 点击
     */
    private void doResponse(int logType) {
        ArrayMap<String, String> params = new ArrayMap<>();
        params.put("slotAccessType", "0");
//        String size = mData.getSize();
        // 使用自定义的素材，曝光时增加字段
//        if (logType == 0 && !FoxBaseCommonUtils.isEmpty(size) && customBitmap != null && mData.getSckId() == 0) {
//            // 本地素材尺寸
//            int localWidth = customBitmap.getWidth();
//            int localHeight = customBitmap.getHeight();
//            params.put("sck_spec_custom", localWidth + "*" + localHeight);
//            params.put("sck_spec_tuia", size);
//        }
        FoxViewMaidianUtils.doResponse(mAdslotId, logType, mData, params);
    }
}
