package com.mediamain.android.view;

import android.app.Activity;
import android.app.Dialog;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.DrawableRes;
import android.support.v4.util.ArrayMap;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.ImageView;

import com.mediamain.android.R;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.base.FoxView;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.imageloader.FoxImageView;
import com.mediamain.android.view.interfaces.FoxImageLoaderCalback;
import com.mediamain.android.view.interfaces.FoxListener;
import com.mediamain.android.view.interfaces.FoxViewControl;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.util.FoxListenerManager;
import com.mediamain.android.view.util.FoxListenerObserver;
import com.mediamain.android.view.util.FoxStringUtil;
import com.mediamain.android.view.util.FoxViewCommonUtils;
import com.mediamain.android.view.util.FoxViewMaidianUtils;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @Author: Zhougaofeng
 * Email: 365315018@qq.com
 * Time: 2016/10/24
 * Description: ------普通插屏-------
 */
public class FoxTbScreen implements FoxViewControl, FoxListenerObserver, View.OnClickListener {

    private static final String TAG = "FoxWallView";

    private Activity mActivity;

    private Dialog mDialog;
    private FoxImageView mImage;
    private ImageButton mButton;
    private ImageView mAdIcon;
    private FoxListener mFoxListener;
    private FoxResponseBean.DataBean mData;

    private String mAppKey;
    private String mAppSecret;
    private int mAdslotId;
    private String mUserId;
    private String mkey;
    private WeakReference<FoxActivity> activityWeakReference;

    private boolean is_clicked = false;

    public FoxTbScreen(Activity activity) {
        try {
            this.mActivity = activity;
            mkey = UUID.randomUUID().toString();
            FoxListenerManager.getInstance().registrationObserver(mkey, this);
            mDialog = new Dialog(activity, R.style.Theme_CustomDialog);

            View view = View.inflate(activity, R.layout.fox_dialog_tmit, null);
            mDialog.setContentView(view);
            mButton = view.findViewById(R.id.close_button);
            mImage = (FoxImageView) view.findViewById(R.id.iv_image);
            mAdIcon = view.findViewById(R.id.ad_icon);
            mImage.setOnClickListener(this);
            mImage.setLoadCallback(new FoxImageLoaderCalback() {
                @Override
                public void finish() {
                    try {
                        if (mActivity != null && !mActivity.isFinishing() && mData != null && mDialog != null) {
                            mDialog.show();
                            doResponse(0);
                            if (mFoxListener != null) {
                                mFoxListener.onReceiveAd();
                                mFoxListener.onAdExposure();
                                FoxBaseLogUtils.d(TAG + "——>onReceiveAd");
                                FoxBaseLogUtils.d(TAG + "——>onAdExposure");
                            }
                        }
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        e.printStackTrace();
                    }
                }

                @Override
                public void failed() {
                    if (mFoxListener != null) {
                        mFoxListener.onLoadFailed();
                        FoxBaseLogUtils.d(TAG + "——>onLoadFailed");
                    }
                }
            });
            mButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        if (mActivity != null && !mActivity.isFinishing() && mDialog != null && mDialog.isShowing()) {
                            mDialog.dismiss();
                            if (mFoxListener != null) {
                                mFoxListener.onCloseClick();
                                FoxBaseLogUtils.d(TAG + "——>onCloseClick");
                            }
                        }
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        e.printStackTrace();
                    }
                }
            });

            mDialog.setCancelable(false);

            //设置dialog大小
            WindowManager.LayoutParams lp = mDialog.getWindow().getAttributes();
            DisplayMetrics d = activity.getResources().getDisplayMetrics(); // 获取屏幕宽、高用
            lp.width = (int) (d.widthPixels * 0.8);
            lp.height = (int) (d.widthPixels * 0.8);
            mDialog.getWindow().setAttributes(lp);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 信息回传
     */
    public void sendMessage(int type, String data) {
        try {
            if (activityWeakReference != null) {
                ((FoxActivity) (activityWeakReference.get())).sendMessage(type, data);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        try {
            FoxBaseLogUtils.d(TAG + "——>destroy:");
            FoxListenerManager.getInstance().unregistrationObserver(mkey, this);
            if (mImage != null) {
                mImage.stopCurrentFuture(true);
                mImage = null;
            }
            mDialog = null;
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void setAdListener(FoxListener foxListener) {
        mFoxListener = foxListener;
    }

    @Override
    public void loadAd(int adslot_id) {
        mAdslotId = adslot_id;
        mUserId = "";
        loadAdRequest(adslot_id, mUserId);
    }

    @Override
    public void loadAd(int adslot_id, String userId) {
        loadAdRequest(adslot_id, userId);
    }

    /**
     * 手动调用配置
     *
     * @param appKey
     * @param appSecret
     */
    public void setConfigInfo(String appKey, String appSecret) {
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
    }

    @Override
    public void update(String event, Object msg) {
        try {
            if (FoxBaseCommonUtils.isEmpty(event)) {
                return;
            }
            if (event.contains(Constants.KEY_AD_CLOSE)) {
                if (mFoxListener != null && msg instanceof String) {
                    mFoxListener.onAdActivityClose((String) msg);
                }
                return;
            }
            if (event.contains(Constants.KEY_AD_MESSAGE)) {
                if (mFoxListener != null && msg instanceof MessageData) {
                    mFoxListener.onAdMessage((MessageData) msg);
                }
                return;
            }
            if (event.contains(Constants.KEY_ACTIVITY_EXAMPLE)) {
                activityWeakReference = new WeakReference<>((FoxActivity) msg);
                return;
            }

        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void onClick(View v) {
        try {
            if (mActivity != null && !mActivity.isFinishing() && mDialog != null && mDialog.isShowing()) {
                if (mData != null) {
                    if (mFoxListener != null) {
                        mFoxListener.onAdClick();
                    }
                    if (!FoxBaseCommonUtils.isEmpty(mkey)) {
                        FoxBaseSPUtils.getInstance().setString(mkey, mAdslotId + "");
                    }
                    FoxBaseLogUtils.d(TAG + "——>onAdClick" + mData.getActivityUrl());
                    FoxActivity.starActivity(mActivity, mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), FoxSDKType.FOX_TB_SCREEN.getCode());
                    if (!is_clicked) {
                        doResponse(1);
                        is_clicked = true;
                    }
                }
                mDialog.dismiss();
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    private boolean useImage;
    private Bitmap customBitmap;
    private String customPath;

    public void loadCustomImage(int slotId, String userId, String path) {
        useImage = false;
        if (FoxBaseCommonUtils.isEmpty(path)) {
            return;
        }
        if (path.startsWith("http") || path.startsWith("https")) {
            customPath = path;
        } else {
            customBitmap = BitmapFactory.decodeFile(path);
        }
        loadAdRequest(slotId, userId);
    }

    public void loadCustomImage(int slotId, String userId, Bitmap bitmap) {
        useImage = false;
        customBitmap = bitmap;
        loadAdRequest(slotId, userId);
    }

    public void loadCustomImage(int slotId, String userId, @DrawableRes int resId) {
        Bitmap bitmap = BitmapFactory.decodeResource(FoxBaseSDK.getContext().getResources(), resId);
        loadCustomImage(slotId, userId, bitmap);
    }

//-------------------------------------------------Private--------------------------------------------------------------

    /**
     * 请求GG
     *
     * @param adslot_id
     * @param userId
     */
    private void loadAdRequest(final int adslot_id, String userId) {
        mAdslotId = adslot_id;
        mUserId = userId;
        try {
            FoxBaseLogUtils.d(TAG + "——>loadAdRequest->start");

            Map<String, String> params = new HashMap<>();
            params.put("slotAccessType", "0");
            params.put("slotSceneType", Integer.toString(FoxSDKType.FOX_TB_SCREEN.getCode())); //弹窗接入类型

            FoxView.build().loadAdRequest(adslot_id, userId, useImage, mAppKey, mAppSecret, params, mFoxListener, new ServingCallback() {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    servingSuccessResponse(data);
                }

                @Override
                public void onServingDataError(int code, String message) {
                }
            });

        } catch (Exception ignored) {
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    /**
     * Serving请求成功
     *
     * @param data
     */
    private void servingSuccessResponse(FoxResponseBean.DataBean data) {
        mData = data;
        if (!FoxBaseCommonUtils.isEmpty(mUserId)) {
            if (data.getActivityUrl().contains("?")) {
                mData.setActivityUrl(data.getActivityUrl() + "&userId=" + mUserId);
            } else {
                mData.setActivityUrl(data.getActivityUrl() + "?userId=" + mUserId);
            }
        }
        is_clicked = false;
        FoxViewCommonUtils.startPreLoad(String.valueOf(mAdslotId), mData.getActivityUrl(), FoxSDKType.FOX_TB_SCREEN.getCode());
        if (mImage != null) {
            // 使用本地素材
            if (data.getSckId() == 0) {
                if (customBitmap != null) {
                    mImage.setImageSrc(customBitmap);
                } else if (!FoxBaseCommonUtils.isEmpty(customPath)) {
                    mImage.setImageUrl(customPath, R.drawable.default_image_background);
                } else {
                    if (mFoxListener != null) {
                        mFoxListener.onFailedToReceiveAd(FoxSDKError.INVALID_CUSTOM_IMAGE_URI.getCode(), FoxSDKError.INVALID_CUSTOM_IMAGE_URI.getMessage());
                    }
                }
            } else {
                mImage.setImageUrl(FoxStringUtil.appandUrl(data.getImageUrlList().get(0)), R.drawable.default_image_background);
            }
            mImage.setVisibility(View.VISIBLE);
        }
        if (mButton != null) {
            mButton.setVisibility(View.VISIBLE);
        }
        if (mAdIcon != null) {
            mAdIcon.setVisibility(data.isVisibleOfIcon() ? View.VISIBLE : View.GONE);
        }
    }

    /**
     * 上报接口
     *
     * @param logType 0 曝光
     *                1 点击
     */
    private void doResponse(int logType) {
        ArrayMap<String, String> params = new ArrayMap<>();
        params.put("slotAccessType", "0");
//        String size = mData.getSize();
//        if (logType == 0 && !FoxBaseCommonUtils.isEmpty(size) && customBitmap != null && mData.getSckId() == 0) {
//            // 本地素材尺寸
//            int localWidth = customBitmap.getWidth();
//            int localHeight = customBitmap.getHeight();
//            params.put("sck_spec_custom", localWidth + "*" + localHeight);
//            params.put("sck_spec_tuia", size);
//        }
        FoxViewMaidianUtils.doResponse(mAdslotId, logType, mData, params);

    }
}
