package com.mediamain.android.view;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.mediamain.android.R;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseDensityUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.holder.FoxTextLintAd;
import com.mediamain.android.view.imageloader.FoxImageView;
import com.mediamain.android.view.interfaces.FoxListener;
import com.mediamain.android.view.util.FoxCommonUtils;
import com.mediamain.android.view.util.FoxListenerManager;
import com.mediamain.android.view.util.FoxListenerObserver;
import com.mediamain.android.view.util.FoxStringUtil;
import com.mediamain.android.view.util.FoxViewMaidianUtils;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;

import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_APK_DOWN_SCENES_1;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INFO_STREAM_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INFO_STREAM_EXPOSED;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_EXPOSED;

/**
 * Desc： 文字链
 */
public class FoxTextLinkView extends RelativeLayout implements View.OnClickListener, FoxListenerObserver, FoxTextLintAd {

    private static final String TAG = "FoxInfoStreamView";

    private FoxImageView iv_icon_image;
    private FoxImageView iv_plush_image;
    private ImageView iv_red_point;
    private TextView tv_text_link_title;
    private TextView tv_text_link_desc;

    private ImageView mAdClose;
    private ImageView mAdIcon;

    private boolean is_clicked = false;
    private FoxListener mFoxListener;
    private Context mContext;
    private int mAdslotId;
    private FoxResponseBean.DataBean mData;
    private String mkey;
    private WeakReference<FoxActivity> activityWeakReference;

    private String realShowTypes = "";

    public void setIs_clicked(boolean is_clicked) {
        this.is_clicked = is_clicked;
    }

    public FoxTextLinkView(Context context) {
        super(context);
        mContext = context;
        initView(mContext);
    }

    public FoxTextLinkView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FoxTextLinkView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        initView(context);
    }

    public void setData(FoxResponseBean.DataBean data) {
        if (data != null) {
            this.mData = data;
            is_clicked = false;
        }
    }

    public void setSlotId(int slotId) {
        mAdslotId = slotId;
    }

    /**
     * 处理UI
     *
     * @param data
     */
    public void dealViewUI(FoxResponseBean.DataBean data) {
        try {
            if (data == null) {
                if (mFoxListener != null) {
                    mFoxListener.onLoadFailed();
                }
                return;
            }
            if (mFoxListener != null) {
                mFoxListener.onAdExposure();
            }
            iv_icon_image.setVisibility(GONE);
            iv_plush_image.setVisibility(GONE);
            iv_red_point.setVisibility(GONE);
            setVisibility(VISIBLE);
            //标题
            if (tv_text_link_title != null) {
                String title = data.getExtTitle();
                if (!FoxBaseCommonUtils.isEmpty(title)) {
                    if (title.length() > 5) {
                        title = title.substring(0, 5) + "...";
                    }
                    tv_text_link_title.setText(title);
                }
            }
            //描述
            if (tv_text_link_desc != null) {
                String desc = data.getExtDesc();
                if (!FoxBaseCommonUtils.isEmpty(desc)) {
                    if (desc.length() > 9) {
                        desc = desc.substring(0, 9) + "...";
                    }
                    tv_text_link_desc.setText(desc);

                }
            }
            //Icon
            if (!FoxBaseCommonUtils.isEmpty(data.getImageUrlList())) {
                if (iv_icon_image != null) {
                    iv_icon_image.setVisibility(VISIBLE);
                    iv_icon_image.setBackgroundDrawable(null);
                    iv_icon_image.setImageUrl(FoxStringUtil.appandUrl(data.getImageUrlList().get(0)), R.drawable.default_image_background);
                }
            }
            if (!FoxBaseCommonUtils.isEmpty(data.getTheoryInteractiveTypes())) {
                List<Integer> types = data.getTheoryInteractiveTypes();
                for (int i = 0; i < types.size(); i++) {
                    if (types.get(i) == 1) {
                        //小红点
                        realShowTypes += "1,";
                        iv_red_point.setVisibility(VISIBLE);
                    } else if (types.get(i) == 2) {
                        //气泡
                        if (iv_plush_image != null && !FoxBaseCommonUtils.isEmpty(data.getTextLinkBubbleUrl())) {
                            realShowTypes += "2,";
                            iv_plush_image.setVisibility(VISIBLE);
                            iv_plush_image.setBackgroundDrawable(null);
                            iv_plush_image.setImageUrl(FoxStringUtil.appandUrl(data.getTextLinkBubbleUrl()), R.drawable.default_image_background);
                        }

                    }
                }
            }
            //曝光
            doResponse(0);

            if (mAdClose != null) {
                if (data != null && data.isVisibleOfCloseButton()) {
                    mAdClose.setVisibility(View.VISIBLE);
                } else {
                    mAdClose.setVisibility(View.GONE);
                }
            }

            if (mAdIcon != null) {
                if (data != null && data.isVisibleOfIcon()) {
                    mAdIcon.setVisibility(View.VISIBLE);
                } else {
                    mAdIcon.setVisibility(View.GONE);
                }
            }
            mAdClose.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    setVisibility(GONE);
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }


    public void destroy() {
        try {
            FoxBaseLogUtils.d(TAG + "——>destroy");
            FoxListenerManager.getInstance().unregistrationObserver(mkey, this);
            if (iv_icon_image != null) {
                iv_icon_image.stopCurrentFuture(true);
                iv_icon_image = null;
            }
            if (iv_plush_image != null) {
                iv_plush_image.stopCurrentFuture(true);
                iv_plush_image = null;
            }
            removeAllViews();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public void setAdListener(FoxListener foxListener) {
        mFoxListener = foxListener;
    }

    @Override
    public void onClick(View v) {
        try {
            iv_red_point.setVisibility(GONE);
            if (mData != null && getVisibility() == View.VISIBLE) {
                if (mFoxListener != null) {
                    mFoxListener.onAdClick();
                }
                if (!FoxBaseCommonUtils.isEmpty(mkey)) {
                    FoxBaseSPUtils.getInstance().setString(mkey, String.valueOf(mAdslotId));
                }
                FoxBaseLogUtils.d(TAG + "——>onAdClick" + mData.getActivityUrl());
                if (!FoxBaseCommonUtils.isEmpty(mData.getActivityUrl())) {
                    if (mData.getDownloadAd() && mContext instanceof Activity && !((Activity) mContext).isFinishing()) {
                        if (mData.getActivityUrl().contains(".apk")) {
                            FoxCommonUtils.dealCommonDowdload((Activity) mContext, mData.getActivityUrl(), ANDROID_APK_EVENT_APK_DOWN_SCENES_1, "", mData);
                        } else {
                            FoxActivity.starActivity(getContext(), mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), FoxSDKType.FOX_TEXT_LINK.getCode());
                        }
                    } else {
                        FoxActivity.starActivity(getContext(), mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), FoxSDKType.FOX_TEXT_LINK.getCode());
                    }
                }
                if (!is_clicked) {
                    doResponse(1);
                    is_clicked = true;
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public static final int TYPE = 157;

    /**
     * 信息回传
     */
    public void sendMessage(int type, String data) {
        try {
            if (activityWeakReference != null) {
                ((FoxActivity) (activityWeakReference.get())).sendMessage(type, data);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    @Override
    public void update(String event, Object msg) {
        try {
            if (!FoxBaseCommonUtils.isEmpty(event) && event.contains(Constants.KEY_AD_CLOSE)) {
                if (mFoxListener != null && msg instanceof String) {
                    mFoxListener.onAdActivityClose((String) msg);
                }
            }
            if (event.contains(Constants.KEY_AD_MESSAGE)) {
                if (mFoxListener != null && msg instanceof MessageData) {
                    mFoxListener.onAdMessage((MessageData) msg);
                }
                return;
            }
            if (event.contains(Constants.KEY_ACTIVITY_EXAMPLE)) {
                activityWeakReference = new WeakReference<>((FoxActivity) msg);
                return;
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @NonNull
    @Override
    public View getView() {
        return this;
    }


    @Override
    public void setScaleType(ImageView.ScaleType type) {
        if (null != type) {
            iv_icon_image.setScaleType(type);
        }
    }

    @Override
    public void setTitleSize(float size) {
        if (size > 0) {
            tv_text_link_title.setTextSize(size);
        }
    }

    @Override
    public void setTitleColor(int color) {
        tv_text_link_title.setTextColor(color);
    }

    @Override
    public void setDescSize(float size) {
        if (size > 0) {
            tv_text_link_desc.setTextSize(size);
        }
    }

    @Override
    public void setDescColor(int color) {
        tv_text_link_desc.setTextColor(color);
    }

    /**
     * 设置Icon宽高
     *
     * @param width           （unit：dp）
     * @param height（unit：dp）
     */
    @Override
    public void setIconWidthAndHeight(float width, float height) {
        ViewGroup.LayoutParams layoutParams = iv_icon_image.getLayoutParams();
        if (null != layoutParams) {
            layoutParams.width = FoxBaseDensityUtils.dp2px(getContext(), width);
            layoutParams.height = FoxBaseDensityUtils.dp2px(getContext(), height);
            iv_icon_image.setLayoutParams(layoutParams);
        }
    }

    @Override
    public void setIconMargin(int left, int top, int right, int bottom) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) iv_icon_image.getLayoutParams();
        if (null != layoutParams) {
            layoutParams.setMargins(left, top, right, bottom);
            iv_icon_image.setLayoutParams(layoutParams);
        }
    }

    @Override
    public void setTitleMargin(int left, int top, int right, int bottom) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) tv_text_link_title.getLayoutParams();
        if (null != layoutParams) {
            layoutParams.setMargins(left, top, right, bottom);
            tv_text_link_title.setLayoutParams(layoutParams);
        }
    }

    /**
     * @return 是否有Icon 0-没有 1-有
     */
    @Override
    public int getType() {
        int type = 1;
        if (null != mData) {
            type = FoxBaseCommonUtils.isEmpty(mData.getImageUrl()) ? 0 : 1;
        }
        return type;
    }

//-------------------------------------------------Private--------------------------------------------------------------

    private void initView(Context context) {
        mkey = UUID.randomUUID().toString();
        FoxListenerManager.getInstance().registrationObserver(mkey, this);
        final View view = View.inflate(context, R.layout.fox_text_link, this);
        iv_icon_image = view.findViewById(R.id.iv_icon_image);
        tv_text_link_title = view.findViewById(R.id.tv_text_link_title);
        iv_plush_image = view.findViewById(R.id.iv_plush_image);
        tv_text_link_desc = view.findViewById(R.id.tv_text_link_desc);
        iv_red_point = view.findViewById(R.id.iv_red_point);

        mAdClose = view.findViewById(R.id.adClose);
        mAdIcon = view.findViewById(R.id.adIcon);
        view.setOnClickListener(this);
        iv_icon_image.setVisibility(GONE);
        iv_plush_image.setVisibility(GONE);
        iv_red_point.setVisibility(GONE);
        setVisibility(View.GONE);
    }

    /**
     * 增加下载类行为埋点
     *
     * @param dpm
     */
    private void postDownload(String dpm, int operateType) {
        try {
            if (mData == null
                    || !mData.getDownloadAd()
                    || !mData.getActivityUrl().endsWith(".apk")) {
                return;
            }
            FoxBaseMaidianUtil.build(TYPE)
                    .set("dpm", dpm)
                    .set("apk_down_scenes", Integer.toString(ANDROID_APK_EVENT_APK_DOWN_SCENES_1))
                    .set("promote_url", mData.getActivityUrl())
                    .set("operateType", Integer.toString(operateType))
                    .postScmLog(mData.getSdkDsmLogRsp());
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 上报接口
     *
     * @param logType 0 曝光
     *                1 点击
     */
    private void doResponse(int logType) {

        ArrayMap<String, String> params = new ArrayMap<>();
        params.put("slotAccessType", "0");
        params.put("actualInteractiveTypes", realShowTypes);
        int slotId = -1;
        try {
            slotId = Integer.valueOf(mAdslotId);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        FoxViewMaidianUtils.doResponse(slotId, logType, mData, params);

        if (logType == 0) {
            postDownload(ANDROID_APK_EVENT_INFO_STREAM_EXPOSED, OPERATETYPE_EXPOSED);
        } else if (logType == 1) {
            postDownload(ANDROID_APK_EVENT_INFO_STREAM_CLICK, OPERATETYPE_CLICK);
        }

    }

}
