package com.mediamain.android.view;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.DrawableRes;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.mediamain.android.R;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseAnimationUtil;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseDensityUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.base.AdBase;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.imageloader.FoxImageView;
import com.mediamain.android.view.interfaces.FoxImageLoaderCalback;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.util.FoxListenerManager;
import com.mediamain.android.view.util.FoxListenerObserver;
import com.mediamain.android.view.util.FoxStringUtil;
import com.mediamain.android.view.util.FoxViewCommonUtils;
import com.mediamain.android.view.util.FoxViewMaidianUtils;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * Author: Zhougaofeng
 * Email: 365315018@qq.com
 * Time: 2016/11/1
 * Description: -------浮标-------
 */
public class FoxWallView extends AdBase implements View.OnClickListener, Serializable, FoxListenerObserver {

    public static final String DOBBER_EXPOSURE_COUNT = "dobber_exposure_count"; //曝光次数
    public static final String DOBBER_EXPOSURE_DATE = "dobber_exposure_date"; //曝光次数记录的时间
    private static final int ANIMATION_SHOW_INTERVAL = 3000; //交互动画停留时间
    private static final int ANIMATION_DURATION = 450; //交互动画时间
    private static final String TAG = "FoxWallView";

    private ValueAnimator inAnimator;
    private ValueAnimator outAnimator;

    private ScheduledExecutorService executorService;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable runnable;

    private int countDown = -1;
    private int currentMargin;
    private int minWidth, maxWidth, maxMargin;
    private float dx, dy;

    /**
     * 当前动画状态：
     * 0 -> 无动画
     * 1 -> 入场动画中
     * 2 -> 出场动画中
     */
    private int animationType;

    private FoxImageView mImage;
    private ImageView mCloseView;
    private ImageView mAdView;
    private ImageView mPlushView;
    private RelativeLayout mAdContainer;
    private FoxCycleViewPager mCycleViewPager;

    private int mShape;
    private Context mContext;
    private boolean is_clicked = false;
    private FoxResponseBean.DataBean mData;
    private int mAdslotId;
    private String mUserId;
    private String mkey;
    private float mWidth = LayoutParams.WRAP_CONTENT;
    private float mHeight = LayoutParams.WRAP_CONTENT;

    private int plushWidth;
    private int plushHeight;
    private int mPlushType = -1;
    private int mActualInteractiveType = 0;
    private WeakReference<FoxActivity> activityWeakReference;

    public FoxWallView(Context context, int shape) {
        super(context);
        mShape = shape;
        mContext = context.getApplicationContext();
        initView(context);
    }

    public FoxWallView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FoxWallView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context.getApplicationContext();
        initAttributes(context, attrs, defStyleAttr);
        initView(context);
    }

    private void initAttributes(Context context, AttributeSet attrs, int defStyle) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.FoxWallView, defStyle, 0);
        mShape = array.getInt(R.styleable.FoxWallView_wall_shape, 0);
        plushWidth = array.getInt(R.styleable.FoxWallView_plush_width, -1);
        plushHeight = array.getInt(R.styleable.FoxWallView_plush_height, -1);

        String width = "";
        String height = "";
        for (int i = 0; i < attrs.getAttributeCount(); i++) {
            if ("layout_height".equals(attrs.getAttributeName(i))) {
                height = attrs.getAttributeValue(i);
            } else if ("layout_width".equals(attrs.getAttributeName(i))) {
                width = attrs.getAttributeValue(i);
            }
        }

        try {
            width = width.substring(0, width.indexOf("d"));
            height = height.substring(0, height.indexOf("d"));
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
        }

        if (!FoxBaseCommonUtils.isEmpty(width)) {
            try {
                mWidth = Float.parseFloat(width);
            } catch (Exception ignored) {
                FoxBaseCrashUtils.reportErrorData(ignored);
            }
        }
        if (!FoxBaseCommonUtils.isEmpty(height)) {
            try {
                mHeight = Float.parseFloat(height);
            } catch (Exception ignored) {
                FoxBaseCrashUtils.reportErrorData(ignored);
            }
        }

        array.recycle();
    }

    private void initView(Context context) {
        mkey = UUID.randomUUID().toString();
        FoxListenerManager.getInstance().registrationObserver(mkey, this);
        View view = View.inflate(context, R.layout.fox_wall_view, this);
        mCloseView = view.findViewById(R.id.iv_close);
        mAdView = view.findViewById(R.id.iv_ad);
        mPlushView = view.findViewById(R.id.iv_plush);
        mAdContainer = view.findViewById(R.id.rl_ad_container);
        mImage = view.findViewById(R.id.iv_icon_image);
        mCycleViewPager = view.findViewById(R.id.fox_cycle_vp);
        setVisibility(GONE);

        LayoutParams lpContainer = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        lpContainer.width = mWidth > 0 ? dp2px(mWidth) : LayoutParams.WRAP_CONTENT;
        lpContainer.height = mHeight > 0 ? dp2px(mHeight) : LayoutParams.WRAP_CONTENT;
        lpContainer.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        lpContainer.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
        mAdContainer.setLayoutParams(lpContainer);

        mImage.setOnClickListener(this);
        mCloseView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mFoxListener != null) {
                    mFoxListener.onCloseClick();
                    FoxBaseLogUtils.d(TAG + "——>onCloseClick");
                }
                setVisibility(View.GONE);
            }
        });

        FoxImageLoaderCalback imageLoaderCalback = new FoxImageLoaderCalback() {
            @Override
            public void finish() {
                try {
                    if (mImage != null) {
                        setVisibility(View.VISIBLE);
                    }
                    imageLoadFinish();
                    doResponse(0);
                    if (mFoxListener != null) {
                        mFoxListener.onReceiveAd();
                        mFoxListener.onAdExposure();
                        FoxBaseLogUtils.d(TAG + "——>onReceiveAd");
                        FoxBaseLogUtils.d(TAG + "——>onAdExposure");
                    }
                } catch (Exception e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }
            }

            @Override
            public void failed() {
                if (mFoxListener != null) {
                    mFoxListener.onLoadFailed();
                    FoxBaseLogUtils.d(TAG + "——>onLoadFailed");
                }
            }
        };
        mImage.setLoadCallback(imageLoaderCalback);
    }

    /**
     * 设置类型4动画的参数
     * @param minWidth：view隐藏时的宽度
     * @param maxWidth：view显示时的宽度
     * @param maxMargin：view动画时位移值
     */
    public void setParams(int minWidth, int maxWidth, int maxMargin){
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.maxMargin = maxMargin;
    }

    /**
     * 设置监听用户行为
     * @param event
     */
    public void setMotionEvent(MotionEvent event){
        if (event.getAction() == MotionEvent.ACTION_DOWN){
            dx = event.getX();
            dy = event.getY();
        }else if (event.getAction() == MotionEvent.ACTION_UP){
            if (Math.abs(event.getY() - dy) > 200){
                startAnimation();
            }
        }
    }

    /**
     * 加载GG
     *
     * @param adslot_id
     */
    public void loadAd(int adslot_id) {
        mAdslotId = adslot_id;
        mUserId = "";
        loadAdRequest(adslot_id, mUserId);
    }

    /**
     * 加载GG
     *
     * @param adslot_id
     */
    public void loadAd(int adslot_id, String userId) {
        loadAdRequest(adslot_id, userId);
    }

    public void destroy() {
        try {
            FoxBaseLogUtils.d(TAG + "——>destroy");
            FoxListenerManager.getInstance().unregistrationObserver(mkey, this);
            if (mImage != null) {
                FoxBaseAnimationUtil.clearAnimation(mImage);
                mImage.stopCurrentFuture(true);
                mImage = null;
            }
            if (mCycleViewPager != null) {
                mCycleViewPager.stopAutoRotation();
            }
            FoxBaseAnimationUtil.clearAnimation(mPlushView);
            FoxBaseAnimationUtil.clearAnimation(this);
            removeAllViews();

            handler.removeCallbacksAndMessages(runnable);
            executorService.shutdown();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    @Override
    public void onClick(View v) {
        try {
            if (mData != null) {
                if (mFoxListener != null) {
                    mFoxListener.onAdClick();
                }
                if (!FoxBaseCommonUtils.isEmpty(mkey)) {
                    FoxBaseSPUtils.getInstance().setString(mkey, mAdslotId + "");
                }
                FoxBaseLogUtils.d(TAG + "——>onAdClick:url——>" + mData.getActivityUrl());
                FoxActivity.starActivity(getContext(), mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), FoxSDKType.FOX_WALL_VIEW.getCode());
                if (!is_clicked) {
                    doResponse(1);
                    is_clicked = true;
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 信息回传
     */
    public void sendMessage(int type, String data) {
        try {
            if (activityWeakReference != null) {
                ((FoxActivity) (activityWeakReference.get())).sendMessage(type, data);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void update(String event, Object msg) {
        try {
            if(FoxBaseCommonUtils.isEmpty(event)){
                return;
            }
            if (event.contains(Constants.KEY_AD_CLOSE)) {
                if (mFoxListener != null && msg instanceof String) {
                    mFoxListener.onAdActivityClose((String) msg);
                }
            }

            if (event.contains(Constants.KEY_AD_MESSAGE)) {
                if (mFoxListener != null && msg instanceof MessageData) {
                    mFoxListener.onAdMessage((MessageData) msg);
                }
                return;
            }
            if (event.contains(Constants.KEY_ACTIVITY_EXAMPLE)) {
                activityWeakReference = new WeakReference<>((FoxActivity) msg);
                return;
            }

        } catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    //本地图片设置-----start
    private Bitmap customBitmap;
    private String customPath;
    public void loadCustomImage(int slotId, String userId, String path) {
        if (FoxBaseCommonUtils.isEmpty(path)) {
            return;
        }
        if (path.startsWith("http") || path.startsWith("https")) {
            customPath = path;
        } else {
            customBitmap = BitmapFactory.decodeFile(path);
        }
        loadAdRequest(slotId, userId);
    }

    public void loadCustomImage(int slotId, String userId, Bitmap bitmap) {
        customBitmap = bitmap;
        loadAdRequest(slotId, userId);
    }

    public void loadCustomImage(int slotId, String userId, @DrawableRes int resId) {
        Bitmap bitmap = BitmapFactory.decodeResource(FoxBaseSDK.getContext().getResources(), resId);
        loadCustomImage(slotId, userId, bitmap);
    }
    //本地图片设置-----end


//-------------------------------------------------Private--------------------------------------------------------------

    /**
     * 使用类型4动画时，初始化view参数
     */
    private void initParams(){
        LayoutParams lpContainer = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        lpContainer.width = maxWidth > 0 ? dp2px(maxWidth) : LayoutParams.WRAP_CONTENT;
        lpContainer.height = maxWidth > 0 ? dp2px(maxWidth) : LayoutParams.WRAP_CONTENT;
        lpContainer.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        lpContainer.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
        mAdContainer.setLayoutParams(lpContainer);

        LayoutParams imgParams = (LayoutParams) mImage.getLayoutParams();
        imgParams.width = maxWidth > 0 ? dp2px(maxWidth) : LayoutParams.MATCH_PARENT;
        imgParams.height = maxWidth > 0 ? dp2px(maxWidth) : LayoutParams.MATCH_PARENT;
        mImage.setLayoutParams(imgParams);

        LayoutParams adParams = (LayoutParams) mAdView.getLayoutParams();
        adParams.bottomMargin = 0;
        mAdView.setLayoutParams(adParams);

        LayoutParams closeParams = (LayoutParams) mCloseView.getLayoutParams();
        closeParams.topMargin = 0;
        mCloseView.setLayoutParams(closeParams);

        mCloseView.setVisibility(VISIBLE);
        mAdView.setVisibility(VISIBLE);

        mImage.setAlpha(1.0f);
    }

    /**
     * 初始化退出动画
     */
    private void initOutAnimation(){
        if (outAnimator != null){
            return;
        }

        outAnimator = FoxBaseAnimationUtil.initOutAnimator(maxMargin, ANIMATION_DURATION);
        outAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                FoxBaseAnimationUtil.updateAnimationParams(getContext(), valueAnimator, mImage,
                        maxMargin, minWidth, maxWidth);

                if ((int)valueAnimator.getAnimatedValue() == 0){
                    animationType = 0;
                    currentMargin = 0;
                }
            }
        });
    }

    /**
     * 更新入场动画
     */
    private void updateInAnimation(){
        inAnimator = FoxBaseAnimationUtil.initInAnimator(currentMargin, maxMargin, ANIMATION_DURATION);
        inAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                FoxBaseAnimationUtil.updateAnimationParams(getContext(), valueAnimator, mImage,
                        maxMargin, minWidth, maxWidth);

                if ((int)valueAnimator.getAnimatedValue() == maxMargin){
                    mAdView.setVisibility(VISIBLE);
                    mCloseView.setVisibility(VISIBLE);
                }
            }
        });
    }

    /**
     * 初始化循环计数器
     */
    private void initThread() {
        if (executorService != null){
            return;
        }

        runnable = new Runnable() {
            @Override
            public void run() {
                mAdView.setVisibility(INVISIBLE);
                mCloseView.setVisibility(INVISIBLE);
                outAnimator.start();
                animationType = 2;
            }
        };
        executorService = Executors.newScheduledThreadPool(2);
        executorService.scheduleAtFixedRate(new Runnable() {
            @Override
            public void run() {
                if (animationType == 0){
                    return ;
                }

                countDown -= 100;

                if (countDown == 0){
                    handler.post(runnable);
                    countDown = ANIMATION_SHOW_INTERVAL;
                }
            }
        }, 100, 100, TimeUnit.MILLISECONDS);
    }

    /**
     * 启动动画
     */
    private void startAnimation(){
        if (mPlushType != 4){
            return;
        }

        countDown = ANIMATION_SHOW_INTERVAL;

        if (animationType == 1){
            return;
        }else if (animationType == 2){
            outAnimator.cancel();
        }
        updateInAnimation();
        inAnimator.start();
        animationType = 1;
    }

    /**
     * 更新动画参数
     */
    private void updateAnimationParams(){
        initThread();
        initOutAnimation();

        LayoutParams containerParams = (LayoutParams) mAdContainer.getLayoutParams();
        containerParams.width = dip2px(maxWidth);
        containerParams.height = dip2px((int) (maxMargin + maxWidth * 0.5));
        mAdContainer.setLayoutParams(containerParams);

        LayoutParams params = (LayoutParams) mImage.getLayoutParams();
        params.width = dip2px(minWidth);
        params.height = dip2px(minWidth);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
        mImage.setLayoutParams(params);
        mImage.setAlpha(0.5f);

        LayoutParams adParams = (LayoutParams) mAdView.getLayoutParams();
        adParams.bottomMargin = dp2px(minWidth + 6);
        mAdView.setLayoutParams(adParams);

        LayoutParams closeParams = (LayoutParams) mCloseView.getLayoutParams();
        closeParams.topMargin = dp2px(3);
        mCloseView.setLayoutParams(closeParams);
    }

    /**
     * 请求GG
     *
     * @param adslot_id
     * @param userId
     */
    private void loadAdRequest(final int adslot_id, String userId) {
        try {
            initParams();

            mAdslotId = adslot_id;
            mUserId = userId;

            int deviceSlotExpCount = FoxBaseSPUtils.getInstance().getInt(FoxWallView.DOBBER_EXPOSURE_COUNT,1); //曝光次数
            FoxBaseSPUtils.getInstance().setInt(FoxWallView.DOBBER_EXPOSURE_COUNT,deviceSlotExpCount + 1);
            stopAnimator();

            FoxBaseLogUtils.d(TAG + "——>loadAdRequest->start");
            setVisibility(View.GONE);

            Map<String, String> params = new HashMap<>();
            params.put("deviceSlotExpCount",Integer.toString(deviceSlotExpCount));
            params.put("slotAccessType", "0");
            params.put("slotSceneType", Integer.toString(FoxSDKType.FOX_WALL_VIEW.getCode())); //Icon接入类型

            loadAdRequest(adslot_id, userId, false, params, new ServingCallback() {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    super.onServingDataCorrect(data);
                    servingSuccessResponse(data);
                }

                @Override
                public void onServingDataError(int code, String message) {
                    super.onServingDataError(code, message);
                }
            });

        } catch (Exception ignored) {
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    /**
     * Serving请求成功
     * @param data
     */
    private void servingSuccessResponse(FoxResponseBean.DataBean data){
        // ServingCallback已经处理了data为空的场景
        mData = data;
        mPlushType = data.getTheoryInteractiveType();
        final List<String> imgUrls = data.getImageUrlList();
        if (mPlushType == 3) {
            // 轮播动效
            int playInterval = data.getIconPlayInterval();
            mCycleViewPager.startAutoRotation(playInterval < 0 ? 0 : playInterval * 1000);
            setVisibility(VISIBLE);
            if (mImage != null) {
                mImage.setVisibility(GONE);
            }
            if (mCycleViewPager != null) {
                mCycleViewPager.setVisibility(VISIBLE);
                showDynamic03(imgUrls);
            }
        } else if (mPlushType == 4) {
            setVisibility(VISIBLE);
            mImage.setVisibility(VISIBLE);
            mAdView.setVisibility(INVISIBLE);
            mCloseView.setVisibility(INVISIBLE);

            updateAnimationParams();

            is_clicked = false;
            if (data.getSckId() == 0) {
                if (customBitmap != null) {
                    mImage.setImageSrc(customBitmap);
                } else if (!FoxBaseCommonUtils.isEmpty(customPath)) {
                    mImage.setImageUrl(customPath, R.drawable.default_image_background);
                } else {
                    if (mFoxListener != null) {
                        mFoxListener.onFailedToReceiveAd(FoxSDKError.INVALID_CUSTOM_IMAGE_URI.getCode(), FoxSDKError.INVALID_CUSTOM_IMAGE_URI.getMessage());
                    }
                }
            } else {
                String imageUrl = imgUrls.get(0);
                if (!TextUtils.isEmpty(imageUrl)) {
                    mImage.setImageUrl(FoxStringUtil.appandUrl(data.getImageUrl()), R.drawable.default_image_background);
                }
            }
        } else {
            setVisibility(VISIBLE);
            if (mCycleViewPager != null) {
                mCycleViewPager.setVisibility(GONE);
            }
            if (!FoxBaseCommonUtils.isEmpty(mUserId)) {
                if (data.getActivityUrl().contains("?")) {
                    mData.setActivityUrl(data.getActivityUrl() + "&userId=" + mUserId);
                } else {
                    mData.setActivityUrl(data.getActivityUrl() + "?userId=" + mUserId);
                }
            }
            is_clicked = false;
            if (null != mImage) {
                mImage.setVisibility(VISIBLE);
                mImage.setBackgroundDrawable(null);
                if (data.getSckId() == 0) {
                    if (customBitmap != null) {
                        mImage.setImageSrc(customBitmap);
                    } else if (!FoxBaseCommonUtils.isEmpty(customPath)) {
                        mImage.setImageUrl(customPath, R.drawable.default_image_background);
                    } else {
                        if (mFoxListener != null) {
                            mFoxListener.onFailedToReceiveAd(FoxSDKError.INVALID_CUSTOM_IMAGE_URI.getCode(), FoxSDKError.INVALID_CUSTOM_IMAGE_URI.getMessage());
                        }
                    }
                } else {
                    String imageUrl = imgUrls.get(0);
                    if (!TextUtils.isEmpty(imageUrl)) {
                        mImage.setImageUrl(FoxStringUtil.appandUrl(data.getImageUrl()), R.drawable.default_image_background);
                    }
                }
            }
            if (mCloseView != null) {
                mCloseView.setVisibility(data.isVisibleOfCloseButton() ? View.VISIBLE : View.GONE);
            }
            if (mAdView != null) {
                mAdView.setVisibility(data.isVisibleOfIcon() ? View.VISIBLE : View.GONE);
            }
        }
        //预加载
        FoxViewCommonUtils.startPreLoad(String.valueOf(mAdslotId), mData.getActivityUrl(), FoxSDKType.FOX_WALL_VIEW.getCode());
    }

    /**
     * 停止动画
     */
    private void stopAnimator(){
        try {
            FoxBaseAnimationUtil.isTranlateDownning = false;
            FoxBaseAnimationUtil.clearAnimation(mImage);
            FoxBaseAnimationUtil.clearAnimation(mPlushView);
            FoxBaseAnimationUtil.localAnimatorSet.end();
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
        mPlushView.setVisibility(GONE);
    }

    //图片加载完成
    private void imageLoadFinish() {
        switch (mPlushType) {
            case -1:
            case 0:
                //默认：无
                mActualInteractiveType = 0;
                showDynamic0();
                break;
            case 1:
                //可领取
                mActualInteractiveType = 1;
                showDynamic01();
                break;
            case 2:
                //降落抖动
                mActualInteractiveType = 2;
                showDynamic02();
                break;
            case 4:
                // 位移放大
                mActualInteractiveType = 4;
                break;
            default:
                break;
        }
    }

    //默认
    private void showDynamic0() {
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        layoutParams.width = mWidth > 0 ? dp2px(mWidth) : (int) mWidth;
        layoutParams.height = mHeight > 0 ? dp2px(mHeight) : (int) mHeight;
        setLayoutParams(layoutParams);

    }

    //可领取动效
    private void showDynamic01(){
        mPlushView.setImageResource(R.drawable.fox_dobber_plush01_icon);
        mPlushView.setScaleType(ImageView.ScaleType.FIT_XY);
        LayoutParams mPlushViewLayoutParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);;
        mPlushViewLayoutParams.width = plushWidth > 0 ? dp2px(plushWidth) : dp2px(mWidth);
        mPlushViewLayoutParams.height = plushHeight > 0 ? dp2px(plushHeight) : (int) (dp2px(mHeight) * 0.7);
        mPlushView.setLayoutParams(mPlushViewLayoutParams);
        mPlushView.setVisibility(VISIBLE);
        //整体宽高扩容
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        if(null != layoutParams) {
            layoutParams.width = mWidth > 0 ? dp2px((float) (mWidth * 1.4)) : (int) mWidth;
            layoutParams.height = mHeight > 0 ? dp2px((float) (mHeight * 1.4)) : (int) mHeight;
            setLayoutParams(layoutParams);
        }

        FoxBaseAnimationUtil.startScaleAnimation(mPlushView,0.7f,mPlushViewLayoutParams.width * 0.72f,mPlushViewLayoutParams.height * 0.82f);
    }

    //降落抖动
    private void showDynamic02(){
        FoxBaseAnimationUtil.isTranlateDownning = true;

        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        layoutParams.width = mWidth > 0 ? dp2px(mWidth) : (int) mWidth;
        layoutParams.height = mHeight > 0 ? dp2px(mHeight) : (int) mHeight;
        setLayoutParams(layoutParams);

        FoxBaseAnimationUtil.startTranlateDownAnimation(mImage, 0, null);
    }

    //轮播
    private void showDynamic03(final List<String> imgUrls) {
        mActualInteractiveType = 3;
        mCycleViewPager.setOnItemClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                FoxWallView.this.onClick(v);
            }
        });
        mCycleViewPager.loadRemoteImage(mContext, imgUrls, new FoxCycleViewPager.LoadImageListCallback() {
            @Override
            public void loadComplete() {
                doResponse(0);
                if (mFoxListener != null) {
                    mFoxListener.onReceiveAd();
                    mFoxListener.onAdExposure();
                }
            }

            @Override
            public void loadFailed() {
                if (mFoxListener != null) {
                    mFoxListener.onLoadFailed();
                }
            }
        });
    }
    /**
     * 上报接口
     *
     * @param logType 0 曝光
     *                1 点击
     */
    private void doResponse(int logType) {
        ArrayMap<String,String> params = new ArrayMap<>();
        params.put("slotAccessType","0");
        params.put("actualInteractiveType",String.valueOf(mActualInteractiveType));
        FoxViewMaidianUtils.doResponse(mAdslotId,logType,mData,params);
    }

    private int dp2px(float value) {
        return FoxBaseDensityUtils.dp2px(getContext(), value);
    }

    private int dip2px(int value){
        return FoxBaseDensityUtils.dip2px(getContext(), value);
    }
}
