package com.mediamain.android.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.support.annotation.NonNull;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;

import com.mediamain.android.R;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseBarUtils;
import com.mediamain.android.base.util.xpopup.core.BasePopupView;
import com.mediamain.android.base.util.xpopup.impl.FullScreenPopupView;
import com.mediamain.android.nativead.AdWebView;
import com.mediamain.android.nativead.AdWebViewClient;
import com.mediamain.android.nativead.H5CallBackImpl;
import com.mediamain.android.nativead.PopupActivityController;
import com.mediamain.android.nativead.WebViewCallBackImpl;
import com.mediamain.android.base.config.Constants;


/**
 * author: likaixuan
 * date: 2020/9/19
 * desc: 插屏活动的Dialog
 */
@SuppressLint("ViewConstructor")
public class PopupActivityDialog extends FullScreenPopupView implements PopupActivityController {

    private Activity mActivity;

    private ImageView backIv;
    private ProgressBar progressBar;
    private AdWebView webView;

    private String activityUrl;
    private String slotId;
    private String mKey;

    public PopupActivityDialog(@NonNull Activity activity, String slotId, String key, String url) {
        super(activity);
        mActivity = activity;
        this.slotId = slotId;
        activityUrl = url;
        mKey = key;
        initView(activity);
    }

    @Override
    protected int getImplLayoutId() {
        return R.layout.dialog_popup_activity;
    }

    private void initView(Activity activity) {
        backIv = findViewById(R.id.popup_web_back);
        progressBar = findViewById(R.id.popup_web_progress);

        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) progressBar.getLayoutParams();
        params.topMargin = FoxBaseBarUtils.getStatusBarHeight();
        progressBar.setLayoutParams(params);

        FrameLayout webContainer = findViewById(R.id.popup_web_container);

        webView = new AdWebView(activity);
        webView.setHorizontalScrollBarEnabled(false);
        webView.setVerticalScrollBarEnabled(false);

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (progressBar.getVisibility() == View.GONE) {
                    return;
                }
                progressBar.setProgress(newProgress);
                if (newProgress >= 0 && newProgress < 98) {
                    progressBar.setVisibility(View.VISIBLE);
                }
                if (newProgress >= 98) {
                    progressBar.setVisibility(View.GONE);
                }
            }
        });
        H5CallBackImpl activityH5CallBack = new H5CallBackImpl(this);
        WebViewCallBackImpl activityWebViewCallBack = new WebViewCallBackImpl();
        AdWebViewClient webViewClient = new AdWebViewClient(webView, slotId, activityWebViewCallBack, activityH5CallBack);
        webView.setWebViewClient(webViewClient);

        webContainer.addView(webView);
    }

    /**
     * 跳转：跳转我的奖品页或者奖励页
     * @param url
     */
    public void jump(String url) {
        if (webView != null) {
            webView.loadUrl(url);
        }
    }

    public AdWebView getWebView() {
        return webView;
    }

    public void setBackVisibility(boolean visibility) {
        backIv.setVisibility(visibility ? View.VISIBLE : View.GONE);
    }

    public void setProgressBarVisibility(boolean visibility) {
        progressBar.setVisibility(visibility ? View.VISIBLE : View.GONE);
    }

    @Override
    public BasePopupView show() {
        if (webView != null) {
            webView.loadUrl(activityUrl);
        }
        return super.show();
    }

    @Override
    public void popupShow() {
    }

    @Override
    public void popupClose() {
        dismiss();
    }

    @Override
    public void jump2Land(String landUrl) {
        FoxActivity.startActivity(mActivity, mKey, slotId, landUrl, FoxSDKType.NATIVE_AD.getCode());
    }

    @Override
    public void openMyPrize(String url) {

    }
}
