package com.mediamain.android.view.base;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.interfaces.FoxListener;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.bean.FoxResponseBean;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by ZSY on 2020-11-16.
 */

public class AdBase extends RelativeLayout {

    private String mAppKey;
    private String mAppSecret;
    private boolean mUseImage = false;
    public FoxListener mFoxListener;

    public AdBase(Context context) {
        this(context,null);
    }

    public AdBase(Context context, AttributeSet attrs) {
        this(context, attrs,0);
    }

    public AdBase(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setConfigInfo(String appKey, String appSecret) {
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
    }

    public void setAdListener(FoxListener foxListener) {
        this.mFoxListener = foxListener;
    }

    protected void loadAdRequest(int adslot_id, String userId, boolean useImage, Map<String,String> params, final ServingCallback servingCallback) {
        try {
            if(null == params){
                params = new HashMap<>();
            }
            mUseImage = useImage;

            FoxView.build().loadAdRequest(adslot_id, userId, useImage, mAppKey,mAppSecret, params, mFoxListener, new ServingCallback(){
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    if(null != servingCallback){
                        servingCallback.onServingDataCorrect(data);
                    }
                }
                @Override
                public void onServingDataError(int code, String message) {
                    if(null != servingCallback){
                        servingCallback.onServingDataError(code,message);
                    }
                }
            });

        } catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }
}
