package com.mediamain.android.view.base;

import android.text.TextUtils;

import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.Callback;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.okgo.request.PostRequest;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by ZSY on 2020-11-16.
 */

public class Fox {

    private final String TAG = "FoxRequest";
    /**
     * 行为上报的url链接
     */
    private String url;

    /**
     * 参数
     */
    private Map<String, String> mapParams = new HashMap<>(16);

    private Fox() {}

    private static class Holder {
        public static Fox instance = new Fox();
    }

    public static Fox build() {
        return Holder.instance;
    }

    public Fox setUrl(String url) {
        this.url = url;
        return this;
    }

    public Fox addParam(Map<String, String> params) {
        mapParams.putAll(params);
        return this;
    }

    public Fox addParam(String key, String value) {
        try {
            mapParams.put(key, value);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return this;
    }

    /**
     * Get 请求
     */
    public void get() {
        if (TextUtils.isEmpty(url)) {
            throw new IllegalArgumentException("url不能为空");
        }

        try {

            OkGo.<String>get(url).params(mapParams).execute(new StringCallback() {
                @Override
                public void onSuccess(Response<String> response) {

                }
            });
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * Get 请求
     */
    public void get(Callback callback) {
        if (TextUtils.isEmpty(url)) {
            throw new IllegalArgumentException("url不能为空");
        }

        try {

            OkGo.<String>get(url).params(mapParams).execute(callback);
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    /**
     * Post 方式上报
     */
    public void post() {
        if (TextUtils.isEmpty(url)) {
            throw new IllegalArgumentException("点击上报的url为空");
        }

        try {

            final PostRequest<String> request = OkGo.<String>post(url);
            request.params(mapParams).execute(new StringCallback() {
                @Override
                public void onSuccess(Response<String> response) {

                }
            });
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    /**
     * Post 方式上报
     */
    public void post(Callback callback) {
        if (TextUtils.isEmpty(url)) {
            throw new IllegalArgumentException("点击上报的url为空");
        }

        try {

            final PostRequest<String> request = OkGo.<String>post(url);
            request.params(mapParams).execute(callback);
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }
}
