package com.mediamain.android.view.base;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.util.FoxBaseDateUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.FoxWallView;
import com.mediamain.android.view.holder.FoxTextLinkHolderImpl;
import com.mediamain.android.view.webview.FoxBaseSdkWebView;

/**
 * @author lzy
 * Time: 2019/08/27
 * Description:
 */
public class FoxSDK {

    private static Application mApplication;

    public static void init(Application application) {
        mApplication = application;
        try {
            FoxBaseSDK.init(application, "", 0, "");
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public static void init(Application application, @NonNull String appKey, @NonNull String appSecret) {
        mApplication = application;
        ApplicationInfo info = null;
        try {
            info = application.getPackageManager().getApplicationInfo(application.getPackageName(), PackageManager.GET_META_DATA);

            if (info != null && info.metaData != null) {
                info.metaData.putString(FoxBaseConstants.KEY_TUIA_APPKEY, appKey);
                info.metaData.putString(FoxBaseConstants.KEY_TUIA_APPSECRET, appSecret);
            }
            initLocalRecord();
            FoxBaseSDK.init(application, "", 0, "", info);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 初始化浮标曝光次数
     */
    private static void initLocalRecord() {
        String nowDate = FoxBaseDateUtils.getNowDate(FoxBaseDateUtils.DatePattern.ONLY_DAY);
        String spDobberDate = FoxBaseSPUtils.getInstance().getString(FoxWallView.DOBBER_EXPOSURE_DATE, nowDate);
        String spTextLinkDate = FoxBaseSPUtils.getInstance().getString(FoxTextLinkHolderImpl.TEXT_LINK_EXPOSURE_DATE, nowDate);
        if (!nowDate.equals(spDobberDate)) {
            FoxBaseSPUtils.getInstance().setString(FoxWallView.DOBBER_EXPOSURE_DATE, nowDate);
            FoxBaseSPUtils.getInstance().setInt(FoxWallView.DOBBER_EXPOSURE_COUNT, 1);
        }
        if (!nowDate.equals(spTextLinkDate)) {
            FoxBaseSPUtils.getInstance().setString(FoxTextLinkHolderImpl.TEXT_LINK_EXPOSURE_DATE, nowDate);
            FoxBaseSPUtils.getInstance().setInt(FoxTextLinkHolderImpl.TEXT_LINK_EXPOSURE_COUNT, 1);
        }

    }

    public static Context getContext() {
        if (mApplication != null) {
            return mApplication;
        } else {
            return getApplicationByReflect();
        }
    }

    /**
     * 用户授权
     */
    public static void userEmpower(boolean isEmpower) {
        FoxBaseSDK.userEmpower(isEmpower);
    }

    public static void testCrash() {
        throw new IllegalStateException("this is a test");
    }


    public static boolean isDebug() {
        return BuildConfig.DEBUG_LOG;
    }

    /**
     * 通过反射获得appliction
     *
     * @return
     */
    private static Application getApplicationByReflect() {
        try {
            @SuppressLint("PrivateApi")
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Object thread = activityThread.getMethod("currentActivityThread").invoke(null);
            Object app = activityThread.getMethod("getApplication").invoke(thread);
            return (Application) app;
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return null;
    }

    public static FoxBaseSdkWebView mPreweb;
}
