package com.mediamain.android.view.base;

/**
 * Author: Zhougaofeng
 * Email: 365315018@qq.com
 * Time: 2016/10/24
 * Description:
 */
public class FoxSize {
    //TMBr
    public static final FoxSize TMBr = new FoxSize(640, 280, "640x280_mb");
    //横幅
    public static final FoxSize LANDER_TMBr = new FoxSize(640, 150, "640x150_mb");
    //信息流
    public static final FoxSize TMNa_750_460 = new FoxSize(750, 460, "750x460_as");
    public static final FoxSize TMNa_750_200 = new FoxSize(750, 200, "750x200_as");

    private int mWidth;
    private int mHeight;
    private String mSize;

     public FoxSize(int width, int height, String size) {
        if(width <= 0) {
            throw new IllegalArgumentException((new StringBuilder(37)).append("Invalid width for FoxSize: ").append(width).toString());
        } else if(height <= 0) {
            throw new IllegalArgumentException((new StringBuilder(38)).append("Invalid height for FoxSize: ").append(height).toString());
        } else {
            mWidth = width;
            mHeight = height;
            mSize = size;
        }
    }

    public boolean equals(Object object) {
        if(object == this) {
            return true;
        } else if(!(object instanceof FoxSize)) {
            return false;
        } else {
            FoxSize foxSize = (FoxSize)object;
            return mHeight == foxSize.mHeight && mWidth == foxSize.mWidth && mSize.equals(foxSize.mSize);
        }
    }

    public int getHeight() {
        return mHeight;
    }

    public int getWidth() {
        return mWidth;
    }

    public String getSize() {
        return mSize;
    }

    public int hashCode() {
        return mSize.hashCode();
    }

    public String toString() {
        return mSize;
    }
}
