package com.mediamain.android.view.base;

import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.AutoConfig;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.interfaces.FoxListener;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.bean.FoxResponseBean;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by ZSY on 2020-11-16.
 */

public class FoxView {

    private FoxView() {}

    private static class Holder {
        public static FoxView instance = new FoxView();
    }

    public static FoxView build() {
        return Holder.instance;
    }

    public void loadAdRequest(int adslot_id, String userId, boolean useImage,
                              String mAppKey, String mAppSecret,
                              Map<String,String> params, final FoxListener foxListener, final ServingCallback servingCallback) {

        try {

            if(null == params){
                params = new HashMap<>();
            }
            if (FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                mAppKey = FoxBaseCommonUtils.getAppKey();
                mAppSecret = FoxBaseCommonUtils.getAppSecret();
            }

            if (adslot_id == 0 || FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                if (foxListener != null) {
                    foxListener.onFailedToReceiveAd(FoxSDKError.INVALID_PARAM.getCode(), FoxSDKError.INVALID_PARAM.getMessage());
                }
                return;
            }

            String md = FoxBaseCommonUtils.getMD(String.valueOf(adslot_id));
            String nonce = String.valueOf( ((int)((Math.random() * 9 + 1) * 100000)));
            String timestamp = String.valueOf(System.currentTimeMillis());
            String imei = FoxBaseCommonUtils.getIMEI();

            params.put("adslotId",String.valueOf(adslot_id));
            params.put("appKey", mAppKey);
            params.put("md", md);
            params.put("timestamp", timestamp);
            params.put("nonce", nonce );
            params.put("signature", FoxBaseCommonUtils.sha1("appSecret=" + mAppSecret + "&md=" + md + "&nonce=" + nonce + "&timestamp=" + timestamp ));
            params.put("isimageUrl", "1");
            params.put("sourceType", "1");
            params.put("device_id", imei);
            params.put("userId", userId);

            Fox.build().setUrl(AutoConfig.getConfigHostUrl()).addParam(params).post(new ServingCallback(useImage) {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    if(null != servingCallback){
                        servingCallback.onServingDataCorrect(data);
                    }
                }
                @Override
                public void onServingDataError(int code, String message) {
                    if (foxListener != null) {
                        foxListener.onFailedToReceiveAd(code, message);
                    }
                    if(null != servingCallback){
                        servingCallback.onServingDataError(code,message);
                    }
                }

            });

        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            if (foxListener != null) {
                foxListener.onFailedToReceiveAd(FoxSDKError.UNKNOWN.getCode(), FoxSDKError.UNKNOWN.getMessage());
            }
        }

    }
}
