package com.mediamain.android.view.download;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.mediamain.android.R;
import com.mediamain.android.base.data.FoxBaseNewDownloadBean;
import com.mediamain.android.base.download.broadcast.DownloadBroadCast;
import com.mediamain.android.base.util.FoxBaseAppUtil;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseDownloadBar;
import com.mediamain.android.base.util.FoxBaseDownloadUtils;
import com.mediamain.android.base.util.FoxBaseEncryptUtils;
import com.mediamain.android.base.util.FoxBaseFileUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseToastUtils;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.base.FoxSDK;
import com.mediamain.android.view.imageloader.FoxImageView;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.view.util.FoxCommonUtils;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.StatusUtil;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.cause.ResumeFailedCause;
import com.liulishuo.okdownload.core.listener.DownloadListener1;
import com.liulishuo.okdownload.core.listener.assist.Listener1Assist;
import java.io.File;

import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_APK_DOWN_SCENES_3;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_DOWNLOAD_END_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_DOWNLOAD_ERROR_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_DOWNLOAD_START_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INSTALL_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INSTALL_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_OPEN_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_OPEN_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_POP_CLOSE_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_POP_EXPOSED;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_DOWNLOAD_START;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_DOWNLOAD_SUCCESSED;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_INSTALL_START;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_OPEN_SUCCESS;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_EXPOSED;
import static com.mediamain.android.view.FoxBrowserLayout.TYPE;

/**
 * 下载弹窗
 *
 * @author hasee
 */
public class FoxDownloadDialog extends DialogFragment {

    public static final String KEY_DATA = "data";
    private String mUrl;
    private FoxBaseNewDownloadBean mNewDownloadBean;

    private TextView tvAppTitle;
    private FoxImageView ivAppIcon;
    private TextView tvAppName;
    private TextView tvAppDesc;
    private TextView tvAppDownloadBar;
    private FoxBaseDownloadBar foxDownloadBar;
    private RelativeLayout reDownloadClose;

    /**
     * 下载中
     */
    public static final int TYPE_DOWNLOAD_PROGRESS = 1;
    /**
     * 下载完成
     */
    public static final int TYPE_DOWNLOAD_COMPLETE = 2;
    /**
     * 安装
     */
    public static final int TYPE_INSTALL = 3;
    /**
     * 打开
     */
    public static final int TYPE_OPEN = 4;
    /**
     * 下载错误
     */
    public static final int TYPE_DOWNLOAD_ERROR = 5;
    /**
     * 普通下载任务
     */
    public DownloadTask commonTask;
    /**
     * 点击类型处理
     */
    private int mType = 0;

    private DownloadListener1 downloadListener1 = new DownloadListener1() {

        @Override
        public void taskStart(@NonNull DownloadTask task, @NonNull Listener1Assist.Listener1Model model) {
            try {
                if (getDialog() == null || !getDialog().isShowing()) {
                    return;
                }
                postDownload(ANDROID_APK_EVENT_DOWNLOAD_START_EXPOSURE,OPERATETYPE_EXPOSED);
                setUI(TYPE_DOWNLOAD_PROGRESS, "0");
                if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() == 1) {
                    FoxBaseToastUtils.showShort("开始下载");
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @Override
        public void retry(@NonNull DownloadTask task, @NonNull ResumeFailedCause cause) {

        }

        @Override
        public void connected(@NonNull DownloadTask task, int blockCount, long currentOffset, long totalLength) {

        }

        @Override
        public void progress(@NonNull DownloadTask task, long currentOffset, long totalLength) {
            try {
                if (getDialog() == null || !getDialog().isShowing()) {
                    return;
                }
                if (totalLength > 0) {
                    String format = String.format("%.0f", (float) currentOffset * 100 / totalLength);
                    setUI(TYPE_DOWNLOAD_PROGRESS, format);
                    if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() != 0) {
                        FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"1",mNewDownloadBean, (int) (currentOffset * 100 / totalLength),
                                null, R.drawable.fox_notification_download,"正在下载");
                    }
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @Override
        public void taskEnd(@NonNull DownloadTask task, @NonNull EndCause cause, @Nullable Exception realCause, @NonNull Listener1Assist.Listener1Model model) {
            try {
                if (task != null) {
                    task.cancel();
                }
                FoxBaseCommonUtils.cancelNotify(FoxSDK.getContext(), "1");
                if (cause != null) {
                    if (cause.name().contains(EndCause.ERROR.name())) {
                        postDownload(ANDROID_APK_EVENT_DOWNLOAD_ERROR_EXPOSURE,OPERATETYPE_EXPOSED);
                        if (commonTask != null) {
                            commonTask.cancel();
                        }
                        setUI(TYPE_DOWNLOAD_ERROR, "");
                        final File file1 = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME
                                , FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + ".apk");
                        if (file1 != null && file1.exists()) {
                            FoxBaseFileUtils.delete(file1);
                        }
                    } else if (cause.name().contains(EndCause.COMPLETED.name())) {
                        postDownload(ANDROID_APK_EVENT_DOWNLOAD_END_EXPOSURE,OPERATETYPE_EXPOSED);
                        FoxBaseCommonUtils.postDataCheck(KEY_CHECK_DOWNLOAD_SUCCESSED,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                        setUI(TYPE_DOWNLOAD_COMPLETE, "");
                        final File file1 = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME
                                , FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + ".apk");
                        if (file1 != null && file1.exists()) {
                            final boolean rename = FoxBaseFileUtils.rename(file1, FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + "tm.apk");
                            if (rename) {
                                final File file2 = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME
                                        , FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + "tm.apk");
                                if (file2 != null && file2.exists()) {
                                    setUI(TYPE_INSTALL, "");
                                    FoxBaseAppUtil.openFile(FoxBaseUtils.getApp(), file2);
                                    FoxBaseCommonUtils.postDataCheck(KEY_CHECK_INSTALL_START,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                                    if (mNewDownloadBean != null) {
                                        if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() != 0) {
                                            FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"0",mNewDownloadBean, 100,
                                                    file2, R.drawable.fox_notification_install,"仅差一步:安装即可领取奖励");
                                            // "立即安装", "仅差一步:安装即可领取奖励"
                                        }

                                    }
                                }
                            } else {
                                setUI(TYPE_INSTALL, "");
                                FoxBaseAppUtil.openFile(FoxBaseUtils.getApp(), file1);
                                FoxBaseCommonUtils.postDataCheck(KEY_CHECK_INSTALL_START,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                                if (mNewDownloadBean != null) {
                                    if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() != 0) {
                                        FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"0",mNewDownloadBean, 100,
                                                file1, R.drawable.fox_notification_install,"仅差一步:安装即可领取奖励");
                                        // "立即安装", "仅差一步:安装即可领取奖励"
                                    }
                                }
                            }
                        }
                    }
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }
    };

    public static FoxDownloadDialog newInstance(Bundle bundle) {
        FoxDownloadDialog fragment = new FoxDownloadDialog();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(DialogFragment.STYLE_NO_TITLE, R.style.FoxDialogFragmentStyle);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(initRootView(), container, false);
        tvAppTitle = rootView.findViewById(R.id.tvAppTitle);
        reDownloadClose = rootView.findViewById(R.id.reDownloadClose);
        ivAppIcon = rootView.findViewById(R.id.ivAppIcon);
        tvAppName = rootView.findViewById(R.id.tvAppName);
        tvAppDesc = rootView.findViewById(R.id.tvAppDesc);
        tvAppDownloadBar = rootView.findViewById(R.id.tvAppDownloadBar);
        foxDownloadBar = rootView.findViewById(R.id.foxDownloadBar);
        tvAppDownloadBar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    if (mType == TYPE_DOWNLOAD_ERROR) {
                        if (foxDownloadBar != null) {
                            foxDownloadBar.reset();
                        }
                    }
                    if (toOpenApp(true)) {
                        //已经安装
                        setUI(TYPE_OPEN, "");
                        return;
                    } else if (toInstallApp(true)) {
                        //已经下载未安装
                        setUI(TYPE_INSTALL, "");
                        return;
                    } else {
                        //未下载
                        dealDownload(1);
                    }
                } catch (Exception e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }
            }
        });
        reDownloadClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!isHidden()) {
                    postDownload(ANDROID_APK_EVENT_POP_CLOSE_CLICK,OPERATETYPE_CLICK);
                    dismissAllowingStateLoss();
                }
            }
        });
        initView();
        return rootView;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        postDownload(ANDROID_APK_EVENT_POP_EXPOSED,OPERATETYPE_EXPOSED);
    }

    @Override
    public void onResume() {
        try {
//            if (FoxBaseAppUtil.isAppInstall(FoxBaseUtils.getApp(), KEY_CHECK_PACKAGE_NEME)) {
//                FoxBaseCommonUtils.postDataCheck(KEY_CHECK_INSTALL_SUCCESSED,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
//            }
            if (toOpenApp(false)) {
                setUI(TYPE_OPEN, "");
            } else if (toInstallApp(false)) {
                setUI(TYPE_INSTALL, "");
            } else {
//                dealDownload(2);
                if (foxDownloadBar != null) {
                    foxDownloadBar.reset();
                }
            }
            //发送生命周期时间
//            Dialog dialog = getDialog();
//            if (dialog == null) {
//                return;
//            }
//            Window window = dialog.getWindow();
//            if (window == null) {
//                return;
//            }
//            changeSize(dialog, window);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        super.onResume();
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (commonTask != null) {
//            FoxBaseCommonUtils.getListenerManager().detachListener(commonTask, downloadListener1);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if(null != ivAppIcon){
            ivAppIcon.stopCurrentFuture(true);
        }
        if(null != commonTask){
            commonTask.cancel();
        }
    }

    /**
     * 显示弹窗 防止java.lang.IllegalStateException
     * Can not perform this action after onSaveInstanceStat
     *
     * @param fragmentManager
     * @param tag
     */
    public void showAllowingStateLoss(FragmentManager fragmentManager, String tag) {
        try {
            FragmentTransaction ft = fragmentManager.beginTransaction();
            ft.add(this, tag);
            ft.commitAllowingStateLoss();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 改变大小
     *
     * @param dialog
     * @param window
     */
    public void changeSize(Dialog dialog, Window window) {

    }

//-------------------------------------------------Private--------------------------------------------------------------

    /**
     * 下载行为埋点上传
     */
    private void postDownload(String dpm,int operateType) {
        if (mNewDownloadBean == null){
            return;
        }
        FoxBaseMaidianUtil.build(TYPE)
                .set("slot_id", "" + mNewDownloadBean.getSlotId())
                .set("order_id", "" + mNewDownloadBean.getTmId())
                .set("promote_url", "" + mNewDownloadBean.getUrl())
                .set("dsm", "" + dpm)
                .set("apk_down_scenes", "" + ANDROID_APK_EVENT_APK_DOWN_SCENES_3)
                .set("operateType", "" + operateType)
                .postScmLog(null);
    }

    /**
     * 处理app安装
     */
    private boolean toInstallApp(boolean isInstall) {
        try {
            if (FoxSDK.getContext() != null) {
                if (!FoxBaseCommonUtils.isEmpty(mUrl)) {
                    final File file2 = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME
                            , FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + "tm.apk");
                    if (file2 != null && file2.exists()) {
                        if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() != 0) {
                            FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"0",mNewDownloadBean, 100,
                                    file2, R.drawable.fox_notification_install,"仅差一步:安装即可领取奖励");
                            //"立即安装", "仅差一步,安装即可领取奖励"
                        }
                        if (isInstall) {
                            FoxBaseAppUtil.openFile(FoxSDK.getContext(), file2);
                            FoxBaseCommonUtils.postDataCheck(KEY_CHECK_INSTALL_START,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                            postDownload(ANDROID_APK_EVENT_INSTALL_CLICK,OPERATETYPE_CLICK);
                        }else {
                            postDownload(ANDROID_APK_EVENT_INSTALL_EXPOSURE,OPERATETYPE_EXPOSED);
                        }
                        return true;
                    }
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return false;
    }

    private int initRootView() {
        return R.layout.fox_dialog_download;
    }

    private void initView() {
        try {
            Bundle bundle = getArguments();
            mNewDownloadBean = (FoxBaseNewDownloadBean) bundle.getSerializable(KEY_DATA);
            if(null == mNewDownloadBean){
                return;
            }
            //安装应用广播注册
            DownloadBroadCast downloadBroadCast = FoxBaseCommonUtils.registerDownloadBroadCast();
            if(null != downloadBroadCast) {
                downloadBroadCast.setData(mNewDownloadBean.getPackageName(), mNewDownloadBean.getAppIconUri());
            }

            if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getUrl())) {
                mUrl = mNewDownloadBean.getUrl();
                if (toOpenApp(true)) {
                    //已经安装
                    setUI(TYPE_OPEN, "");
                    return;
                } else if (toInstallApp(true)) {
                    //已经下载未安装
                    setUI(TYPE_INSTALL, "");
                    return;
                } else {
                    //未下载
                    dealDownload(3);
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 处理下载行为
     */
    private void dealDownload(int from) {
        try {
            if (mNewDownloadBean == null || FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getUrl())) {
                return;
            }
            FoxBaseCommonUtils.postDataCheck(KEY_CHECK_DOWNLOAD_START,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
            mUrl = mNewDownloadBean.getUrl();
            if (!FoxBaseCommonUtils.isEmpty(mUrl)) {
                if (toInstallApp(true)) {
                    setUI(TYPE_INSTALL, "0%");
                    return;
                }
                commonTask = new DownloadTask.Builder(mUrl,
                        FoxBaseCommonUtils.getDownLoadPath(Constants.CACHE_NAME),
                        FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + ".apk")
                        // the minimal interval millisecond for callback fox_progress
                        .setMinIntervalMillisCallbackProcess(30)
                        // do re-download even if the task has already been completed in the past.
                        .setPassIfAlreadyCompleted(false)
                        .setAutoCallbackToUIThread(true)
                        .setConnectionCount(3)
                        .setMinIntervalMillisCallbackProcess(300)
                        .build();
                commonTask.addTag(1, FoxBaseEncryptUtils.encryptMD5ToString(mUrl));
                FoxBaseDownloadUtils.getListenerManager().addAutoRemoveListenersWhenTaskEnd(commonTask.getId());
                StatusUtil.Status status = StatusUtil.getStatus(commonTask);
                if (status != StatusUtil.Status.RUNNING) {
                    FoxBaseDownloadUtils.getListenerManager().attachListener(commonTask, downloadListener1);
                    FoxBaseDownloadUtils.getListenerManager().enqueueTaskWithUnifiedListener(commonTask, downloadListener1);
                } else {
                    FoxBaseDownloadUtils.getListenerManager().attachListener(commonTask, downloadListener1);
                    FoxBaseToastUtils.showShort("下载中...");
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 处理app打开行为
     *
     * @return
     */
    private boolean toOpenApp(boolean isOpen) {
        try {
            if (FoxSDK.getContext() != null) {
                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getPackageName())
                        && FoxBaseAppUtil.isAppInstall(FoxSDK.getContext(), mNewDownloadBean.getPackageName())) {
                    if (mNewDownloadBean != null
                            && mNewDownloadBean.getStyleControl() != 0
                            && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getPackageName())) {
                        FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"0",mNewDownloadBean, 100,
                                null, R.drawable.fox_notification_open,"应用已安装完毕,快打开领奖吧!");
                        //"打开应用领奖", "应用已安装完毕,快打开领奖吧!"
                    }
                    if (isOpen) {
                        postDownload(ANDROID_APK_EVENT_OPEN_CLICK,OPERATETYPE_CLICK);
                        FoxBaseCommonUtils.postDataCheck(KEY_CHECK_OPEN_SUCCESS,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                        FoxBaseAppUtil.openOtherApp(FoxSDK.getContext(), mNewDownloadBean.getPackageName());
                    }else {
                        postDownload(ANDROID_APK_EVENT_OPEN_EXPOSURE,OPERATETYPE_EXPOSED);
                    }
                    return true;
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 更新弹窗UI
     *
     * @param type
     */
    private void setUI(final int type, final String format) {
        try {
            if (getActivity() == null || getDialog() == null || !getDialog().isShowing()) {
                return;
            }
            getActivity().runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    switch (type) {
                        case TYPE_DOWNLOAD_PROGRESS:
                            mType = TYPE_DOWNLOAD_PROGRESS;
                            //下载中
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getTitle())){
                                        tvAppTitle.setText(mNewDownloadBean.getTitle());
                                    }else {
                                        tvAppTitle.setText("安装并打开即可获得奖励");
                                    }
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励！");
                                }
                            }

                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
                                ivAppIcon.setBackgroundDrawable(null);
                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                } else {
                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                }
                            }
                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getDesc())){
                                        tvAppDesc.setText(mNewDownloadBean.getDesc());
                                    }else {
                                        tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                    }
                                } else {
                                    tvAppDesc.setText("下载中");
                                }
                            }
                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.GONE);
                            }
                            if (foxDownloadBar != null && !FoxCommonUtils.isEmpty(format)) {
                                foxDownloadBar.setVisibility(View.VISIBLE);
                                foxDownloadBar.setProgress(Integer.valueOf(format));
                            }
                            break;
                        case TYPE_DOWNLOAD_COMPLETE:
                            mType = TYPE_DOWNLOAD_COMPLETE;
                            //下载完成
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getTitle())){
                                        tvAppTitle.setText(mNewDownloadBean.getTitle());
                                    }else {
                                        tvAppTitle.setText("安装并打开即可获得奖励");
                                    }
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励!");
                                }
                            }

                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
                                ivAppIcon.setBackgroundDrawable(null);
                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                } else {
                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                }
                            }

                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getDesc())){
                                        tvAppDesc.setText(mNewDownloadBean.getDesc());
                                    } else {
                                        tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                    }
                                } else {
                                    tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                }
                            }

                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.GONE);
                            }
                            if (foxDownloadBar != null && !FoxCommonUtils.isEmpty(format)) {
                                foxDownloadBar.setVisibility(View.VISIBLE);
                                foxDownloadBar.setProgress(100);
                            }
                            break;
                        case TYPE_DOWNLOAD_ERROR:
                            mType = TYPE_DOWNLOAD_ERROR;
                            //下载异常
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getTitle())){
                                        tvAppTitle.setText(mNewDownloadBean.getTitle());
                                    }else {
                                        tvAppTitle.setText("安装并打开即可获得奖励");
                                    }
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励!");
                                }
                            }

                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
                                ivAppIcon.setBackgroundDrawable(null);
                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                } else {
                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                }
                            }

                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getDesc())){
                                        tvAppDesc.setText(mNewDownloadBean.getDesc());
                                    } else {
                                        tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                    }
                                } else {
                                    tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                }
                            }

                            if (foxDownloadBar != null) {
                                foxDownloadBar.setVisibility(View.GONE);
                            }
                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.VISIBLE);
                                tvAppDownloadBar.setText("下载失败请点击重试");
                            }
                            break;
                        case TYPE_INSTALL:
                            mType = TYPE_INSTALL;
                            //安装
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getTitle())){
                                        tvAppTitle.setText(mNewDownloadBean.getTitle());
                                    }else {
                                        tvAppTitle.setText("安装并打开即可获得奖励");
                                    }
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励!");
                                }
                            }
                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
                                ivAppIcon.setBackgroundDrawable(null);
                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                } else {
                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                }
                            }
                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getDesc())){
                                        tvAppDesc.setText(mNewDownloadBean.getDesc());
                                    } else {
                                        tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                    }
                                } else {
                                    tvAppDesc.setText("立即安装");
                                }
                            }

                            if (foxDownloadBar != null) {
                                foxDownloadBar.setVisibility(View.GONE);
                            }
                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.VISIBLE);
                                tvAppDownloadBar.setText("立即安装");
                            }
                            break;
                        case TYPE_OPEN:
                            mType = TYPE_OPEN;
                            //打开
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getTitle())){
                                        tvAppTitle.setText(mNewDownloadBean.getTitle());
                                    }else {
                                        tvAppTitle.setText("就差一步：打开即可领奖");
                                    }
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励！");
                                }
                            }

                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
                                ivAppIcon.setBackgroundDrawable(null);
                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                } else {
                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
                                }
                            }
                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }
                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    if (!FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getDesc())){
                                        tvAppDesc.setText(mNewDownloadBean.getDesc());
                                    } else {
                                        tvAppDesc.setText("点击下方按钮,前往领取奖励");
                                    }
                                } else {
                                    tvAppDesc.setText("打开应用领奖");
                                }
                            }

                            if (foxDownloadBar != null) {
                                foxDownloadBar.setVisibility(View.GONE);
                            }

                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.VISIBLE);
                                tvAppDownloadBar.setText("打开领取奖励");
                            }
                            break;
                        default:
                            break;
                    }
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }
}
