package com.mediamain.android.view.download;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.FileProvider;
import android.webkit.WebView;

import com.mediamain.android.base.config.FoxBaseUrl;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.util.FoxBaseAppUtil;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseEncryptUtils;
import com.mediamain.android.base.util.FoxBaseFileUtils;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.base.FoxSDK;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.view.bean.FoxPackageBaen;
import com.mediamain.android.view.util.FoxGsonUtil;
import com.liulishuo.okdownload.DownloadListener;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.StatusUtil;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.cause.ResumeFailedCause;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * 下载器3.0（领券环节下载）
 * Created by ZSY on 2020-04-01.
 */
public class PopLayerDownloadManage {

    private static volatile PopLayerDownloadManage mInstance;
    private static Context mContext;
    private static String mSlotId;
    private static WebView mWebview;
    private static String mDownloadUrl;
    /**
     * 下载中
     */
    public static final int STATUS_DOWNLOADING = 1;
    /**
     * 下载完成
     */
    public static final int STATUS_DOWNLOAD_COMPLETE = 2;
    /**
     * 安装完成
     */
    public static final int STATUS_INSTALL_COMPLETE = 3;
    /**
     * 取消安装
     */
    public static final int STATUS_INSTALL_CANCLE = 4;
    /**
     * 下载异常
     */
    public static final int STATUS_DOWNLOAD_ERROR = 5;

    /**
     * 下载
     */
    public static final int SUB_TYPE_DOWNLOAD = 0;
    /**
     * 安装
     */
    public static final int SUB_TYPE_INSTALL = 1;
    /**
     * type
     */
    public static final int TYPE = 157;

    private String mOrderId;
    private FoxPackageBaen mFoxPackageBaen;
    private DownloadTask mDownloadTask;
    private ScheduledExecutorService checkInstalled;

    private PopLayerDownloadManage() {
    }

    public static PopLayerDownloadManage getInstance(Context context, WebView webview, String slotId) {
        if (mInstance == null) {
            synchronized (PopLayerDownloadManage.class) {
                if (mInstance == null) {
                    mInstance = new PopLayerDownloadManage();
                }
            }
        }
        init(context, webview, slotId);

        return mInstance;
    }

    ;

    private static void init(Context context, WebView webview, String slotId) {
        mContext = context;
        mWebview = webview;
        mSlotId = slotId;
    }

    /**
     * 获取APP信息
     *
     * @param orderId
     */
    public void getAppInfo(String orderId) {
        mOrderId = orderId;
        OkGo.<String>get(FoxBaseUrl.BASE_SDK_URL_GG_INFO + orderId)
                .execute(new StringCallback() {
                    @Override
                    public void onSuccess(Response<String> response) {
                        try {
                            if (response != null && !FoxBaseCommonUtils.isEmpty(response.body())) {
                                FoxPackageBaen foxPackageBaen = FoxGsonUtil.GsonToBean(response.body(), FoxPackageBaen.class);
                                if (foxPackageBaen != null) {
                                    mFoxPackageBaen = foxPackageBaen;
                                } else {
                                    mFoxPackageBaen = null;
                                }
                            } else {
                                mFoxPackageBaen = null;
                            }
                        } catch (Exception e) {
                            FoxBaseCrashUtils.reportErrorData(e);
                            mFoxPackageBaen = null;
                        }
                    }

                    @Override
                    public void onError(Response<String> response) {
                        super.onError(response);
                        mFoxPackageBaen = null;
                    }
                });
    }

    public void dealCommonDownload(final String url) {
        try {
            if (!FoxBaseCommonUtils.isEmpty(url)) {

                mDownloadUrl = url;

                int state = toInstallApp(url);
                if (state != -1) {
                    downloadCompleted(state);
                    return;
                }

                mDownloadTask = new DownloadTask.Builder(url,
                        FoxBaseCommonUtils.getDownLoadPath(Constants.CACHE_NAME),
                        FoxBaseEncryptUtils.encryptMD5ToString(url) + ".apk")
                        // the minimal interval millisecond for callback fox_progress
                        .setMinIntervalMillisCallbackProcess(30)
                        // do re-download even if the task has already been completed in the past.
                        .setPassIfAlreadyCompleted(false)
                        .setAutoCallbackToUIThread(true)
                        .setConnectionCount(3)
                        .setMinIntervalMillisCallbackProcess(300)
                        .build();
                mDownloadTask.addTag(1, FoxBaseEncryptUtils.encryptMD5ToString(url));
                StatusUtil.Status status = StatusUtil.getStatus(mDownloadTask);
                if (status != StatusUtil.Status.RUNNING) {
                    final long[] increaseBytes = {0};
                    mDownloadTask.enqueue(new DownloadListener() {

                        @Override
                        public void taskStart(@NonNull DownloadTask task) {
                            callDownload(url, 0, 0, STATUS_DOWNLOADING, 0);
                        }

                        @Override
                        public void connectTrialStart(@NonNull DownloadTask task, @NonNull Map<String, List<String>> requestHeaderFields) {

                        }

                        @Override
                        public void connectTrialEnd(@NonNull DownloadTask task, int responseCode, @NonNull Map<String, List<String>> responseHeaderFields) {

                        }

                        @Override
                        public void downloadFromBeginning(@NonNull DownloadTask task, @NonNull BreakpointInfo info, @NonNull ResumeFailedCause cause) {

                        }

                        @Override
                        public void downloadFromBreakpoint(@NonNull DownloadTask task, @NonNull BreakpointInfo info) {

                        }

                        @Override
                        public void connectStart(@NonNull DownloadTask task, int blockIndex, @NonNull Map<String, List<String>> requestHeaderFields) {

                        }

                        @Override
                        public void connectEnd(@NonNull DownloadTask task, int blockIndex, int responseCode, @NonNull Map<String, List<String>> responseHeaderFields) {

                        }

                        @Override
                        public void fetchStart(@NonNull DownloadTask task, int blockIndex, long contentLength) {

                        }

                        @Override
                        public void fetchProgress(@NonNull DownloadTask task, int blockIndex, long mincreaseBytes) {
                            try {
                                final BreakpointInfo info = StatusUtil.getCurrentInfo(task);
                                increaseBytes[0] += mincreaseBytes;
                                callDownload(url, increaseBytes[0], (info != null && info.getTotalLength() > 0) ? info.getTotalLength() : 0, STATUS_DOWNLOADING, 0);
                            } catch (Exception ignored) {
                                FoxBaseCrashUtils.reportErrorData(ignored);
                            }

                        }

                        @Override
                        public void fetchEnd(@NonNull DownloadTask task, int blockIndex, long contentLength) {

                        }

                        @Override
                        public void taskEnd(@NonNull DownloadTask task, @NonNull EndCause cause, @Nullable Exception realCause) {
                            try {
                                increaseBytes[0] = 0;
                                if (task != null) {
                                    task.cancel();
                                }
//                                FoxCommonUtils.cancelNotify(mContext, "1");
                                if (cause != null) {
                                    if (cause.name().contains(EndCause.ERROR.name())) {
                                        callDownload(url, 0, 0, STATUS_DOWNLOAD_ERROR, 0);
                                    } else if (cause.name().contains(EndCause.COMPLETED.name())) {
                                        callDownload(url, 100, 100, STATUS_DOWNLOAD_COMPLETE, 1);
                                        final File file1 = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME
                                                , FoxBaseEncryptUtils.encryptMD5ToString(url) + ".apk");
                                        if (file1 != null && file1.exists()) {
                                            final boolean rename = FoxBaseFileUtils.rename(file1, FoxBaseEncryptUtils.encryptMD5ToString(url) + "tm.apk");
                                            if (rename) {
                                                final File file2 = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME
                                                        , FoxBaseEncryptUtils.encryptMD5ToString(url) + "tm.apk");
                                                if (file2 != null && file2.exists()) {
                                                    openFile(FoxBaseUtils.getApp(), file2);
                                                }
                                            } else {
                                                openFile(FoxBaseUtils.getApp(), file1);
                                            }
                                        }
                                    }
                                }
                            } catch (Exception ignored) {
                                FoxBaseCrashUtils.reportErrorData(ignored);
                            }
                        }
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDownloadUrl() {
        return mDownloadUrl;
    }

    public static void destroy() {
        mContext = null;
        mWebview = null;
    }


//---------------------------------------------------------------------Private----------------------------------------------------------------------------------------

    /**
     * 打开APP
     */
    private boolean toOpenApp() {
        if (mFoxPackageBaen == null || FoxBaseCommonUtils.isEmpty(mFoxPackageBaen.getPackageName())) {
            final File file2 = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME
                    , FoxBaseEncryptUtils.encryptMD5ToString(mDownloadUrl) + "tm.apk");
            if (file2 != null && file2.exists()) {
                mFoxPackageBaen = GetApkInfo(mContext, file2.getAbsolutePath());
            }
        }

        if (mFoxPackageBaen != null && !FoxBaseCommonUtils.isEmpty(mFoxPackageBaen.getPackageName())
                && FoxBaseAppUtil.isAppInstall(FoxSDK.getContext(), mFoxPackageBaen.getPackageName())) {
            FoxBaseAppUtil.openOtherApp(FoxSDK.getContext(), mFoxPackageBaen.getPackageName());
            return true;
        }
        return false;
    }

    /**
     * 处理app安装
     *
     * @param url
     */
    private int toInstallApp(String url) {
        try {
            if (toOpenApp()) {
                return STATUS_INSTALL_COMPLETE;
            }
            if (mContext != null) {
                if (!FoxBaseCommonUtils.isEmpty(url)) {
                    final File file2 = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME
                            , FoxBaseEncryptUtils.encryptMD5ToString(url) + "tm.apk");
                    if (file2 != null && file2.exists()) {
                        openFile(mContext, file2);
                        return STATUS_DOWNLOAD_COMPLETE;
                    }
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
        }
        return -1;
    }

    /**
     * 下载回调处理
     *
     * @param url          下载地址
     * @param currentSizer 已下载大小
     * @param totalSize    文件总大小
     * @param state        状态
     * @param isFinish     0-未完成 1-已完成
     */
    private void callDownload(String url, long currentSizer, long totalSize, final int state,
                              int isFinish) {
        int progress = 0;
        try {
            if (state == STATUS_DOWNLOADING) {
                if (currentSizer == 0 && totalSize == 0) {
                    if (mContext instanceof Activity && mWebview != null) {
                        ((Activity) mContext).runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                mWebview.loadUrl("javascript:TAHandler.downloadProgress('0');");
                            }
                        });
                    }
                }
                if (currentSizer > 0 && totalSize > 0 && currentSizer <= totalSize) {
                    progress = (int) (currentSizer * 100 / totalSize);
                    if (mContext instanceof Activity && mWebview != null) {
                        final int finalProgress = progress;
                        ((Activity) mContext).runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                mWebview.loadUrl(String.format("javascript:TAHandler.downloadProgress('%d');", finalProgress));
                            }
                        });
                    }
                }
            } else {
                if (mContext instanceof Activity && mWebview != null) {
                    ((Activity) mContext).runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            mWebview.loadUrl(String.format("javascript:TAHandler.downloadCompleted('%d');", state));
                        }
                    });
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 在手机上打开文件
     */
    private void openFile(Context mContext, File f) {

        Runnable task = new Runnable() {
            @Override
            public void run() {
                checkTask();
            }
        };
        try {
            if (mContext != null) {
                Intent intent = new Intent();
                intent.setAction(Intent.ACTION_VIEW);
                if (Build.VERSION.SDK_INT < 24) {
                    /* 调用getMIMEType()来取得MimeType */
                    String type = "application/vnd.android.package-archive";
                    /* 设置intent的file与MimeType */
                    intent.putExtra(Intent.EXTRA_NOT_UNKNOWN_SOURCE, true);
                    intent.putExtra(Intent.EXTRA_RETURN_RESULT, true);
                    intent.setDataAndType(Uri.fromFile(f), type);
                } else {
                    Uri uri = FileProvider.getUriForFile(mContext, mContext.getPackageName() + ".foxbasefileprovider", f);
                    intent.setDataAndType(uri, "application/vnd.android.package-archive");
                    intent.putExtra(Intent.EXTRA_NOT_UNKNOWN_SOURCE, true);
                    intent.putExtra(Intent.EXTRA_RETURN_RESULT, true);
                    intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                }
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                mContext.startActivity(intent);

                checkInstalled = Executors.newSingleThreadScheduledExecutor();
                checkInstalled.scheduleAtFixedRate(task, 2000, 500, TimeUnit.MILLISECONDS);
            }
        } catch (Exception ignored) {
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    /**
     * 监测用户是否安装了应用
     */
    private void checkTask() {
        if (!FoxBaseCommonUtils.isBackground(FoxSDK.getContext())) {
            checkInstalled.shutdownNow();
            checkInstalled = null;
            if (mFoxPackageBaen != null) {
                boolean isInstall = FoxBaseAppUtil.isAppInstall(FoxSDK.getContext(), mFoxPackageBaen.getPackageName());
                if (isInstall) {
                    downloadCompleted(STATUS_INSTALL_COMPLETE);
                } else {
                    downloadCompleted(STATUS_INSTALL_CANCLE);
                }
            }
        }
    }

    /**
     * 更新状态
     *
     * @param statusCode
     */
    @SuppressLint("DefaultLocale")
    private void downloadCompleted(final int statusCode) {
        if (mContext instanceof Activity && mWebview != null) {
            ((Activity) mContext).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mWebview.loadUrl(String.format("javascript:TAHandler.downloadCompleted('%d');", statusCode));
                }
            });
        }
    }

    private FoxPackageBaen GetApkInfo(Context context, String apkPath) {
        FoxPackageBaen foxPackageBaen = null;
        PackageManager pm = context.getPackageManager();
        PackageInfo info = pm.getPackageArchiveInfo(apkPath, PackageManager.GET_ACTIVITIES);
        if (info != null) {
            foxPackageBaen = new FoxPackageBaen();
            ApplicationInfo appInfo = info.applicationInfo;
            foxPackageBaen.setPackageName(appInfo.packageName);
        }
        return foxPackageBaen;
    }

}
