package com.mediamain.android.view.feed;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;

import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.FoxActivity;
import com.mediamain.android.view.base.FoxSDK;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.holder.FoxTempletInfoFeedHolder;
import com.mediamain.android.view.interfaces.IFoxTempletInfoFeedAd;
import com.mediamain.android.view.interfaces.IFoxTempletInfoFeedAdView;
import com.mediamain.android.view.util.FoxCommonUtils;
import com.mediamain.android.view.util.FoxListenerManager;
import com.mediamain.android.view.util.FoxListenerObserver;
import com.mediamain.android.view.util.FoxStringUtil;

import java.lang.ref.WeakReference;
import java.util.UUID;

import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_APK_DOWN_SCENES_1;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INFO_STREAM_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INFO_STREAM_EXPOSED;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_EXPOSED;

/**
 * Created by ZSY on 2020-04-29.
 */
public class FoxTempletInfoFeedAd implements IFoxTempletInfoFeedAd, View.OnClickListener, FoxListenerObserver {

    private static final String TAG = "FoxTempletInfoFeedAd";
    //1=左文右图、2=上文下图、3=右文左图、4=三图
    private static final int ITEM_VIEW_TYPE_RIGHT_IMG = 1;
    private static final int ITEM_VIEW_TYPE_BOTTOM_IMG = 2;
    private static final int ITEM_VIEW_TYPE_LEFT_IMG = 3;
    private static final int ITEM_VIEW_TYPE_THREE_IMG = 4;

    //View
    private IFoxTempletInfoFeedAdView mView;

    //Data
    private int mSpecType;
    private String mkey;

    //Core
    private Context mContext;
    private FoxTempletInfoFeedHolder.LoadInfoAdListener mFoxListener;
    private FoxResponseBean.DataBean mData;
    private int mAdslotId;
    private boolean is_clicked = false;
    private WeakReference<FoxActivity> activityWeakReference;

    public FoxTempletInfoFeedAd(Context context) {
        mContext = context;
        mkey = UUID.randomUUID().toString();
        FoxListenerManager.getInstance().registrationObserver(mkey, this);
    }

    public void setData(FoxResponseBean.DataBean data) {
        mData = data;
        is_clicked = false;

        initData();
    }

    /**
     * 信息回传
     */
    public void sendMessage(int type, String data) {
        try {
            if (activityWeakReference != null) {
                ((FoxActivity) (activityWeakReference.get())).sendMessage(type, data);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public void setListener(FoxTempletInfoFeedHolder.LoadInfoAdListener listener) {
        mFoxListener = listener;
    }

    @Override
    public void setScaleType(ImageView.ScaleType type) {
        if (null != mView) {
            mView.setScaleType(type);
        }
    }

    @Override
    public void setImageSize(float width, float height) {
        if (null != mView) {
            mView.setImageSize(width, height);
        }
    }

    @Override
    public void setTextSize(float size) {
        if (null != mView) {
            mView.setTextSize(size);
        }
    }

    @Override
    public void setTextColor(int resId) {
        if (null != mView) {
            mView.setTextColor(resId);
        }
    }

    @Override
    public void setImageMargin(int left, int top, int right, int bottom) {
        if (null != mView) {
            mView.setImageMargin(left, top, right, bottom);
        }
    }

    @NonNull
    @Override
    public View getView() {
        return mView.getView();
    }

    public void setIs_clicked(boolean is_clicked) {
        this.is_clicked = is_clicked;
    }

    public void setAdslotId(int slotId){
        mAdslotId = slotId;
    }

    @Override
    public void destroy() {
        try {
            FoxBaseLogUtils.d(TAG + "——>destroy()");
            mContext = null;
            mView.destroy();
            FoxListenerManager.getInstance().unregistrationObserver(mkey, this);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public int getSpecType() {
        if (null != mView) {
            return mView.getSpecType();
        }
        return -1;
    }

    @Override
    public void onClick(View v) {
        try {

            if (null == mData) {
                return;
            }
            if (mFoxListener != null) {
                mFoxListener.onAdClick();
            }
            if (!FoxBaseCommonUtils.isEmpty(mkey)) {
                FoxBaseSPUtils.getInstance().setString(mkey, mAdslotId + "");
            }
            FoxBaseLogUtils.d(TAG + "——>onAdClick" + mData.getActivityUrl());
            if (!FoxBaseCommonUtils.isEmpty(mData.getActivityUrl())) {
                if (mData.getDownloadAd() && mContext instanceof Activity && !((Activity) mContext).isFinishing()) {
                    if (mData.getActivityUrl().contains(".apk")) {
                        FoxCommonUtils.dealCommonDowdload((Activity) mContext, mData.getActivityUrl(), ANDROID_APK_EVENT_APK_DOWN_SCENES_1, "", mData);
                    } else {
                        FoxActivity.starActivity(FoxSDK.getContext(), mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), FoxSDKType.FOX_TEMPLET_INFO_FEED.getCode());
                    }
                } else {
                    FoxActivity.starActivity(FoxSDK.getContext(), mkey, FoxStringUtil.appandUrl(mData.getActivityUrl()), FoxSDKType.FOX_TEMPLET_INFO_FEED.getCode());
                }
            }
            if (!is_clicked) {
                doResponse(1);
                is_clicked = true;
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void update(String event, Object msg) {
        try {
            if (!FoxBaseCommonUtils.isEmpty(event)) {
                if (event.contains(Constants.KEY_AD_CLOSE)) {
                    if (mFoxListener != null && msg instanceof String) {
                        mFoxListener.onAdActivityClose((String) msg);
                    }
                    return;
                }
                if (event.contains(Constants.KEY_AD_MESSAGE)) {
                    if (mFoxListener != null && msg instanceof MessageData) {
                        mFoxListener.onAdMessage((MessageData) msg);
                    }
                    return;
                }
                if (event.contains(Constants.KEY_ACTIVITY_EXAMPLE)) {
                    activityWeakReference = new WeakReference<>((FoxActivity) msg);
                    return;
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    //--------------------------------------------------Private----------------------------------------------------------------
    private void initData() {

        if (null != mData) {
            mSpecType = mData.getSpecType();
            dealViewUi();
        }
    }

    private void dealViewUi() {
        if (mSpecType == ITEM_VIEW_TYPE_RIGHT_IMG) {
            mView = new FoxTempletInfoFeedRightImageView(mContext);
        } else if (mSpecType == ITEM_VIEW_TYPE_BOTTOM_IMG) {
            mView = new FoxTempletInfoFeedBottomImageView(mContext);
        } else if (mSpecType == ITEM_VIEW_TYPE_LEFT_IMG) {
            mView = new FoxTempletInfoFeedLeftImageView(mContext);
        } else if (mSpecType == ITEM_VIEW_TYPE_THREE_IMG) {
            mView = new FoxTempletInfoFeedGroupImageView(mContext);
        }
        if (null != mView) {
            mView.setData(mData);
            mView.setListener(mFoxListener);
            mView.getView().setOnClickListener(this);
        }
        doResponse(0);
    }

    /**
     * 上报接口
     *
     * @param logType 0 曝光
     *                1 点击
     */
    private void doResponse(int logType) {
        try {
            if (mData == null) {
                return;
            }
            String mUrl = null;
            if (logType == 0) {
                postDownload(ANDROID_APK_EVENT_INFO_STREAM_EXPOSED, OPERATETYPE_EXPOSED);
                mUrl = mData.getReportExposureUrl();
            } else if (logType == 1) {
                postDownload(ANDROID_APK_EVENT_INFO_STREAM_CLICK, OPERATETYPE_CLICK);
                mUrl = mData.getReportClickUrl();
            }
            if (FoxBaseCommonUtils.isEmpty(mUrl)) {
                return;
            }
            FoxBaseLogUtils.d(TAG + "——>doResponse——>logType:" + logType + "——>url:" + mUrl);
            OkGo.<String>post(mUrl)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(Response<String> response) {

                        }

                        @Override
                        public void onError(Response<String> response) {
                            super.onError(response);
                        }
                    });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    private static final int TYPE = 157;

    /**
     * 增加下载类行为埋点
     *
     * @param dpm
     */
    private void postDownload(String dpm, int operateType) {
        if (mData == null
                || !mData.getDownloadAd()
                || !mData.getActivityUrl().endsWith(".apk")) {
            return;
        }
        FoxBaseMaidianUtil.build(TYPE)
                .set("dpm", "" + dpm)
                .set("apk_down_scenes", "" + ANDROID_APK_EVENT_APK_DOWN_SCENES_1)
                .set("promote_url", "" + mData.getActivityUrl())
                .set("operateType", "" + operateType)
                .postScmLog(mData.getSdkDsmLogRsp());
    }

}
