package com.mediamain.android.view.feed;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.DragEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.mediamain.android.R;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseDensityUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.holder.FoxTempletInfoFeedHolder;
import com.mediamain.android.view.interfaces.FoxImageLoaderCalback;
import com.mediamain.android.view.imageloader.FoxImageView;
import com.mediamain.android.view.interfaces.IFoxTempletInfoFeedAdView;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.util.FoxStringUtil;

import java.util.List;

import static com.mediamain.android.base.config.FoxBaseConstants.ERROR_CODE_1006;

/**
 * Created by ZSY on 2020-05-06.
 */
public class FoxTempletInfoFeedGroupImageView extends LinearLayout implements IFoxTempletInfoFeedAdView, FoxImageLoaderCalback {

    private View mView;
    private FoxImageView mImageView01;
    private FoxImageView mImageView02;
    private FoxImageView mImageView03;


    private ImageView adClose;
    private ImageView adIcon;
    private TextView mTitle;
    private LinearLayout mImageContainer;

    private FoxTempletInfoFeedHolder.LoadInfoAdListener mLinstener;
    private FoxResponseBean.DataBean mData;

    public FoxTempletInfoFeedGroupImageView(Context context) {
        super(context);
        initView(context);
    }

    public FoxTempletInfoFeedGroupImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView(context);
    }

    public FoxTempletInfoFeedGroupImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context);
    }

    private void testListener(View view) {
        view.setOnDragListener(new OnDragListener() {
            @Override
            public boolean onDrag(View v, DragEvent event) {
                Log.e("RightImageView","setOnDragListener==="+event.getAction());
                return false;
            }
        });

        view.setOnFocusChangeListener(new OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                Log.e("RightImageView","setOnFocusChangeListener==="+hasFocus);
            }
        });

        view.setOnHoverListener(new OnHoverListener() {
            @Override
            public boolean onHover(View v, MotionEvent event) {
                Log.e("RightImageView","setOnHoverListener==="+event.getAction());
                return false;
            }
        });

        view.setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                Log.e("RightImageView","setOnTouchListener==="+event.getAction());
                return false;
            }
        });

        view.setOnSystemUiVisibilityChangeListener(new OnSystemUiVisibilityChangeListener() {
            @Override
            public void onSystemUiVisibilityChange(int visibility) {
                Log.e("RightImageView","setOnSystemUiVisibilityChangeListener==="+visibility);
            }
        });

    }

    @SuppressLint("CutPasteId")
    private void initView(Context context) {
        mView = View.inflate(context, R.layout.fox_list_feed_group_img, this);
        setOrientation(LinearLayout.VERTICAL);

        mImageView01 = mView.findViewById(R.id.iv_image_view_01);
        mImageView02 = mView.findViewById(R.id.iv_image_view_02);
        mImageView03 = mView.findViewById(R.id.iv_image_view_03);


        mTitle = mView.findViewById(R.id.tv_info_feed_title);
        mImageContainer = mView.findViewById(R.id.fl_info_feed_container);
        adClose = mView.findViewById(R.id.adClose);
        adIcon = mView.findViewById(R.id.adIcon);

        adClose.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mView.setVisibility(View.GONE);
                if (null != mLinstener) {
                    mLinstener.onCloseClick();
                }
            }
        });

        testListener(mView);
    }

    @Override
    public void setScaleType(ImageView.ScaleType type) {
        if (null != mImageView01) {
            mImageView01.setScaleType(type);
        }
        if (null != mImageView02) {
            mImageView02.setScaleType(type);
        }
        if (null != mImageView03) {
            mImageView03.setScaleType(type);
        }
    }

    @Override
    public void setImageSize(float width, float height) {
        try {
            if (null != mImageContainer) {
                int widthPx = width>0 ? FoxBaseDensityUtils.dp2px(getContext(), width): (int) width;
                int heightPx = height>0 ? FoxBaseDensityUtils.dp2px(getContext(), height): (int) height;
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) mImageContainer.getLayoutParams();
                layoutParams.width = widthPx;
                layoutParams.height = heightPx;
            }
        } catch (Exception ignore) {}
    }

    @Override
    public void setTextSize(float size) {
        if (null != mTitle && size > 0) {
            mTitle.setTextSize(size);
        }
    }

    @Override
    public void setTextColor(int resId) {
        try {
            mTitle.setTextColor(getResources().getColor(resId));
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void setImageMargin(int left, int top, int right, int bottom){
        if(null == mImageContainer){
            return;
        }
        LinearLayout.LayoutParams lp = null;
        try {
            lp = (LinearLayout.LayoutParams) mImageContainer.getLayoutParams();
            int leftMargin = left>0 ? FoxBaseDensityUtils.dp2px(getContext(), left): left;
            int topMargin = top>0 ? FoxBaseDensityUtils.dp2px(getContext(), top): top;
            int rightMargin = right>0 ? FoxBaseDensityUtils.dp2px(getContext(), right): right;
            int bottomMargin = bottom>0 ? FoxBaseDensityUtils.dp2px(getContext(), bottom): bottom;
            lp.setMargins(leftMargin,topMargin,rightMargin,bottomMargin);
            mImageContainer.setLayoutParams(lp);
        } catch (Exception ignored) {
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    @Override
    public void setData(Object data) {
        if (data instanceof FoxResponseBean.DataBean) {
            mData = (FoxResponseBean.DataBean) data;
            dealViewUi();
        }
    }

    @Override
    public void setListener(FoxTempletInfoFeedHolder.LoadInfoAdListener listener) {
        mLinstener = listener;
    }

    @NonNull
    @Override
    public View getView() {
        return this;
    }

    @Override
    public void destroy() {
        try {
            if (mImageView01 != null) {
                mImageView01.stopCurrentFuture(true);
                mImageView01 = null;
            }
            if (mImageView02 != null) {
                mImageView02.stopCurrentFuture(true);
                mImageView02 = null;
            }
            if (mImageView03 != null) {
                mImageView03.stopCurrentFuture(true);
                mImageView03 = null;
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }

    @Override
    public int getSpecType() {
        if (null != mData) {
            return mData.getSpecType();
        }
        return -1;
    }

//--------------------------------------------------Private----------------------------------------------------------------

    @Override
    public void finish() {
        if (mLinstener != null) {
            mLinstener.onAdExposure();
        }
    }

    @Override
    public void failed() {
        if (mLinstener != null) {
            mLinstener.onLoadFailed();
            mLinstener.onError(ERROR_CODE_1006);
        }
    }

    private void dealViewUi() {
        try {

            List<String> images = mData.getImageUrlList();
            if (!FoxBaseCommonUtils.isEmpty(images)) {
                for(int i=0;i<images.size();i++){
                    String imgUrl = images.get(i);
                    if (!FoxBaseCommonUtils.isEmpty(imgUrl)) {
                        switch (i){
                            case 0:
                                if (mImageView01 != null) {
                                    mImageView01.setVisibility(VISIBLE);
                                    mImageView01.setBackgroundDrawable(null);
                                    mImageView01.setImageUrl(FoxStringUtil.appandUrl(imgUrl), R.drawable.default_image_background);
                                    mImageView01.setLoadCallback(this);
                                }
                                break;
                            case 1:
                                if (mImageView02 != null) {
                                    mImageView02.setVisibility(VISIBLE);
                                    mImageView02.setBackgroundDrawable(null);
                                    mImageView02.setImageUrl(FoxStringUtil.appandUrl(imgUrl), R.drawable.default_image_background);
                                    mImageView02.setLoadCallback(this);
                                }
                                break;
                            case 2:
                                if (mImageView03 != null) {
                                    mImageView03.setVisibility(VISIBLE);
                                    mImageView03.setBackgroundDrawable(null);
                                    mImageView03.setImageUrl(FoxStringUtil.appandUrl(imgUrl), R.drawable.default_image_background);
                                    mImageView03.setLoadCallback(this);
                                }
                                break;
                        }

                    }

                }

            }

            if (!FoxBaseCommonUtils.isEmpty(mData.getExtTitle())) {
                mTitle.setText(mData.getExtTitle());
            }

            if (adIcon != null) {
                adIcon.setVisibility(mData.isVisibleOfCloseButton() ? View.VISIBLE : View.GONE);
            }
            if (adClose != null) {
                adClose.setVisibility(mData.isVisibleOfIcon() ? View.VISIBLE : View.GONE);
            }

        } catch (Exception ex) {
            FoxBaseCrashUtils.reportErrorData(ex);
            if (mLinstener != null) {
                mLinstener.onLoadFailed();
                mLinstener.onError(ERROR_CODE_1006);
            }
        }

    }

}
