package com.mediamain.android.view.feed;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.mediamain.android.R;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseDensityUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.holder.FoxTempletInfoFeedHolder;
import com.mediamain.android.view.interfaces.FoxImageLoaderCalback;
import com.mediamain.android.view.imageloader.FoxImageView;
import com.mediamain.android.view.interfaces.IFoxTempletInfoFeedAdView;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.util.FoxStringUtil;

import static com.mediamain.android.base.config.FoxBaseConstants.ERROR_CODE_1006;

/**
 * Created by ZSY on 2020-05-06.
 */
public class FoxTempletInfoFeedRightImageView extends RelativeLayout implements IFoxTempletInfoFeedAdView {

    private View mView;
    private ImageView adClose;
    private ImageView adIcon;
    private TextView mTitle;
    private FoxImageView mImageView;

    private FoxTempletInfoFeedHolder.LoadInfoAdListener mLinstener;
    private FoxResponseBean.DataBean mData;

    public FoxTempletInfoFeedRightImageView(Context context) {
        super(context);
        initView(context);
    }

    public FoxTempletInfoFeedRightImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView(context);
    }

    public FoxTempletInfoFeedRightImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context);
    }

    private void initView(Context context) {
        mView = View.inflate(context, R.layout.fox_list_feed_right_img, this);
        mImageView = mView.findViewById(R.id.iv_image_view);
        mTitle = mView.findViewById(R.id.tv_info_feed_title);
        adClose = mView.findViewById(R.id.adClose);
        adIcon = mView.findViewById(R.id.adIcon);

        adClose.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mView.setVisibility(View.GONE);
                if (null != mLinstener) {
                    mLinstener.onCloseClick();
                }
            }
        });

    }

    @Override
    public void setScaleType(ImageView.ScaleType type) {
        if (null != mImageView) {
            mImageView.setScaleType(type);
        }
    }

    @Override
    public void setImageSize(float width, float height) {
        try {
            if (null != mImageView) {
                int widthPx = width>0 ? FoxBaseDensityUtils.dp2px(getContext(), width): (int) width;
                int heightPx = height>0 ? FoxBaseDensityUtils.dp2px(getContext(), height): (int) height;
                LayoutParams layoutParams = (RelativeLayout.LayoutParams) mImageView.getLayoutParams();
                layoutParams.width = widthPx;
                layoutParams.height = heightPx;
            }
        } catch (Exception ignore) {}
    }

    @Override
    public void setTextSize(float size) {
        if (null != mTitle && size > 0) {
            mTitle.setTextSize(size);
        }
    }

    @Override
    public void setTextColor(int resId) {
        try {
            mTitle.setTextColor(getResources().getColor(resId));
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void setImageMargin(int left, int top, int right, int bottom){
        if(null == mImageView){
            return;
        }
        RelativeLayout.LayoutParams lp = null;
        try {
            lp = (RelativeLayout.LayoutParams) mImageView.getLayoutParams();
            int leftMargin = left>0 ? FoxBaseDensityUtils.dp2px(getContext(), left): left;
            int topMargin = top>0 ? FoxBaseDensityUtils.dp2px(getContext(), top): top;
            int rightMargin = right>0 ? FoxBaseDensityUtils.dp2px(getContext(), right): right;
            int bottomMargin = bottom>0 ? FoxBaseDensityUtils.dp2px(getContext(), bottom): bottom;
            lp.setMargins(leftMargin,topMargin,rightMargin,bottomMargin);
            mImageView.setLayoutParams(lp);
        } catch (Exception ignored) {
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    @Override
    public void setData(Object data) {
        if (data instanceof FoxResponseBean.DataBean) {
            mData = (FoxResponseBean.DataBean) data;
            dealViewUi();
        }
    }

    @Override
    public void setListener(FoxTempletInfoFeedHolder.LoadInfoAdListener listener) {
        mLinstener = listener;
    }

    @NonNull
    @Override
    public View getView() {
        return this;
    }

    @Override
    public void destroy() {
        try {
            if (mImageView != null) {
                mImageView.stopCurrentFuture(true);
                mImageView = null;
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }

    @Override
    public int getSpecType() {
        if (null != mData) {
            return mData.getSpecType();
        }
        return -1;
    }

//--------------------------------------------------Private----------------------------------------------------------------

    private void dealViewUi() {
        try {
            if (!FoxBaseCommonUtils.isEmpty(mData.getImageUrlList())) {
                String imgUrl = mData.getImageUrlList().get(0);
                if (!FoxBaseCommonUtils.isEmpty(imgUrl) && mImageView != null) {
                    mImageView.setVisibility(VISIBLE);
                    mImageView.setBackgroundDrawable(null);
                    mImageView.setImageUrl(FoxStringUtil.appandUrl(imgUrl), R.drawable.default_image_background);
                    mImageView.setLoadCallback(new FoxImageLoaderCalback() {
                        @Override
                        public void finish() {
                            if (mLinstener != null) {
                                mLinstener.onAdExposure();
                            }
                        }

                        @Override
                        public void failed() {
                            if (mLinstener != null) {
                                mLinstener.onLoadFailed();
                                mLinstener.onError(ERROR_CODE_1006);
                            }
                        }
                    });
                }
            }

            if (!FoxBaseCommonUtils.isEmpty(mData.getExtTitle())) {
                mTitle.setText(mData.getExtTitle());
            }

            if (adIcon != null) {
                adIcon.setVisibility(mData.isVisibleOfCloseButton() ? View.VISIBLE : View.GONE);
            }
            if (adClose != null) {
                adClose.setVisibility(mData.isVisibleOfIcon() ? View.VISIBLE : View.GONE);
            }

        } catch (Exception ex) {
            FoxBaseCrashUtils.reportErrorData(ex);
            if (mLinstener != null) {
                mLinstener.onLoadFailed();
                mLinstener.onError(ERROR_CODE_1006);
            }
        }

    }

}
