package com.mediamain.android.view.holder;

import android.app.Activity;

import com.mediamain.android.view.bean.MessageData;

/**
 * author: likaixuan
 * date: 2020/9/15
 * desc:
 */
public interface FoxFloatingWebHolder {

    /**
     * 悬浮升级广告的宿主activity
     * @param activity activity instance
     */
    void setFloatingHost(Activity activity);

    /**
     * 加载悬浮升级广告
     * @param slotId 广告位id
     * @param userId 用户id
     * @param left 入口素材距离屏幕左边缘距离，单位dp
     * @param top 入口素材距离屏幕上边缘距离，单位dp
     */
    void loadFloatingWebAd(int slotId, String userId, String left, String top, String right, String bottom, FloatingWebAdLoadListener listener);

    void sendMessage(int type, String data);

    /**
     * 设置应用appKey和appSecret
     * @param appKey appKey
     * @param appSecret appSecret
     */
    void setConfigInfo(String appKey, String appSecret);

    void hide();

    /**
     * hide 之后可以调用show方法再次显示，不计曝光
     */
    void show();

    /**
     * 销毁广告
     */
    void destroy();

    boolean goBack();

    /**
     * 悬浮升级广告加载回调
     */
    interface FloatingWebAdLoadListener {
        void onLoadSuccess();
        void onLoadFailed(int code, String message);

        /**
         * GG点击回调
         */
        void onAdClick();

        /**
         * 点击关闭按钮
         */
        void onCloseClick();

        void onAdActivityClose(String message);

        void onAdMessage(MessageData data);
    }
}
