package com.mediamain.android.view.holder;

import android.app.Activity;
import android.os.Build;
import android.text.TextUtils;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.config.FoxBaseUrl;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseDensityUtils;
import com.mediamain.android.base.util.FoxBaseGsonUtil;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.FoxBaseScreenUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.FloatingWebAd;
import com.mediamain.android.view.FoxActivity;
import com.mediamain.android.view.bean.FoxFloatUrlBean;
import com.mediamain.android.view.bean.MessageData;
import com.mediamain.android.view.util.FoxCommonUtils;
import com.mediamain.android.view.util.FoxListenerManager;
import com.mediamain.android.view.util.FoxListenerObserver;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;

import static com.mediamain.android.base.util.FoxBaseCommonUtils.getModel;
import static com.mediamain.android.hotfix.FoxSdkPatch.LOCAL_PATCH_CODE;
import static com.mediamain.android.hotfix.FoxSdkPatch.LOCAL_PATCH_VERSION;

/**
 * author: likaixuan
 * date: 2020/9/15
 * desc:
 */
public class FoxFloatingWebHolderImpl implements FoxFloatingWebHolder, FoxListenerObserver {
    public static boolean is_clicked = false;
    private FloatingWebAd floatingWebAd;

    private String mAppKey;
    private String mAppSecret;

    private String key;

    private Activity mActivity;

    private FloatingWebAdLoadListener listener;

    private WeakReference<FoxActivity> activityWeakReference;
    /**
     * 入口url，后面需要拼接位置以及请求serving接口的参数给前端
     */
    private String mEntranceUrl;

    // FoxListenerManager是否已注册监听
    private boolean registered;

    public FoxFloatingWebHolderImpl() {
        key = UUID.randomUUID().toString();
        floatingWebAd = new FloatingWebAd(key);
        mEntranceUrl = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_FLOATING_WEB_AD_URL, "");

        FoxListenerManager.getInstance().registrationObserver(key, this);
        registered = true;
    }

    @Override
    public void setFloatingHost(Activity activity) {
        mActivity = activity;
    }

    @Override
    public void setConfigInfo(String appKey, String appSecret) {
        mAppKey = appKey;
        mAppSecret = appSecret;
    }

    @Override
    public void sendMessage(int type, String data) {
        try {
            if (activityWeakReference != null) {
                ((activityWeakReference.get())).sendMessage(type, data);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    @Override
    public void loadFloatingWebAd(final int slotId, final String userId, final String left, final String top, final String right, final String bottom, FloatingWebAdLoadListener listener) {
        // v3.1.0.0 fixed: 无网络时，不展示广告素材
        if (!FoxBaseCommonUtils.isNetworkAvailable()) {
            if (listener != null) {
                listener.onLoadFailed(FoxSDKError.NETWORK_ERROR.getCode(), FoxSDKError.NETWORK_ERROR.getMessage());
            }
            return;
        }
        //请求广告前必须初始化
        if(!FoxBaseSDK.isInit){
            if (listener != null) {
                listener.onLoadFailed(FoxSDKError.UNINITIATED.getCode(), FoxSDKError.UNINITIATED.getMessage());
            }
            return;
        }
        if (listener == null) {
            FoxBaseLogUtils.e("悬浮升级广告的回调监听为空!");
        }
        // fixed: 悬浮升级支持激励视频，refresh 执行destroy导致接受不到回调
        if (!registered) {
            FoxListenerManager.getInstance().registrationObserver(key, this);
        }
        this.listener = listener;
        if (mActivity == null) {
            if (listener != null) {
                listener.onLoadFailed(FoxSDKError.FLOATING_EMPTY_HOST.getCode(), FoxSDKError.FLOATING_EMPTY_HOST.getMessage());
            }
            return;
        }
        if (TextUtils.isEmpty(mEntranceUrl)) {
            //兜底接口
            if (FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                mAppKey = FoxBaseCommonUtils.getAppKey();
                mAppSecret = FoxBaseCommonUtils.getAppSecret();
            }
            if (FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                if (listener != null) {
                    listener.onLoadFailed(FoxSDKError.INVALID_PARAM.getCode(), FoxSDKError.INVALID_PARAM.getMessage());
                }
                return;
            }

            String imei = FoxBaseCommonUtils.getIMEI();
            String phoneBrand = Build.MANUFACTURER;
            String phoneModel = getModel();
            String osType = "Android";
            String oaid = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, "") + "";
            TreeMap<String, String> mMap = new TreeMap<>();
            mMap.put("appKey", mAppKey);
            mMap.put("phoneBrand", phoneBrand);
            mMap.put("phoneModel", phoneModel);
            mMap.put("imei", imei);
            mMap.put("oaid", oaid);
            mMap.put("idfa", "");
            mMap.put("deviceId", imei);
            mMap.put("sdkVersion", BuildConfig.VERSION_NAME);
            mMap.put("osType", osType);
            mMap.put("patchVersion", FoxBaseSPUtils.getInstance().getString(LOCAL_PATCH_VERSION,""));
            mMap.put("patchCode", FoxBaseSPUtils.getInstance().getLong(LOCAL_PATCH_CODE,0l) + "");
            // 拼接要签名的参数字符串
            StringBuilder signSB = new StringBuilder();
            // 对map的key进行排序
            Set<String> keySet = mMap.keySet();
            Iterator<String> iter = keySet.iterator();
            while (iter.hasNext()) {
                String key = iter.next();
                signSB = signSB.append(key).append("=").append(mMap.get(key)).append("&");
            }
            String signStr = signSB.substring(0, signSB.length() - 1);
            // 对参数字符串进行SHA-1
            mMap.put("signature", FoxBaseCommonUtils.sha1(signStr));
            mMap.put("tcid", FoxBaseCommonUtils.getTcid());
            OkGo.<String>post(FoxBaseUrl.BASE_SDK_PUT_HOVERUPGRADESCKURL)
                .upJson(FoxBaseGsonUtil.GsonString(mMap))
                .execute(new StringCallback() {
                    @Override
                    public void onSuccess(Response<String> response) {
                        FoxFloatUrlBean foxFloatUrlBean = FoxBaseGsonUtil.GsonToBean(response.body(), FoxFloatUrlBean.class);
                        if(null != foxFloatUrlBean && foxFloatUrlBean.isSuccess()) {
                            mEntranceUrl = foxFloatUrlBean.getData() != null ? foxFloatUrlBean.getData().getWebSckUrl() : "";
                            if(!FoxBaseCommonUtils.isEmpty(mEntranceUrl)) {
                                FoxBaseSPUtils.getInstance().setString(FoxBaseConstants.KEY_FLOATING_WEB_AD_URL, mEntranceUrl);
                            }
                            loadAd(mEntranceUrl, slotId, userId, left, top, right, bottom);
                        }
                    }
                    @Override
                    public void onError(Response<String> response) {
                        super.onError(response);
                    }
                });
        }else{
            loadAd(mEntranceUrl,slotId, userId, left, top, right, bottom);
        }

    }

    private void loadAd(String url,int slotId,String userId , String left, String top, String right, String bottom){
        if(FoxCommonUtils.isEmpty(url)){
            return;
        }
        String md = FoxBaseCommonUtils.getMD(String.valueOf(slotId));
        int nonce = (int) ((Math.random() * 9 + 1) * 100000);
        long timestamp = System.currentTimeMillis();

        // 拼接请求serving接口的参数给前端
        StringBuilder sb = new StringBuilder();
        if (url.contains("?")) {
            sb.append(url).append("&");
        } else {
            sb.append(url).append("?");
        }
        sb.append("adslotId=").append(slotId).append("&");
        sb.append("userId=").append(userId).append("&");
        sb.append("appKey=").append(mAppKey).append("&");
        sb.append("md=").append(md).append("&");
        sb.append("timestamp=").append(timestamp).append("&");
        sb.append("nonce=").append(nonce).append("&");
        sb.append("signature=").append(FoxBaseCommonUtils.sha1("appSecret=" + mAppSecret + "&md=" + md + "&nonce=" + nonce + "&timestamp=" + timestamp)).append("&");
        sb.append("sourceType=").append("1").append("&");
        sb.append("isimageUrl=").append("1").append("&");
        sb.append("device_id=").append(FoxBaseCommonUtils.getIMEI()).append("&");
        sb.append("tcid=").append(FoxBaseCommonUtils.getTcid()).append("&");
        sb.append("slotSceneType=").append(FoxSDKType.FLOATING_WEB_AD.getCode());

        if (!TextUtils.isEmpty(left)) {
            sb.append("&");
            sb.append("left=").append(FoxBaseDensityUtils.dp2px(mActivity, Float.parseFloat(left)));
        }
        if (!TextUtils.isEmpty(top)) {
            sb.append("&");
            sb.append("top=").append(FoxBaseDensityUtils.dp2px(mActivity, adjustOffset(Float.parseFloat(top))));
        }
        if (!TextUtils.isEmpty(right)) {
            sb.append("&");
            sb.append("right=").append(FoxBaseDensityUtils.dp2px(mActivity, Float.parseFloat(right)));
        }
        if (!TextUtils.isEmpty(bottom)) {
            sb.append("&");
            sb.append("bottom=").append(FoxBaseDensityUtils.dp2px(mActivity, adjustOffset(Float.parseFloat(bottom))));
        }

        FoxBaseLogUtils.d("悬浮升级完整的入口url:" + sb.toString());

        floatingWebAd.init(mActivity, slotId, sb.toString(), listener);
        floatingWebAd.show();

        is_clicked = false;
//        if (listener != null) {
//            listener.onLoadSuccess();
//        }
    }

    private float adjustOffset(float value) {
        return value * 640.0f / FoxBaseScreenUtils.getScreenWidth();
    }

    @Override
    public boolean goBack() {
        if (floatingWebAd != null) {
            return floatingWebAd.goBack();
        }
        return false;
    }

    @Override
    public void hide() {
        if (floatingWebAd != null) {
            floatingWebAd.hide();
        }
    }

    @Override
    public void show() {
        if (floatingWebAd != null) {
            floatingWebAd.reShow();
        }
    }

    @Override
    public void destroy() {
        if (floatingWebAd != null) {
            floatingWebAd.destroy();
        }
        FoxListenerManager.getInstance().unregistrationObserver(key, this);
        registered = false;
    }

    @Override
    public void update(String event, Object msg) {
        try {
            if (FoxBaseCommonUtils.isEmpty(event)) {
                return;
            }
            if (event.contains(Constants.KEY_AD_CLOSE)) {
                if (listener != null && msg instanceof String) {
                    listener.onAdActivityClose((String) msg);
                }
            }
            if (event.contains(Constants.KEY_AD_MESSAGE)) {
                if (listener != null && msg instanceof MessageData) {
                    listener.onAdMessage((MessageData) msg);
                }
                return;
            }
            if (event.contains(Constants.KEY_ACTIVITY_EXAMPLE)) {
                activityWeakReference = new WeakReference<>((FoxActivity) msg);
                return;
            }


        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }
}
