//package com.mediamain.android.view.holder;
//
//import android.app.Activity;
//import android.content.Context;
//import android.support.annotation.NonNull;
//import android.text.TextUtils;
//
//import com.mediamain.android.base.FoxBaseSDK;
//import com.mediamain.android.base.config.FoxBaseUrl;
//import com.mediamain.android.base.okgo.OkGo;
//import com.mediamain.android.base.okgo.callback.StringCallback;
//import com.mediamain.android.base.okgo.model.Response;
//import com.mediamain.android.base.okgo.request.PostRequest;
//import com.mediamain.android.base.util.FoxBaseCommonUtils;
//import com.mediamain.android.view.FoxInfoFeedAd;
//import com.mediamain.android.view.bean.FoxResponseBean;
//import com.mediamain.android.view.util.FoxGsonUtil;
//
//import java.util.ArrayList;
//import java.util.List;
//
//import static com.mediamain.android.base.config.FoxBaseConstants.ERROR_CODE_1007;
//
///**
// * desc:自渲染的信息流
// *
// * Created by ZSY on 2020-03-16.
// */
//public class FoxNativeInfoFeedHolderImpl implements FoxNativeInfoFeedHolder {
//
//    FoxInfoFeedAd mFoxInfoFeedView;
//    List<IFoxBaseAd> foxBaseAds;
//
//    private String mAppKey;
//    private String mAppSecret;
//    private Context mContext;
//    private FoxResponseBean mFoxResponseBean;
//    private FoxResponseBean.DataBean mData;
//    private LoadInfoAdListener mLoadInfoAdListener;
//    private boolean isSupportApk = false;
//
//    @Override
//    public void setConfigInfo(String appKey, String appSecret) {
//        this.mAppKey = appKey;
//        this.mAppSecret = appSecret;
//    }
//
//    @Override
//    public void loadInfoAd(int slot, @NonNull LoadInfoAdListener loadInfoAdListener) {
//        this.loadInfoAd(null,slot,"",loadInfoAdListener);
//    }
//
//    @Override
//    public void loadInfoAd(int slot, String userId,@NonNull LoadInfoAdListener loadInfoAdListener) {
//        this.loadInfoAd(null,slot,userId,loadInfoAdListener);
//    }
//
//    @Override
//    public void loadInfoAd(Activity activity,int slot, @NonNull LoadInfoAdListener loadInfoAdListener) {
//        this.loadInfoAd(activity,slot,"",loadInfoAdListener);
//    }
//
//    @Override
//    public void loadInfoAd(Activity activity,int slot, String userId, @NonNull LoadInfoAdListener loadInfoAdListener) {
//        if (activity != null && !activity.isFinishing()){
//            this.mContext = activity;
//            this.isSupportApk = true;
//        }else {
//            this.isSupportApk = false;
//        }
//        this.mLoadInfoAdListener = loadInfoAdListener;
//        InfoAdRequest(slot,userId);
//    }
//
//    /**
//     * 请求GG
//     *
//     * @param adslot_id
//     * @param userId
//     */
//    private void InfoAdRequest(int adslot_id, final String userId) {
//        if (null == mContext){
//            mContext = FoxBaseSDK.getContext();
//        }
//        if (null == foxBaseAds){
//            foxBaseAds = new ArrayList<>();
//        }
//        foxBaseAds.clear();
//
//        try {
//            if (FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
//                mAppKey = FoxBaseCommonUtils.getAppKey();
//                mAppSecret = FoxBaseCommonUtils.getAppSecret();
//            }
//            if (adslot_id == 0 || FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
//                requestFailed(mLoadInfoAdListener,"Slot or AppKey or AppSecret not Null");
//                return;
//            }
//            final String md = FoxBaseCommonUtils.getMD();
//            int nonce = (int) ((Math.random() * 9 + 1) * 100000);
//            long timestamp = System.currentTimeMillis();
//            String mSignature = FoxBaseCommonUtils.sha1("appSecret=" + mAppSecret + "&md=" + md + "&nonce=" + nonce + "&timestamp=" + timestamp);
//            String imei = FoxBaseCommonUtils.getIMEI();
//            final PostRequest<String> stringGetRequest = OkGo.<String>post(FoxBaseUrl.BASE_SDK_SERVICE);
//            stringGetRequest.params("adslotId", adslot_id)
//                    .params("appKey", mAppKey)
//                    .params("md", md)
//                    .params("timestamp", timestamp)
//                    .params("nonce", nonce)
//                    .params("signature", mSignature)
//                    .params("isimageUrl", "1")
//                    .params("sourceType", "1")
//                    .params("device_id", ""+imei );
//            if (!FoxBaseCommonUtils.isEmpty(userId)) {
//                stringGetRequest.params("userId", userId);
//            }
//            if (isSupportApk) {
//                stringGetRequest.params("isSupportApk", "1");
//            }
//            stringGetRequest.execute(new StringCallback() {
//                @Override
//                public void onSuccess(Response<String> response) {
//                    try {
//                        if (response == null || response.body() == null || FoxBaseCommonUtils.isEmpty(response.body())) {
//                            requestFailed(mLoadInfoAdListener,"");
//                            return;
//                        }
//                        mFoxResponseBean = FoxGsonUtil.GsonToBean(response.body(), FoxResponseBean.class);
//                        if (mFoxResponseBean == null || mFoxResponseBean.getData() == null || !mFoxResponseBean.getData().isSdkType()) {
//                            requestFailed(mLoadInfoAdListener,"");
//                            return;
//                        }
//                        mData  = mFoxResponseBean.getData();
//                        if (mData == null){
//                            requestFailed(mLoadInfoAdListener,"");
//                            return;
//                        }
//                        if (!FoxBaseCommonUtils.isEmpty(mData.getActivityUrl()) && !FoxBaseCommonUtils.isEmpty(userId) && !mData.getActivityUrl().endsWith(".apk")) {
//                            if (mData.getActivityUrl().contains("?")) {
//                                mData.setActivityUrl(mData.getActivityUrl() + "&userId=" + userId);
//                            } else {
//                                mData.setActivityUrl(mData.getActivityUrl() + "?userId=" + userId);
//                            }
//                        }
//                        mFoxInfoFeedView = new FoxInfoFeedAd(mContext);
//                        mFoxInfoFeedView.setAdListener(mLoadInfoAdListener);
//                        mFoxInfoFeedView.setData(mData);
//                        mFoxInfoFeedView.setIs_clicked(false);
//                        foxBaseAds.add(mFoxInfoFeedView);
//                        String imageUrl = mData.getImageUrl();
//                        if (!TextUtils.isEmpty(imageUrl) && !FoxBaseCommonUtils.isEmpty(mData.getImageUrlList())) {
//                            if (mLoadInfoAdListener != null){
//                                mLoadInfoAdListener.infoAdSuccess(foxBaseAds);
//                            }
//                        } else {
//                            requestFailed(mLoadInfoAdListener,"");
//                        }
//                    } catch (Exception e) {
//                        try {
//                            requestFailed(mLoadInfoAdListener,e.getMessage());
//                        } catch (Exception ex) {
//                            requestFailed(mLoadInfoAdListener,ERROR_CODE_1007);
//                        }
//                    }
//                }
//
//                @Override
//                public void onError(Response<String> response) {
//                    super.onError(response);
//                    requestFailed(mLoadInfoAdListener,response.body());
//                }
//            });
//        } catch (Exception e) {
//            requestFailed(mLoadInfoAdListener,e.getCause().toString());
//        }
//    }
//
//    private void requestFailed(LoadInfoAdListener listener,String failMessage){
//        if (listener != null) {
//            listener.onError(failMessage);
//            listener.onFailedToReceiveAd();
//        }
//    }
//
//    @Override
//    public void destroy() {
//        try {
//            if(!FoxBaseCommonUtils.isEmpty(foxBaseAds)){
//                for(IFoxBaseAd ad:foxBaseAds){
//                    ad.destroy();
//                }
//            }
//        } catch (Exception ignored) {}
//    }
//
//}
