package com.mediamain.android.view.holder;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.FoxInfoStreamView;
import com.mediamain.android.view.base.FoxView;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.interfaces.ServingCallback;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc: 第一版信息流
 */
public class FoxNativeInfoHolderImpl implements FoxNativeInfoHolder {

    FoxInfoStreamView mFoxInfoView;

    private String mAppKey;
    private String mAppSecret;
    private Context mContext;
    private int mSlotId;
    private String mUserId;
    private FoxResponseBean.DataBean mData;
    private LoadInfoAdListener mLoadInfoAdListener;
    private boolean isSupportApk = false;

    @Override
    public void setConfigInfo(String appKey, String appSecret) {
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
    }

    @Override
    public void loadInfoAd(int slot, @NonNull LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(null, slot, "", loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(int slot, String userId, @NonNull LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(null, slot, userId, loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(Activity activity, int slot, @NonNull LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(activity, slot, "", loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(Activity activity, int slot, String userId, @NonNull LoadInfoAdListener loadInfoAdListener) {
        if (activity != null && !activity.isFinishing()) {
            this.mContext = activity;
            this.isSupportApk = true;
        } else {
            this.isSupportApk = false;
        }
        this.mLoadInfoAdListener = loadInfoAdListener;
        InfoAdRequest(slot, userId);
    }

    @Override
    public void sendMessage(int type, String message) {
        if (mFoxInfoView != null) {
            mFoxInfoView.sendMessage(type, message);
        }
    }

    /**
     * 请求GG
     *
     * @param adslot_id
     * @param userId
     */
    private void InfoAdRequest(int adslot_id, final String userId) {
        if (mContext == null) {
            mContext = FoxBaseSDK.getContext();
        }
        mSlotId = adslot_id;
        mUserId = userId;
        mFoxInfoView = new FoxInfoStreamView(mContext);
        mFoxInfoView.setAdListener(mLoadInfoAdListener);

        try {

            Map<String, String> params = new HashMap<>();
            params.put("slotAccessType", "0");
            params.put("slotSceneType", Integer.toString(FoxSDKType.FOX_TEMPLET_INFO_FEED.getCode())); //第一版信息流接入类型
            if (isSupportApk) {
                params.put("isSupportApk", "1");
            }

            FoxView.build().loadAdRequest(adslot_id, userId, false, mAppKey, mAppSecret, params, mLoadInfoAdListener, new ServingCallback() {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    servingSuccessResponse(data);
                }

                @Override
                public void onServingDataError(int code, String message) {
                    requestFailed(mLoadInfoAdListener, code, message);
                }
            });


        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            requestFailed(mLoadInfoAdListener, FoxSDKError.UNKNOWN.getCode(), FoxSDKError.UNKNOWN.getMessage());
        }

    }

    /**
     * Serving请求成功
     *
     * @param data
     */
    private void servingSuccessResponse(FoxResponseBean.DataBean data) {
        mData = data;
        if (!FoxBaseCommonUtils.isEmpty(mUserId) && !data.getActivityUrl().endsWith(".apk")) {
            if (data.getActivityUrl().contains("?")) {
                mData.setActivityUrl(data.getActivityUrl() + "&userId=" + mUserId);
            } else {
                mData.setActivityUrl(data.getActivityUrl() + "?userId=" + mUserId);
            }
        }
        if (mFoxInfoView != null) {
            mFoxInfoView.setData(mData);
            mFoxInfoView.setIs_clicked(false);
            mFoxInfoView.dealViewUI(mData);
            mFoxInfoView.setSlotId(mSlotId);
        }
        if (mLoadInfoAdListener != null) {
            mLoadInfoAdListener.infoAdSuccess(mFoxInfoView);
        }
    }

    private void requestFailed(LoadInfoAdListener listener, int errorCode, String failMessage) {
        if (listener != null) {
            listener.onError(failMessage);
            listener.onFailedToReceiveAd(errorCode, failMessage);
        }
    }

    @Override
    public void destroy() {
        if (mFoxInfoView != null) {
            mFoxInfoView.destroy();
        }
    }

}
