package com.mediamain.android.view.holder;

import android.graphics.Bitmap;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;

import com.mediamain.android.view.interfaces.FoxBaseAdListener;


/**
 * Created by ZSY on 2020-03-16.
 */
public interface FoxNativeSplashHolder {

    void loadCustomImage(int slotId, String userId, String path, @NonNull LoadSplashAdListener listener);

    void loadCustomImage(int slotId, String userId, Bitmap bitmap, @NonNull LoadSplashAdListener listener);

    void loadCustomImage(int slotId, String userId, @DrawableRes int resId, @NonNull LoadSplashAdListener listener);

    void setConfigInfo(String appKey, String appSecret);

    void destroy();

    void loadSplashAd(int slot, @NonNull FoxNativeSplashHolder.LoadSplashAdListener loadSplashAdListener);

    void loadSplashAd(int slot, String userId, @NonNull FoxNativeSplashHolder.LoadSplashAdListener loadSplashAdListener);

    interface LoadSplashAdListener extends FoxBaseAdListener {
        void onError(String errorBody);

        void splashAdSuccess(FoxSplashAd foxSplashAd);
    }

    void sendMessage(int type, String data);

}
