package com.mediamain.android.view.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.FoxNewShView;
import com.mediamain.android.view.base.FoxView;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.util.FoxStringUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc：开屏
 * Created by ZSY on 2020-03-16.
 */
public class FoxNativeSplashHolderImpl implements FoxNativeSplashHolder {

    FoxNewShView mFoxShView;

    private String mAppKey;
    private String mAppSecret;
    private Context mContext;
    private int mSlotId;
    private String mUserId;
    private FoxResponseBean.DataBean mSplashData;

    private LoadSplashAdListener mLoadSplashAdListener;

    @Override
    public void setConfigInfo(String appKey, String appSecret) {
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
    }

    @Override
    public void loadSplashAd(int slot, @NonNull LoadSplashAdListener loadSplashAdListener) {
        this.loadSplashAd(slot, "", loadSplashAdListener);
    }

    @Override
    public void loadSplashAd(int slot, String userId, @NonNull LoadSplashAdListener loadSplashAdListener) {
        mContext = FoxBaseSDK.getContext();
        mLoadSplashAdListener = loadSplashAdListener;
        splashAdRequest(slot, userId);
    }

    @Override
    public void sendMessage(int type, String data) {
        mFoxShView.sendMessage(type, data);
    }

    // 是否使用素材
    private boolean useImage = true;
    private Bitmap customBitmap;
    private String customPath;

    @Override
    public void loadCustomImage(int slotId, String userId, String path, @NonNull LoadSplashAdListener listener) {
        useImage = false;
        mLoadSplashAdListener = listener;
        if (FoxBaseCommonUtils.isEmpty(path)) {
            return;
        }
        if (path.startsWith("http") || path.startsWith("https")) {
            // 使用的是网络图片
            customPath = path;
        } else {
            customBitmap = BitmapFactory.decodeFile(path);
        }
        splashAdRequest(slotId, userId);
    }

    @Override
    public void loadCustomImage(int slotId, String userId, Bitmap bitmap, @NonNull LoadSplashAdListener listener) {
        useImage = false;
        mLoadSplashAdListener = listener;
        customBitmap = bitmap;
        splashAdRequest(slotId, userId);
    }

    @Override
    public void loadCustomImage(int slotId, String userId, int resId, @NonNull LoadSplashAdListener listener) {
        Bitmap bitmap = BitmapFactory.decodeResource(FoxBaseSDK.getContext().getResources(), resId);
        loadCustomImage(slotId, userId, bitmap, listener);
    }

    /**
     * 请求GG
     *
     * @param adslot_id 广告位ID
     * @param userId    用户ID
     */
    private void splashAdRequest(int adslot_id, final String userId) {
        if (mContext == null) {
            mContext = FoxBaseSDK.getContext();
        }
        mSlotId = adslot_id;
        mUserId = userId;
        mFoxShView = new FoxNewShView(mContext);
        mFoxShView.setAdListener(mLoadSplashAdListener);

        try {

            Map<String, String> params = new HashMap<>();
            params.put("slotAccessType", "0");
            params.put("slotSceneType", Integer.toString(FoxSDKType.FOX_NATIVE_SPLASH.getCode())); //开屏接入类型

            FoxView.build().loadAdRequest(adslot_id, userId, false, mAppKey, mAppSecret, params, null, new ServingCallback() {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    servingSuccessResponse(data);
                }

                @Override
                public void onServingDataError(int code, String message) {
                    requestFailed(mLoadSplashAdListener, code, message);
                }
            });


        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            requestFailed(mLoadSplashAdListener, FoxSDKError.UNKNOWN.getCode(), FoxSDKError.UNKNOWN.getMessage());
        }

    }

    /**
     * Serving请求成功
     *
     * @param data
     */
    private void servingSuccessResponse(FoxResponseBean.DataBean data) {
        // ServingCallback 已经处理了data为空的场景
        mSplashData = data;
        if (!FoxBaseCommonUtils.isEmpty(mUserId)) {
            if (data.getActivityUrl().contains("?")) {
                mSplashData.setActivityUrl(data.getActivityUrl() + "&userId=" + mUserId);
            } else {
                mSplashData.setActivityUrl(data.getActivityUrl() + "?userId=" + mUserId);
            }
        }
        mFoxShView.setData(mSplashData);
        mFoxShView.setSlotId(mSlotId);
        if (data.getSckId() == 0) {
            if (!FoxBaseCommonUtils.isEmpty(customPath)) {
                // 使用网络图片
                mFoxShView.setImageUrl(customPath);
            } else if (customBitmap != null) {
                mFoxShView.setImageSrc(customBitmap);
            } else {
                requestFailed(mLoadSplashAdListener, FoxSDKError.INVALID_CUSTOM_IMAGE_URI.getCode(), FoxSDKError.INVALID_CUSTOM_IMAGE_URI.getMessage());
            }
        } else {
            // 使用自定义素材，但是勾选了使用推啊素材
//                        requestFailed(mLoadSplashAdListener, SDKErrorCode.SDK_CONFIG_CONFLICT, "配置冲突，使用本地素材未生效！");
            mFoxShView.setImageUrl(FoxStringUtil.appandUrl(data.getImageUrl()));
        }

        mFoxShView.setTimeViewIsDisplay(data.isVisibleOfCloseButton());
        mFoxShView.setAdViewIsDisplay(data.isVisibleOfIcon());
        if (mLoadSplashAdListener != null) {
            mLoadSplashAdListener.splashAdSuccess(mFoxShView);
        }
    }

    private void requestFailed(LoadSplashAdListener listener, int errorCode, String failMessage) {
        if (listener != null) {
            listener.onError(failMessage);
            listener.onFailedToReceiveAd(errorCode, failMessage);
        }
    }

    @Override
    public void destroy() {
        mLoadSplashAdListener = null;
        if (mFoxShView != null) {
            mFoxShView.destroy();
        }
    }

}
