package com.mediamain.android.view.holder;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.base.FoxView;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.feed.FoxTempletInfoFeedAd;
import com.mediamain.android.view.interfaces.IFoxTempletInfoFeedAd;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.util.FoxListenerManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by ZSY on 2020-03-16.
 */
public class FoxTempletInfoFeedHolderImpl implements FoxTempletInfoFeedHolder {

    List<IFoxTempletInfoFeedAd> foxBaseAds;
    List<IFoxTempletInfoFeedAd> foxBaseRecordAds = new ArrayList<>();

    private String mAppKey;
    private String mAppSecret;
    private Context mContext;
    private int mSlotId;
    private String mUserId;
    private FoxResponseBean.DataBean mData;
    private LoadInfoAdListener mLoadInfoAdListener;
    private boolean isSupportApk = false;

    @Override
    public void setConfigInfo(String appKey, String appSecret) {
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
    }

    @Override
    public void loadInfoAd(int slot, @NonNull LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(null, slot, "", loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(int slot, String userId, @NonNull LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(null, slot, userId, loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(Activity activity, int slot, @NonNull LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(activity, slot, "", loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(Activity activity, int slot, String userId, @NonNull LoadInfoAdListener loadInfoAdListener) {
        if (activity != null && !activity.isFinishing()) {
            this.mContext = activity;
            this.isSupportApk = true;
        } else {
            this.isSupportApk = false;
        }
        mSlotId = slot;
        mUserId = userId;
        this.mLoadInfoAdListener = loadInfoAdListener;
        InfoAdRequest(slot, userId);
    }

    @Override
    public void sendMessage(int type, String message) {
        if (foxBaseRecordAds != null) {
            ((FoxTempletInfoFeedAd) foxBaseRecordAds.get(0)).sendMessage(type, message);
        }
    }

    /**
     * 请求GG
     *
     * @param adslot_id
     * @param userId
     */
    private void InfoAdRequest(final int adslot_id, final String userId) {
        if (null == mContext) {
            mContext = FoxBaseSDK.getContext();
        }
        if (null == foxBaseAds) {
            foxBaseAds = new ArrayList<>();
        } else {
            foxBaseAds.clear();
        }

        try {

            Map<String, String> params = new HashMap<>();
            params.put("slotAccessType", "0");
            params.put("specTemplateFlag", "1");// 用与区分SDK新老版本（传1可以请求到四种模板类型）
            params.put("slotSceneType", Integer.toString(FoxSDKType.FOX_TEMPLET_INFO_FEED.getCode())); //信息流接入类型
            if (isSupportApk) {
                params.put("isSupportApk", "1");
            }

            FoxView.build().loadAdRequest(adslot_id, userId, false, mAppKey, mAppSecret, params, mLoadInfoAdListener, new ServingCallback() {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    servingSuccessResponse(data);
                }

                @Override
                public void onServingDataError(int code, String message) {
                    requestFailed(mLoadInfoAdListener, code, message);
                }
            });


        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            requestFailed(mLoadInfoAdListener, FoxSDKError.UNKNOWN.getCode(), FoxSDKError.UNKNOWN.getMessage());
        }
    }

    /**
     * Serving请求成功
     *
     * @param data
     */
    private void servingSuccessResponse(FoxResponseBean.DataBean data) {
        mData = data;
        if (!FoxBaseCommonUtils.isEmpty(mUserId) && !data.getActivityUrl().endsWith(".apk")) {
            if (data.getActivityUrl().contains("?")) {
                mData.setActivityUrl(data.getActivityUrl() + "&userId=" + mUserId);
            } else {
                mData.setActivityUrl(data.getActivityUrl() + "?userId=" + mUserId);
            }
        }
        FoxTempletInfoFeedAd foxTempletInfoFeedAd = new FoxTempletInfoFeedAd(mContext);
        foxTempletInfoFeedAd.setListener(mLoadInfoAdListener);
        foxTempletInfoFeedAd.setData(mData);
        foxTempletInfoFeedAd.setAdslotId(mSlotId);
        foxTempletInfoFeedAd.setIs_clicked(false);
        foxBaseAds.add(foxTempletInfoFeedAd);
        foxBaseRecordAds.add(foxTempletInfoFeedAd);
        if (mLoadInfoAdListener != null) {
            mLoadInfoAdListener.infoAdSuccess(foxBaseAds);
        }
    }

    //失败回调
    private void requestFailed(LoadInfoAdListener listener, int errorCode, String failMessage) {
        if (listener != null) {
            listener.onError(failMessage);
            listener.onFailedToReceiveAd(errorCode, failMessage);
        }
    }

    @Override
    public void destroy() {
        try {
            mContext = null;
            if (!FoxBaseCommonUtils.isEmpty(foxBaseRecordAds)) {
                for (IFoxTempletInfoFeedAd ad : foxBaseRecordAds) {
                    ad.destroy();
                }
            }
            FoxListenerManager.getInstance().clearObserverHashMap();
        } catch (Exception ignored) {
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

}
