package com.mediamain.android.view.holder;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.FoxTextLinkView;
import com.mediamain.android.view.base.FoxView;
import com.mediamain.android.view.bean.FoxResponseBean;
import com.mediamain.android.view.interfaces.FoxTextLinkHolder;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.util.FoxViewCommonUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * desc:文字链
 * <p>
 * Created by ZSY on 2020-06-08.
 */
public class FoxTextLinkHolderImpl implements FoxTextLinkHolder {

    public static final String TEXT_LINK_EXPOSURE_COUNT = "text_link_exposure_count"; //曝光次数
    public static final String TEXT_LINK_EXPOSURE_DATE = "text_link_exposure_date"; //曝光次数记录的时间
    FoxTextLinkView mFoxInfoView;

    private String mAppKey;
    private String mAppSecret;
    private Context mContext;
    private int mSlotId;
    private String mUserId;
    private FoxResponseBean.DataBean mData;
    private FoxTextLinkHolder.LoadInfoAdListener mLoadInfoAdListener;
    private boolean isSupportApk = false;

    @Override
    public void setConfigInfo(String appKey, String appSecret) {
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
    }

    @Override
    public void loadInfoAd(int slot, @NonNull FoxTextLinkHolder.LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(null, slot, "", loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(int slot, String userId, @NonNull FoxTextLinkHolder.LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(null, slot, userId, loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(Activity activity, int slot, @NonNull FoxTextLinkHolder.LoadInfoAdListener loadInfoAdListener) {
        this.loadInfoAd(activity, slot, "", loadInfoAdListener);
    }

    @Override
    public void loadInfoAd(Activity activity, int slot, String userId, @NonNull FoxTextLinkHolder.LoadInfoAdListener loadInfoAdListener) {
        if (activity != null && !activity.isFinishing()) {
            this.mContext = activity;
            this.isSupportApk = true;
        } else {
            this.isSupportApk = false;
        }
        mSlotId = slot;
        mUserId = userId;
        this.mLoadInfoAdListener = loadInfoAdListener;
        InfoAdRequest(slot, userId);
    }

    @Override
    public void sendMessage(int type, String message) {
        mFoxInfoView.sendMessage(type, message);
    }

    /**
     * 请求GG
     *
     * @param adslot_id
     * @param userId
     */
    private void InfoAdRequest(final int adslot_id, final String userId) {
        if (mContext == null) {
            mContext = FoxBaseSDK.getContext();
        }
        mFoxInfoView = new FoxTextLinkView(mContext);
        mFoxInfoView.setAdListener(mLoadInfoAdListener);

        try {

            int deviceSlotExpCount = FoxBaseSPUtils.getInstance().getInt(TEXT_LINK_EXPOSURE_COUNT, 1); //曝光次数
            FoxBaseSPUtils.getInstance().setInt(TEXT_LINK_EXPOSURE_COUNT, deviceSlotExpCount + 1);

            Map<String, String> params = new HashMap<>();
            params.put("slotAccessType", "0");
            params.put("slotSceneType", Integer.toString(FoxSDKType.FOX_TEXT_LINK.getCode())); //文字链接入类型
            params.put("deviceSlotExpCount", Integer.toString(deviceSlotExpCount));
            if (isSupportApk) {
                params.put("isSupportApk", "1");
            }

            FoxView.build().loadAdRequest(adslot_id, userId, false, mAppKey, mAppSecret, params, mLoadInfoAdListener, new ServingCallback() {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    servingSuccessResponse(data);
                }

                @Override
                public void onServingDataError(int code, String message) {
                    requestFailed(mLoadInfoAdListener, code, message);
                }
            });


        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            requestFailed(mLoadInfoAdListener, FoxSDKError.UNKNOWN.getCode(), FoxSDKError.UNKNOWN.getMessage());
        }
    }

    /**
     * Serving请求成功
     *
     * @param data
     */
    private void servingSuccessResponse(FoxResponseBean.DataBean data) {
        mData = data;
        if (!FoxBaseCommonUtils.isEmpty(mUserId) && !data.getActivityUrl().endsWith(".apk")) {
            if (data.getActivityUrl().contains("?")) {
                mData.setActivityUrl(data.getActivityUrl() + "&userId=" + mUserId);
            } else {
                mData.setActivityUrl(data.getActivityUrl() + "?userId=" + mUserId);
            }
        }
        if (mFoxInfoView != null) {
            //预加载
            FoxViewCommonUtils.startPreLoad(String.valueOf(mSlotId), mData.getActivityUrl(), FoxSDKType.FOX_TEXT_LINK.getCode());

            mFoxInfoView.setData(mData);
            mFoxInfoView.setIs_clicked(false);
            mFoxInfoView.setSlotId(mSlotId);
            mFoxInfoView.dealViewUI(mData);
            if (mLoadInfoAdListener != null) {
                mLoadInfoAdListener.infoAdSuccess(mFoxInfoView);
            }
        }
    }

    private void requestFailed(FoxTextLinkHolder.LoadInfoAdListener listener, int errorCode, String failMessage) {
        if (listener != null) {
            listener.onError(failMessage);
            listener.onFailedToReceiveAd(errorCode, failMessage);
        }
    }

    @Override
    public void destroy() {
        if (mFoxInfoView != null) {
            mFoxInfoView.destroy();
        }
    }

}
