package com.mediamain.android.view.imageloader;

import android.graphics.Bitmap;
import android.os.Build;
import android.util.LruCache;

public class FoxImageCache {

	public FoxImageCache(){
		mMemoryCache = getMemoryCache();
	}
	
	private LruCache<String, Bitmap> mMemoryCache;
	
	public void addBitmapToCache(String data, Bitmap bitmap) {
		if (data == null || bitmap == null) {
			return;
		}
		// Add to memory cache
		if (mMemoryCache != null && mMemoryCache.get(data) == null) {
			mMemoryCache.put(data, bitmap);
		}
	}

	public Bitmap getBitmapFromMemCache(String data) {
		if (mMemoryCache != null) {
			final Bitmap memBitmap = mMemoryCache.get(data);
			if (memBitmap != null) {
				return memBitmap;
			}
		}
		return null;
	}

	public void clearCaches() {
		mMemoryCache.evictAll();
	}
	
	public LruCache<String, Bitmap> getMemoryCache() {
		if (mMemoryCache == null) {
			return mMemoryCache = new LruCache<String, Bitmap>(
					FoxGlobe.DEFAULT_MEM_CACHE_SIZE) {
				/**
				 * Measure item size in bytes rather than units which is more
				 * practical for a bitmap cache
				 */
//				@SuppressLint("NewApi")
				@Override
				protected int sizeOf(String key, Bitmap bitmap) {
					if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB_MR1) {
						return bitmap.getByteCount();
					}
					// Pre HC-MR1
					return bitmap.getRowBytes() * bitmap.getHeight();
				}
			};
		}
		return mMemoryCache;
	}
}
