/**
 * Copyright 2016 Zhougaofeng
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mediamain.android.view.interfaces;


import com.mediamain.android.view.bean.MessageData;

/**
 * @Author: Zhougaofeng
 * Email: 365315018@qq.com
 * Time: 2016/10/24
 * Description:
 */
public interface FoxListener {

    /**
     * 获取GG成功
     */
    void onReceiveAd();

    /**
     * 获取GG失败
     */
    void onFailedToReceiveAd(int errorCode, String errorMsg);

    /**
     * 加载GG图片失败
     */
    void onLoadFailed();

    /**
     * 关闭GG素材
     */
    void onCloseClick();

    /**
     * GG素材点击
     */
    void onAdClick();

    /**
     * GG素材曝光
     */
    void onAdExposure();

    /**
     * GG活动页关闭
     *
     * @param data
     */
    void onAdActivityClose(String data);

    /**
     * h5通知页面的数据
     *
     * @param data 回传参数
     */
    void onAdMessage(MessageData data);


}
