package com.mediamain.android.view.interfaces;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.util.FoxBaseGsonUtil;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.bean.FoxResponseBean;

import java.util.List;

public class ServingCallback extends StringCallback {
    // true:使用素材, false:不使用素材(自定义可以不使用素材)
    private boolean useMaterial = false;

    public ServingCallback(){

    }
    public ServingCallback(boolean useMaterial) {
        this.useMaterial = useMaterial;
    }

    @Override
    public void onSuccess(Response<String> response) {
        try {
            if (!FoxBaseSDK.isInit) {
                onServingDataError(FoxSDKError.UNINITIATED.getCode(), FoxSDKError.UNINITIATED.getMessage());
                return;
            }
            if (response == null || response.body().isEmpty()) {
                onServingDataError(FoxSDKError.INVALID_SERVING_DATA.getCode(), FoxSDKError.INVALID_SERVING_DATA.getMessage());
                return;
            }
            FoxResponseBean servingResponse = FoxBaseGsonUtil.GsonToBean(response.body(), FoxResponseBean.class);
            if (servingResponse == null) {
                onServingDataError(FoxSDKError.INVALID_SERVING_DATA.getCode(), FoxSDKError.INVALID_SERVING_DATA.getMessage());
                return;
            }
            if (servingResponse.isSuccess()) {
                FoxResponseBean.DataBean data = servingResponse.getData();
                if (data == null) {
                    onServingDataError(FoxSDKError.INVALID_SERVING_DATA.getCode(), FoxSDKError.INVALID_SERVING_DATA.getMessage());
                } else {
                    String activityUrl = data.getActivityUrl();
                    if (activityUrl == null || activityUrl.isEmpty()) {
                        // 活动URL为空
                        onServingDataError(FoxSDKError.INVALID_ACTIVITY_URL.getCode(), FoxSDKError.INVALID_ACTIVITY_URL.getMessage());
                        return;
                    }
                    if (!data.isSdkType()) {
                        onServingDataError(FoxSDKError.SDK_TYPE_LIMIT.getCode(), FoxSDKError.SDK_TYPE_LIMIT.getMessage());
                        return;
                    }
                    String imgUrl = data.getImageUrl();
                    List<String> imgUrlList = data.getImageUrlList();
                    if (useMaterial) {
                        if (imgUrlList == null || imgUrlList.isEmpty()) {
                            onServingDataError(FoxSDKError.INVALID_IMAGE_URL.getCode(), FoxSDKError.INVALID_IMAGE_URL.getMessage());
                            return;
                        }
                        if (imgUrl == null || imgUrl.isEmpty()) {
                            onServingDataError(FoxSDKError.INVALID_IMAGE_URL.getCode(), FoxSDKError.INVALID_IMAGE_URL.getMessage());
                            return;
                        }
                    }
                    onServingDataCorrect(data);
                }
            } else {
                // 接口返回的错误码不能超过Integer.MAX
                onServingDataError(Integer.parseInt(servingResponse.getCode()), servingResponse.getDesc());
            }
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
            onServingDataError(FoxSDKError.UNINITIATED.getCode(), FoxSDKError.UNINITIATED.getMessage());
        }
    }

    @Override
    public void onError(Response<String> response) {
        super.onError(response);
        onServingDataError(FoxSDKError.REQUEST_SERVING_ERROR.getCode(), FoxSDKError.REQUEST_SERVING_ERROR.getMessage());
    }

    public void onServingDataCorrect(FoxResponseBean.DataBean data){}

    public void onServingDataError(int code, String message){}
}