package com.mediamain.android.view.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;

import com.mediamain.android.base.data.FoxBaseNewDownloadBean;
import com.mediamain.android.base.util.FoxBaseClickUtils;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseDownloadDialog;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.base.util.xpopup.XPopup;
import com.mediamain.android.base.util.xpopup.core.BasePopupView;
import com.mediamain.android.view.bean.FoxResponseBean;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;


public class FoxCommonUtils {

    private static final String TAG = FoxCommonUtils.class.getSimpleName();


    /**
     * 处理信息流新下载器样式
     * @param activity
     * @param url
     * @param mData
     */
    public static void dealCommonDowdload(Activity activity, String url,int scene, String slotId,FoxResponseBean.DataBean mData) {
        try {
            if (activity == null || activity.isFinishing() || FoxBaseClickUtils.isFastClick()) {
                return;
            }
            FoxBaseNewDownloadBean newDownloadBean;
            if (mData != null) {
                newDownloadBean = new FoxBaseNewDownloadBean(url,slotId,"",mData.getAdvertSdkRsp(),mData.getSdkDsmLogRsp());
            } else {
                newDownloadBean = new FoxBaseNewDownloadBean(url,slotId,"",null,null);
            }
            final FoxBaseDownloadDialog adDownloadDialog = new FoxBaseDownloadDialog(activity, url,scene, newDownloadBean);
            BasePopupView basePopupView = new XPopup.Builder(activity)
                    .dismissOnBackPressed(false)
                    .dismissOnTouchOutside(false)
                    .autoDismiss(false)
                    .enableDrag(false)
                    .hasShadowBg(true)
                    .asCustom(adDownloadDialog);
            if (!adDownloadDialog.isShow()) {
                basePopupView.show();
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    /**
     * 获取 构建并获取 Imei 信息
     * Pseudo-IMEI, 这个在任何Android手机中都有效
     * 有一些特殊的情况，一些如平板电脑的设置没有通话功能，或者你不愿加入READ_PHONE_STATE许可。而你仍然想获得唯
     * 一序列号之类的东西。这时你可以通过取出ROM版本、制造商、CPU型号、以及其他硬件信息来实现这一点。这样计算出
     * 来的ID不是唯一的（因为如果两个手机应用了同样的硬件以及Rom 镜像）。但应当明白的是，出现类似情况的可能性基
     * 本可以忽略。大多数的Build成员都是字符串形式的，我们只取他们的长度信息。我们取到13个数字，并在前面加上“ta
     * ”。这样这个ID看起来就和15位IMEI一样了。
     *
     * @return PesudoUniqueID
     */
    public static String getPesudoIMEI() {
        String m_szDevIDShort = "ta" +
                Build.BOARD.length() % 10 +
                Build.BRAND.length() % 10 +
                Build.CPU_ABI.length() % 10 +
                Build.DEVICE.length() % 10 +
                Build.DISPLAY.length() % 10 +
                Build.HOST.length() % 10 +
                Build.ID.length() % 10 +
                Build.MANUFACTURER.length() % 10 +
                Build.MODEL.length() % 10 +
                Build.PRODUCT.length() % 10 +
                Build.TAGS.length() % 10 +
                Build.TYPE.length() % 10 +
                Build.USER.length() % 10; //13 digits
        return m_szDevIDShort;
    }

    /**
     * The Android ID（OPENUUID）
     * 通常被认为不可信，因为它有时为null。开发文档中说明了：这个ID会改变如果进行了出厂设置。并且，如果某个
     * Andorid手机被Root过的话，这个ID也可以被任意改变。无需任何许可。
     *
     * @return AndroidID
     */
    @SuppressLint("HardwareIds")
    public static String getAndroidId(Context context) {
        return Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
    }

    /**
     * 可用于 确定唯一设备   32 位 (该设备号有可能有一定几率重复，但是概率很小)
     *
     * @param context
     * @return 32位字符串（大写）
     */
    public static String getPesudoDeviceId(Context context) {
        String deviceId = "";
        if (FoxBaseCommonUtils.isEmpty(deviceId)) {
            String m_szLongID = getPesudoIMEI() + getAndroidId(context);
            MessageDigest m = null;
            try {
                m = MessageDigest.getInstance("MD5");
            } catch (NoSuchAlgorithmException e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
            m.update(m_szLongID.getBytes(), 0, m_szLongID.length());
            byte p_md5Data[] = m.digest();
            String m_szUniqueID = new String();
            for (int i = 0; i < p_md5Data.length; i++) {
                int b = (0xFF & p_md5Data[i]);
                if (b <= 0xF)
                    m_szUniqueID += "0";
                m_szUniqueID += Integer.toHexString(b);
            }
            deviceId = m_szUniqueID.toUpperCase(Locale.getDefault());
        } else {

        }
        return deviceId;
    }

    /**
     * 判断列表是否为空
     *
     * @param list
     * @return
     */
    public static <T> boolean isEmpty(List<T> list) {
        if (list != null && list.size() > 0) {
            return false;
        }
        return true;
    }

    /**
     * 判断字符串是否为空
     *
     * @param s
     * @return
     */
    public static boolean isEmpty(String s) {
        return TextUtils.isEmpty(s);
    }
}
