package com.mediamain.android.view.util;

import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.util.HashMap;

public class FoxListenerManager<T> {

    private static HashMap<Object,FoxListenerObserver> observerHashMap = new HashMap<>();
    private static volatile FoxListenerManager mManager;
    private String mEvent;
    private T mMsg;
    private String mKey;

    public static synchronized FoxListenerManager getInstance() {
        if (mManager == null) {
            mManager = new FoxListenerManager();
        }
        return mManager;
    }

    /**
     * 发送消息
     *
     * @param msg
     */
    public void sendMsg(String event,T msg,String key) {
        this.mEvent = event;
        this.mMsg = msg;
        this.mKey = key;
        notifyAlls(mKey);
    }

    /**
     * 注册事件
     *
     * @param observer
     */
    public void registrationObserver(String key,FoxListenerObserver observer) {
        try {
            if (observerHashMap != null && observer != null) {
                observerHashMap.put(key,observer);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 删除事件
     *
     * @param observer
     */
    public void unregistrationObserver(String key,FoxListenerObserver observer) {
        try {
            if (observerHashMap != null && observerHashMap.size()>0 && observerHashMap.containsKey(key) && observer != null) {
                observerHashMap.remove(key);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public void clearObserverHashMap(){
        try {
            if(null != observerHashMap) {
                observerHashMap.clear();
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 分发消息
     */
    private void notifyAlls(String key) {
        try {
            if (!FoxBaseCommonUtils.isEmpty(key)&&observerHashMap!=null && observerHashMap.size()!=0){
                for(HashMap.Entry<Object, FoxListenerObserver> entry : observerHashMap.entrySet()){
                    if (key.contains((String)entry.getKey()) && entry.getValue()!=null){
                        entry.getValue().update(mEvent,mMsg);
                    }
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }
}
