/**
 * Copyright 2016 Zhougaofeng
 * <p/>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p/>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p/>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.mediamain.android.view.util;


import android.text.TextUtils;
import android.util.Base64;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;

/**
 * Author: Zhougaofeng
 * Email: 365315018@qq.com
 * Time: 2016/10/27
 * Description:
 */
public class FoxStringUtil {

    private static final String URL_HEAD = "http";

    //线上
        public static final String DOMAIN_NAME = BuildConfig.HOST;

    // 预发
//    public static final String DOMAIN_NAME="https://engine.tuiapre.cn";

    //测试新域名
//    public static final String DOMAIN_NAME="http://engine.tuiatest.cn";

    //开发环境
//    public static final String DOMAIN_NAME="http://172.16.61.74:17790";

    public static final String SDK_TYPE="Android";
    public static final String SDK_VERSION="2.4.4";

    /**
     *      * 产生4位随机数(0000-9999)
     *      * @return 4位随机数
     *     
     */
    public static String getFourRandom() {
        Random random = new Random();
        String fourRandom = random.nextInt(10000) + "";
        int randLength = fourRandom.length();
        if (randLength < 4) {
            for (int i = 1; i <= 4 - randLength; i++) {
                fourRandom = "0" + fourRandom;
            }
        }
        return fourRandom;
    }

    public static String appandUrl(String url) {
        String _url = url;
        if (!TextUtils.isEmpty(url) && !url.startsWith(URL_HEAD)) {
            _url = URL_HEAD + url;
        }
        return _url;
    }

    public static String SHA1(String decript) {
        try {
            MessageDigest digest = MessageDigest
                    .getInstance("SHA-1");
            digest.update(decript.getBytes());
            byte messageDigest[] = digest.digest();
            // Create Hex String
            StringBuffer hexString = new StringBuffer();
            // 字节数组转换为 十六进制 数
            for (int i = 0; i < messageDigest.length; i++) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        } catch (NoSuchAlgorithmException e) {
            FoxBaseCrashUtils.reportErrorData(e);
        }
        return "";
    }

    public static String appendField(Map<String, String> paramMap) {
        TreeMap<String, String> sortedMap = new TreeMap<>(paramMap);
        StringBuilder builder = new StringBuilder();
        boolean flag=true;
        for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
            String value = entry.getValue();
            String name=entry.getKey();
            if(flag){
                builder.append(name+"="+value);
                flag=false;
            }else{
                builder.append("&"+name+"="+value);
            }
        }
        return builder.toString();
    }

    public static String encodeStrByMd5(String str) {
        String reStr = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(str.getBytes());
            StringBuffer stringBuffer = new StringBuffer();
            for (byte b : bytes){
                int bt = b&0xff;
                if (bt < 16){
                    stringBuffer.append(0);
                }
                stringBuffer.append(Integer.toHexString(bt));
            }
            reStr = stringBuffer.toString();
        } catch (NoSuchAlgorithmException e) {
            FoxBaseCrashUtils.reportErrorData(e);
        }
        return reStr;
    }

    public static String compressForGzip(byte[] input) {
        if (input == null) {
            return null;
        }
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = new GZIPOutputStream(outStream);
            gzipStream.write(input);
            gzipStream.close();
            return Base64.encodeToString(outStream.toByteArray(), Base64.DEFAULT);
        } catch (IOException ex) {
            FoxBaseCrashUtils.reportErrorData(ex);
        }
        return null;
    }

}
