package com.mediamain.android.view.util;

import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;

import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.okgo.request.GetRequest;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.FoxBrowserLayout;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by ZSY on 2020-08-17.
 */

public class FoxViewCommonUtils {

    public static void startPreLoad(String slotId,String url,int adType){
        //a为预加载
        if(!FoxBaseCommonUtils.isEmpty(url) && FoxViewCommonUtils.isPreLoadUrl(url)){
            FoxBrowserLayout.preLoadUrl(url,slotId,adType);
        }
    }

    /**
     * 获取WebView上一个URL
     * @param view
     * @return
     */
    public static String lastUrl(WebView view){
        String backPageUrl = "";
        try {
            WebBackForwardList backForwardList = view.copyBackForwardList();
            if (backForwardList != null && backForwardList.getSize() != 0) {
                //当前页面在历史队列中的位置
                int currentIndex = backForwardList.getCurrentIndex();
                WebHistoryItem historyItem =
                        backForwardList.getItemAtIndex(currentIndex - 1);
                if (historyItem != null) {
                    backPageUrl = historyItem.getUrl();
                }
            }
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }

        return backPageUrl;
    }

    public static boolean isActivityUrl(String url){
        boolean isActivityUrl = false;
        try {
            if(!FoxBaseCommonUtils.isEmpty(url)){
                String decodeUrl = url;
                try {
                    decodeUrl = URLDecoder.decode(url, "UTF-8");
                } catch (Exception ignored) {
                    FoxBaseCrashUtils.reportErrorData(ignored);
                }
                isActivityUrl = decodeUrl.contains("activity/index?");
            }
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return isActivityUrl;
    }

    public static boolean isPreLoadUrl(String url){
        boolean isPreLoadUrl = false;
        try {
            if(!FoxBaseCommonUtils.isEmpty(url)){
                isPreLoadUrl = url.contains("preloading=1");
            }
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return isPreLoadUrl;
    }

    /**
     * 补打活动日志
     * @param url
     */
    public static void uploadLog(String url,String activityUrl) {
        if(FoxBaseCommonUtils.isEmpty(url)){
            return;
        }
        try {
            String actUrl = url.replace("preloading=1","preloading=1&actloading=1");
            GetRequest<String> request = OkGo.<String>get(actUrl);
            request.execute(new StringCallback() {
                @Override
                public void onSuccess(Response<String> response) {
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 通过ScmLog补打日志
     * @param url
     * @param activityUrl 广告位链接（悬浮升级则是getActivityUrl）
     */
    public static void uploadScmLog(String url, String activityUrl) {
        try {
            //补打日志
            String actId = FoxBaseCommonUtils.getValueByName(url, "actId");
            String actMd = FoxBaseCommonUtils.getValueByName(url, "actMd");
            String activityUrlDecode = URLDecoder.decode(activityUrl, "UTF-8");
            String strParam = activityUrlDecode.substring(activityUrlDecode.indexOf("?"),activityUrlDecode.length());
            Map<String, String> param = new HashMap<>();
            param.put("operateType", "4");
            if(!strParam.contains("actId")) param.put("actId", actId);
            if(!strParam.contains("actMd")) param.put("actMd", actMd);

            FoxBaseMaidianUtil.build(0).postScmLog(param,strParam);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }
}
