package com.mediamain.android.view.util;

import com.mediamain.android.base.data.FoxBaseSdkDsmLogRspBean;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.bean.FoxResponseBean;

import java.util.Map;

/**
 * Created by ZSY on 2020-07-27.
 */
public class FoxViewMaidianUtils {

    private static final String TAG = "FoxViewMaidianUtils";

    /**
     * 点击/曝光 埋点统计
     * @param logType 0：曝光  1：点击
     * @param data  实际url数据
     */
    public static void doResponse(int slotId, int logType, FoxResponseBean.DataBean data, final Map<String,String> params) {
        try {
            if (data == null) {
                return;
            }
            String mUrl = "";
            if (logType == 0) {
                mUrl = data.getReportExposureUrl();
            } else if (logType == 1) {
                mUrl = data.getReportClickUrl();
            }
            if (FoxBaseCommonUtils.isEmpty(mUrl)) {
                return;
            }
            FoxBaseLogUtils.d(TAG + "——>doResponse——>logType:" + logType + "——>url:" + mUrl);
            OkGo.<String>get(mUrl)
                    .params(params)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(com.mediamain.android.base.okgo.model.Response<String> response) {}
                    });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 点击/曝光 埋点统计 (原生插屏)
     * @param logType
     * @param data
     * @param params
     */
    public static void doResponse(int logType, FoxResponseBean.DataBean data, Map<String,String> params) {
        try {
            if (data == null) {
                return;
            }
            String mUrl = "";
            if (logType == 0) {
                mUrl = data.getReportExposureUrl();
            } else if (logType == 1) {
                mUrl = data.getReportClickUrl();
            }
            if (FoxBaseCommonUtils.isEmpty(mUrl)) {
                return;
            }
            FoxBaseLogUtils.d(TAG + "——>doResponse——>logType:" + logType + "——>url:" + mUrl);
            OkGo.<String>get(mUrl)
                    .params(params)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(com.mediamain.android.base.okgo.model.Response<String> response) {

                        }

                        @Override
                        public void onError(com.mediamain.android.base.okgo.model.Response<String> response) {
                            super.onError(response);
                        }
                    });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * JF/下载 埋点
     * @param params
     */
    public static void logUpload(int type, Map<String,String> params){
        try {
            FoxBaseMaidianUtil foxBaseMaidianUtil = FoxBaseMaidianUtil.build(type);
            if(null != params) {
                foxBaseMaidianUtil.set(params);
            }
            foxBaseMaidianUtil.postScmLog(null);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }
    /**
     * JF/下载 埋点
     * @param params
     */
    public static void logUpload(int type, Map<String,String> params, FoxBaseSdkDsmLogRspBean sdkDsmLogRspBean){
        try {
            FoxBaseMaidianUtil foxBaseMaidianUtil = FoxBaseMaidianUtil.build(type);
            if(null != params) {
                foxBaseMaidianUtil.set(params);
            }
            foxBaseMaidianUtil.postScmLog(sdkDsmLogRspBean);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }
    /**
     * 活动加载 埋点
     * @param params
     */
    public static void activityLogUpload(int type, Map<String,String> params){
        try {
            FoxBaseMaidianUtil foxBaseMaidianUtil = FoxBaseMaidianUtil.build(type);
            if(null != params) {
                foxBaseMaidianUtil.set(params);
            }
            foxBaseMaidianUtil.postScmLog(null);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

}
