package com.mediamain.android.view.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.mediamain.android.R;
import com.mediamain.android.base.download.IntegrateH5DownloadManager;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.webview.FoxBaseSdkWebView;
import com.mediamain.android.view.webview.callback.FoxWebViewClientAndChromeClient;
import com.mediamain.android.view.webview.helper.WebViewHelper;
import com.mediamain.android.view.webview.jsbridge.DownloadJsBridgeHandler;

/**
 * Description:
 *
 * @author:Swilliam
 * @date:2020/11/27 17:37
 */

public class FoxLandActivity extends AppCompatActivity {

    public static final String BUNDLE_KEY_URL = "BUNDLE_KEY_URL";
    private static final int LOAD_FINISH_DATA = 100;
    private static final int BAR_HEIGHT = 5;
    private static final int MAX_TITLE_SIZE = 9;

    private FoxBaseSdkWebView mWebView = null;
    private JsHandler jsHandler = null;
    private String mWebUrl;
    private ProgressBar mProgressBar = null;
    private FrameLayout frameLayout;
    private String mTitle;
    private TextView mTextView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.fox_land_activity);
        initData();
        initWebView();
    }

    private void initData() {
        frameLayout = findViewById(R.id.fragmentLayout);
        mTextView = findViewById(R.id.browser_controller_title);
        ImageButton backBtn = findViewById(R.id.browser_controller_back);
        mProgressBar = (ProgressBar) View.inflate(this, R.layout.fox_progress_horizontal, null);
        mProgressBar.setMax(100);
        mProgressBar.setProgress(0);

        frameLayout.addView(mProgressBar, RelativeLayout.LayoutParams.MATCH_PARENT,
                (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_PX, BAR_HEIGHT,
                        getResources().getDisplayMetrics()));
        backBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                back();
            }
        });
        if (getIntent() != null) {
            mWebUrl = getIntent().getStringExtra(BUNDLE_KEY_URL);
        }
    }

    @SuppressLint("AddJavascriptInterface")
    private void initWebView() {
        if (mWebView == null) {
            mWebView = new FoxBaseSdkWebView(this);
        }
        try {
            mWebView.setFoxWebViewClientAndChromeClient(new FoxWebViewClientAndChromeClient() {
                @Override
                public void onProgressChanged(WebView webView, int newProgress) {
                    super.onProgressChanged(webView, newProgress);
                    try {
                        if (mProgressBar == null) {
                            return;
                        }
                        if (newProgress == LOAD_FINISH_DATA) {
                            mProgressBar.setVisibility(View.GONE);
                        } else {
                            mProgressBar.setVisibility(View.VISIBLE);
                            mProgressBar.setProgress(newProgress);
                        }
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        e.printStackTrace();
                    }
                }

                @SuppressLint("SetTextI18n")
                @Override
                public void onPageFinished(WebView webView, String url) {
                    super.onPageFinished(webView, url);
                    try {
                        if (mWebView == null) {
                            return;
                        }
                        mTitle = mWebView.getTitle();
                        if (mTextView == null || !TextUtils.isEmpty(mTitle)) {
                            return;
                        }
                        if (mTitle.length() >= MAX_TITLE_SIZE) {
                            mTextView.setText(mTitle.substring(0, 7) + "...");
                        } else {
                            mTextView.setText(mTitle);
                        }
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        e.printStackTrace();
                    }
                }

                @Override
                public boolean shouldOverrideUrlLoading(WebView webView, String url) {
                    return WebViewHelper.shouldOverrideUrlLoading(url, webView, true);
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        String ua = mWebView.getSettings().getUserAgentString();
        jsHandler = new JsHandler(this, mWebView);
        mWebView.getSettings().setUserAgentString(ua + "duiba883");
        mWebView.addJavascriptInterface(jsHandler, "TAHandler");
        RelativeLayout.LayoutParams lps = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
        frameLayout.addView(mWebView, lps);
        if (!TextUtils.isEmpty(mWebUrl)) {
            mWebView.loadUrl(mWebUrl);
        }
    }

    @Override
    protected void onDestroy() {
        if(jsHandler != null){
            jsHandler.unregisterBroadcast();
        }

        mWebView.destroy();
        mWebView = null;
        IntegrateH5DownloadManager.getInstance().webviewDestroy();
        super.onDestroy();
    }

    /**
     * 处理页面回退
     */
    public void back() {
        if (mWebView == null || !mWebView.canGoBack()) {
            finish();
            return;
        }
        mWebView.goBack();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.KEYCODE_BACK) {
            back();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public static class JsHandler extends DownloadJsBridgeHandler {

        public JsHandler(Context context, WebView webView) {
            super(context, webView);
        }

    }

}
