package com.mediamain.android.view.video;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.ImageView;

import com.mediamain.android.R;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.webview.FoxBaseSdkWebView;
import com.mediamain.android.view.webview.callback.FoxWebViewClientAndChromeClient;
import com.mediamain.android.view.webview.helper.WebViewHelper;
import com.mediamain.android.view.webview.jsbridge.DownloadJsBridgeHandler;

import static com.mediamain.android.view.FoxActivity.BUNDLE_KEY_URL;

/**
 * Description:
 *
 * @author:Swilliam
 * @date:2020/11/27 17:29
 */

public class FoxVideoDialog extends DialogFragment {

    private FoxBaseSdkWebView mWebView;
    private JsHandler jsHandler;
    private ImageView imageView;
    private OnDialogMessage onDialogMessage;
    private String mUrl;

    public void setOnMessageListener(OnDialogMessage listener) {
        onDialogMessage = listener;
    }

    public static FoxVideoDialog newInstance(Bundle bundle) {
        FoxVideoDialog fragment = new FoxVideoDialog();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(DialogFragment.STYLE_NO_TITLE, R.style.FoxDialogFragmentStyle);
    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog dialog = getDialog();
        if (dialog != null) {
            Window window = dialog.getWindow();
            if (window != null) {
                int width = ViewGroup.LayoutParams.MATCH_PARENT;
                int height = ViewGroup.LayoutParams.MATCH_PARENT;
                window.setLayout(width, height);
            }
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(initRootView(), container, false);
        mWebView = rootView.findViewById(R.id.webView);
        imageView = rootView.findViewById(R.id.iv_background);
        this.setCancelable(false);
        initData();
        initWebView();
        return rootView;
    }

    private int initRootView() {
        return R.layout.fox_dialog_webview;
    }

    @SuppressLint("AddJavascriptInterface")
    private void initWebView() {
        jsHandler = new JsHandler(getContext(), mWebView);
        mWebView.addJavascriptInterface(jsHandler, "TAHandler");
        String ua = mWebView.getSettings().getUserAgentString();
        mWebView.getSettings().setUserAgentString(ua + "duiba882");
        mWebView.setBackgroundColor(Color.BLACK);
        try {
            mWebView.setFoxWebViewClientAndChromeClient(new FoxWebViewClientAndChromeClient() {
                @Override
                public void onPageFinished(WebView webView, String url) {
                    if (imageView.getVisibility() == View.VISIBLE) {
                        imageView.setVisibility(View.GONE);
                    }
                }

                @Override
                public boolean shouldOverrideUrlLoading(WebView webView, String url) {
                    return WebViewHelper.shouldOverrideUrlLoading(url, webView, true);
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        if (!FoxBaseCommonUtils.isEmpty(mUrl)) {
            mWebView.loadUrl(mUrl);
        } else {
            //没有url，退出当前页面
            dismissAllowingStateLoss();
        }
    }

    private void initData() {
        Bundle bundle = getArguments();
        if (bundle == null) {
            return;
        }
        mUrl = bundle.getString(BUNDLE_KEY_URL);
        this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener() {
            @Override
            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_UP) {
                    //有上一级数据，可以直接返回
                    if (mWebView != null && mWebView.canGoBack()) {
                        mWebView.goBack();
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public void onDestroyView() {
        if (jsHandler != null){
            jsHandler.unregisterBroadcast();
        }
        if (mWebView != null) {
            mWebView.onDestroy();
            mWebView = null;
        }
        super.onDestroyView();
    }

    public class JsHandler extends DownloadJsBridgeHandler {

        public JsHandler(Context context, WebView webView) {
            super(context, webView);
        }

        /**
         * 关闭事件监听
         */
        @JavascriptInterface
        public void close() {
            if (getContext() == null) {
                return;
            }
            ((Activity) getContext()).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (!isHidden()) {
                        dismissAllowingStateLoss();
                    }
                }
            });
        }

        @JavascriptInterface
        public void closeLoadingWebview() {
            ((Activity) getContext()).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (imageView.getVisibility() == View.VISIBLE) {
                        imageView.setVisibility(View.GONE);
                    }
                }
            });
        }

        @JavascriptInterface
        public void postMsgToWebview1(final String data) {
            if (getContext() == null) {
                return;
            }
            ((Activity) getContext()).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (onDialogMessage != null && !TextUtils.isEmpty(data)){
                        onDialogMessage.closeMessage(Constants.KEY_VIDEO_DIALOG_CALLBACK_MESSAGE_ONE, data);
                    }
                }
            });
        }

        @JavascriptInterface
        public void closeWebView(final String data) {
            if (getContext() == null) {
                return;
            }
            ((Activity) getContext()).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (onDialogMessage != null && !TextUtils.isEmpty(data)) {
                        onDialogMessage.closeMessage(Constants.KEY_VIDEO_DIALOG_CALLBACK_MESSAGE_TWO, data);
                    }
                    if (!isHidden()) {
                        dismissAllowingStateLoss();
                    }
                }
            });
        }

        @JavascriptInterface
        public void toLandingPage(final String url) {
            if (getContext() == null) {
                return;
            }
            ((Activity) getContext()).runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    Intent intent = new Intent(getContext(), FoxLandActivity.class);
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    intent.putExtra(BUNDLE_KEY_URL, url);
                    getContext().startActivity(intent);
                }
            });
        }
    }

    /**
     * 显示弹窗 防止java.lang.IllegalStateException
     * Can not perform this action after onSaveInstanceStat
     *
     * @param fragmentManager
     * @param tag
     */
    public void showAllowingStateLoss(FragmentManager fragmentManager, String tag) {
        try {
            FragmentTransaction ft = fragmentManager.beginTransaction();
            ft.add(this, tag);
            ft.commitAllowingStateLoss();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

}

