package com.mediamain.android.view.webview;

import android.content.Context;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.mediamain.android.base.download.IntegrateH5DownloadManager;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.webview.callback.FoxWebViewClientAndChromeClient;
import com.mediamain.android.view.webview.settings.FoxWebViewDefaultSettings;
import com.mediamain.android.view.webview.webviewchromeclient.FoxWebViewChromeClient;
import com.mediamain.android.view.webview.webviewclient.FoxWebViewClient;

/**
 * Description:
 * Date:2020/11/26 14:47
 *
 * @author swilliam
 */
public class FoxBaseSdkWebView extends WebView {

    public FoxBaseSdkWebView(Context context) {
        super(context);
        init();
    }

    public FoxBaseSdkWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public FoxBaseSdkWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public FoxBaseSdkWebView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    /**
     * 设置WebView基本数据监听回调
     *
     * @param mFoxWebViewClientAndChromeClient FoxWebViewClientAndChromeClient实现类
     */
    public void setFoxWebViewClientAndChromeClient(FoxWebViewClientAndChromeClient mFoxWebViewClientAndChromeClient) throws NullPointerException {
        if (mFoxWebViewClientAndChromeClient == null) {
            throw new NullPointerException("FoxWebViewClientAndChromeClient cant not be null");
        }
        super.setWebChromeClient(new FoxWebViewChromeClient(mFoxWebViewClientAndChromeClient));
        super.setWebViewClient(new FoxWebViewClient(mFoxWebViewClientAndChromeClient));
    }

    private void init() {
        FoxWebViewDefaultSettings.getInstance().setWebViewSetting(this);
        setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
        setDownloadListener(new DownloadListener() {
            @Override
            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                IntegrateH5DownloadManager.getInstance().defaultDownload(url, "", "", "");
            }
        });
    }

    /**
     * 方法被注销，不再对外使用
     */
    @Deprecated
    @Override
    public void setWebViewClient(WebViewClient client) {
    }

    /**
     * 方法被注销，不再对外使用
     */
    @Deprecated
    @Override
    public void setWebChromeClient(WebChromeClient client) {
    }

    /**
     * 销毁webView中调用
     */
    public void onDestroy() {
        try {
            ViewParent parent = this.getParent();
            if (parent != null) {
                ((ViewGroup) parent).removeView(this);
            }
            this.clearHistory();
            this.removeAllViews();
            this.destroy();
        } catch (Exception exception) {
            FoxBaseCrashUtils.reportErrorData(exception);
            exception.printStackTrace();
        }
    }


}
